/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.regex.Matcher;
import oracle.apexlang.APEXLangCompiler;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.Transpiler;

public class APEXLangStringDataType
implements APEXLangDataType {
    private String data;
    private String outputType;
    private boolean isCentral;
    private String refAppId;
    private boolean notFlag;
    private boolean supportsNotFlag;
    private String pluginExternalIdentifier;

    public APEXLangStringDataType(String data, String outputType) {
        this.data = data.startsWith("\"") && data.endsWith("\"") && data.length() > 1 ? data.substring(1, data.length() - 1) : data;
        this.outputType = outputType;
        this.refAppId = "";
        this.notFlag = false;
        this.supportsNotFlag = false;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        String result = this.data;
        if (this.outputType != null && (this.outputType.equals("integer") || this.outputType.equals("number") || this.outputType.equals("blob"))) {
            return Transpiler.replaceAllSafely(template, bindVariable, result);
        }
        if ("boolean".equals(this.outputType)) {
            result = this.data.equals("Y") ? "true" : "false";
            return Transpiler.replaceAllSafely(template, bindVariable, result);
        }
        Matcher m = APEXLangCompiler.MLT_REGEX.matcher(this.data);
        if (m.matches() && m.group(2) != null) {
            String extractedMLString = m.group(2);
            String[] lines = extractedMLString.split("\\r?\\n|\\r", -1);
            Object join = "";
            int start = 0;
            int end = lines.length - 1;
            if (lines[0].trim().isEmpty()) {
                start = 1;
            }
            if (lines[end].trim().isEmpty()) {
                --end;
            }
            if (lines.length > 0 && start <= end) {
                int i;
                int minWhiteSpaces = extractedMLString.length();
                for (i = start; i <= end; ++i) {
                    int whiteSpaces = lines[i].length() - lines[i].stripLeading().length();
                    if (lines[i].trim().isEmpty() || whiteSpaces >= minWhiteSpaces) continue;
                    minWhiteSpaces = whiteSpaces;
                }
                for (i = start; i <= end; ++i) {
                    String line = "";
                    if (lines[i].length() > minWhiteSpaces) {
                        line = lines[i].substring(minWhiteSpaces).replaceAll("'", "''").replaceAll("\\\\```", "```");
                    }
                    join = (String)join + "\n'" + line + "'";
                    if (i >= end) continue;
                    join = (String)join + ",";
                }
                return Transpiler.replaceAllSafely(template, bindVariable, "wwv_flow_string.join(wwv_flow_t_varchar2(" + (String)join + "))");
            }
            return "''";
        }
        result = Transpiler.replaceAllSafely(template, bindVariable, "'" + result.replaceAll("'", "''") + "'");
        result = Transpiler.replaceAllSafely(result, ":is_central", this.isCentral ? "true" : "false");
        result = Transpiler.replaceAllSafely(result, ":ref_app_id", this.refAppId);
        if (this.supportsNotFlag) {
            result = Transpiler.replaceAllSafely(result, ":is_not", this.notFlag ? "true" : "false");
        }
        if (this.pluginExternalIdentifier != null) {
            result = Transpiler.replaceAllSafely(result, ":plugin_external_identifier", "'" + this.pluginExternalIdentifier + "'");
        }
        return result;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setSupportsNotFlag(boolean supportsNotFlag) {
        this.supportsNotFlag = supportsNotFlag;
    }

    public void setCentral(boolean isCentral) {
        this.isCentral = isCentral;
    }

    public void setRefAppId(String refAppId) {
        this.refAppId = refAppId;
    }

    public void setNotFlag(boolean notFlag) {
        this.notFlag = notFlag;
    }

    public String getRefAppId() {
        return this.refAppId;
    }

    public String getData() {
        return this.data;
    }

    public void setPluginExternalIdentifier(String pluginExternalIdentifier) {
        this.pluginExternalIdentifier = pluginExternalIdentifier;
    }

    public String toString() {
        return this.data;
    }
}

