/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.Transpiler;

public class APEXLangDateDataType
implements APEXLangDataType {
    private String outputType;
    private String data;

    public APEXLangDateDataType(String data, String outputType) throws APEXLangException {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            LocalDateTime.parse(data, formatter);
            this.outputType = outputType;
            this.data = data;
        }
        catch (DateTimeParseException x) {
            throw new APEXLangException("Invalid date: " + data + " Example of valid format is 2011-12-03T10:15:30");
        }
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        return Transpiler.replaceAllSafely(template, bindVariable, Transpiler.replaceAllSafely("to_date(':dateValue', 'YYYY-MM-DD\"T\"HH24:MI:SS')", ":dateValue", this.data));
    }

    public String toString() {
        return this.data;
    }
}

