/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangArrayDataType;
import oracle.apexlang.core.APEXLangBooleanDataType;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangDateDataType;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.APEXLangIntegerDataType;
import oracle.apexlang.core.APEXLangNumberDataType;
import oracle.apexlang.core.APEXLangStringDataType;

public class APEXLangDataTypeFactory {
    public static APEXLangDataType createDataType(String value, String dataType, String outputType) throws APEXLangException {
        switch (dataType) {
            case "string": 
            case "": {
                return new APEXLangStringDataType(value, outputType);
            }
            case "number": {
                return new APEXLangNumberDataType(value, outputType);
            }
            case "integer": {
                return new APEXLangIntegerDataType(value, outputType);
            }
            case "datetime": {
                return new APEXLangDateDataType(value, outputType);
            }
        }
        throw new APEXLangException("Invalid dataType: " + dataType);
    }

    public static APEXLangDataType createDataType(String value, String dataType, String yesValue, String noValue, String outputType, boolean isArray, String multivalueDelimiter) throws APEXLangException {
        if (isArray) {
            return APEXLangDataTypeFactory.createDataType(value.split("\n"), dataType, yesValue, noValue, outputType, multivalueDelimiter);
        }
        if (!dataType.equals("boolean")) {
            return APEXLangDataTypeFactory.createDataType(value, dataType, outputType);
        }
        return new APEXLangBooleanDataType(value, yesValue, noValue, outputType);
    }

    private static APEXLangArrayDataType createDataType(String[] values, String dataType, String yesValue, String noValue, String outputType, String multivalueDelimiter) throws APEXLangException {
        APEXLangDataType[] data = new APEXLangDataType[values.length];
        int i = 0;
        for (String value : values) {
            data[i++] = APEXLangDataTypeFactory.createDataType(value.trim(), dataType, yesValue, noValue, outputType, false, "");
        }
        return new APEXLangArrayDataType(data, multivalueDelimiter);
    }
}

