/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.Transpiler;

public class APEXLangBooleanDataType
implements APEXLangDataType {
    private boolean internalBoolean;
    private String yesValue;
    private String noValue;
    private String outputType;

    public APEXLangBooleanDataType(String data, String yesValue, String noValue, String outputType) throws APEXLangException {
        if (!"true".equals(data) && !"false".equals(data)) {
            throw new APEXLangException("Invalid boolean type: " + data);
        }
        this.internalBoolean = "true".equals(data);
        this.yesValue = yesValue;
        this.noValue = noValue;
        this.outputType = outputType;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        Object result;
        Object object = result = this.internalBoolean ? "true" : "false";
        if (this.outputType == null || this.outputType.equals("string")) {
            Object object2 = result = this.internalBoolean ? "'" + this.yesValue + "'" : "'" + this.noValue + "'";
        }
        if (this.outputType != null && this.outputType.equals("number")) {
            result = this.internalBoolean ? this.yesValue : this.noValue;
        }
        return Transpiler.replaceAllSafely(template, bindVariable, (String)result);
    }

    public String toString() {
        return this.internalBoolean ? this.yesValue : this.noValue;
    }

    public boolean booleanValue() {
        return this.internalBoolean;
    }
}

