/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetInput;
import com.oracle.bmc.recovery.model.UpdateProtectedDatabaseDetails;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseCompartmentRequest;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.DatabaseUser;
import oracle.dbtools.extension.rcv.models.database.DatabaseMetadataCache;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.FullDatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.security.pki.OracleSecretStoreException;

public class UpdateProtectedDatabaseStep
implements Step {
    private RecoveryClientManager recoveryClientManager;
    private WorkflowLogger logger;
    private String protectedDatabaseId;
    private char[] password;
    private Boolean realtimeRedo;
    private String protectionPolicyId;
    private String compartmentId;
    private List<RecoveryServiceSubnetInput> recoverySubnets;

    public UpdateProtectedDatabaseStep(String endpoint, String protectedDatabaseId, WorkflowLogger logger) {
        this.protectedDatabaseId = protectedDatabaseId;
        this.recoveryClientManager = new RecoveryClientManager(endpoint, logger.getLogger());
        this.logger = logger;
    }

    public UpdateProtectedDatabaseStep password(char[] password) {
        this.password = password;
        return this;
    }

    public UpdateProtectedDatabaseStep protectionPolicyId(String protectionPolicyId) {
        this.protectionPolicyId = protectionPolicyId;
        return this;
    }

    public UpdateProtectedDatabaseStep recoveryServiceSubnets(List<RecoveryServiceSubnetInput> subnets) {
        this.recoverySubnets = subnets;
        return this;
    }

    public UpdateProtectedDatabaseStep realtimeRedo(boolean realtimeRedo) {
        this.realtimeRedo = realtimeRedo;
        return this;
    }

    public UpdateProtectedDatabaseStep compartmentId(String compartmentId) {
        this.compartmentId = compartmentId;
        return this;
    }

    @Override
    public Result run() {
        UpdateProtectedDatabaseResponse response;
        if (this.compartmentId != null || this.realtimeRedo != null || this.password != null || this.protectionPolicyId != null || this.recoverySubnets != null && !this.recoverySubnets.isEmpty()) {
            UpdateProtectedDatabaseDetails updateProtectedDatabaseDetails = this.getUpdateProtectedDatabaseDetails();
            try {
                response = this.recoveryClientManager.updateProtectedDatabase(updateProtectedDatabaseDetails, this.protectedDatabaseId);
                int httpStatusCode = response.get__httpStatusCode__();
                if (httpStatusCode < 200 || httpStatusCode >= 300) {
                    this.logger.log(Level.FINE, "Failed to update protected database " + this.protectedDatabaseId);
                    return Result.updProtectedDatabaseHttpError(this.protectedDatabaseId);
                }
                this.logger.log(Level.FINE, "Waiting for protected database state to change to Active...");
                ProtectedDatabase db = this.recoveryClientManager.waitForProtectedDatabaseUpdate(this.protectedDatabaseId, 300, 5);
                if (!db.getLifecycleState().equals((Object)LifecycleState.Active)) {
                    return Result.updResourceStatusTmt("protected database", this.protectedDatabaseId);
                }
                this.logger.log(Level.FINE, "Successfully updated protected database.");
            }
            catch (Exception e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.updProtectedDatabaseCallError();
            }
        }
        if (this.password != null && this.password.length != 0) {
            Optional<String> dbUniqueNameOptional = RCVCommandBase.getDbUniqueNameFromOcid(this.protectedDatabaseId);
            if (dbUniqueNameOptional.isPresent()) {
                String dbUniqueName = dbUniqueNameOptional.get();
                ProtectedDatabaseCache cache = RCVCommandBase.getProtectedDatabaseCache(dbUniqueName);
                DatabaseUser vpcUser = new DatabaseUser(cache.getVpcUserName(), this.password);
                List<String> aliases = cache.getRecoveryApplianceAliases();
                String walletLocation = cache.getWalletLocation();
                String parentDirectory = String.valueOf(Paths.get(walletLocation, new String[0]).getParent());
                String newWalletLocation = String.join((CharSequence)File.separator, parentDirectory, walletLocation + "2");
                for (String alias : aliases) {
                    try {
                        vpcUser.storePassword(walletLocation, alias);
                    }
                    catch (IOException | OracleSecretStoreException e) {
                        Workflow.logException(e, this.logger.getLogger());
                        return Result.updVpcWalletError(walletLocation);
                    }
                }
                Optional<FullDatabaseConfig> dbConfigHolder = FullDatabaseConfig.getDatabaseConfig(dbUniqueName);
                if (dbConfigHolder.isPresent()) {
                    FullDatabaseConfig dbConfig = dbConfigHolder.get();
                    List<SshHelper> sshConnections = dbConfig.getSshConnections();
                    for (SshHelper sshConnection : sshConnections) {
                        sshConnection.copy(walletLocation, walletLocation);
                    }
                } else {
                    String connectionName = FleetAgentContext.get(dbUniqueName).getConnectionName();
                    Optional<Connection> sysbackupConnOptional = NamedConnectionsManager.getConnection(connectionName);
                    if (sysbackupConnOptional.isPresent()) {
                        Connection sysbackupConn = sysbackupConnOptional.get();
                        DatabaseMetadataCache dbMetadataCache = RCVCommandBase.getDatabase(sysbackupConn).getDatabaseMetadataCache();
                        List<SshHelper> sshConnections = dbMetadataCache.getSshConnections();
                        for (SshHelper sshConnection : sshConnections) {
                            sshConnection.copy(walletLocation, walletLocation);
                        }
                    }
                }
            } else {
                return new Result(Status.FAILED, "Failed to update VPC password. Protected database with ID " + this.protectedDatabaseId + " not found.");
            }
        }
        if (this.compartmentId != null) {
            ChangeProtectedDatabaseCompartmentRequest request = this.recoveryClientManager.changeProtectedDatabaseCompartmentRequest(this.protectedDatabaseId, this.compartmentId);
            this.logger.log(Level.FINE, request.toString());
            response = this.recoveryClientManager.changeProtectedDatabaseCompartment(request);
            this.logger.log(Level.FINE, response.toString());
            this.logger.log(Level.INFO, "Changing protected database compartment");
            LifecycleState state = this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> this.recoveryClientManager.getProtectedDatabase(this.protectedDatabaseId).getLifecycleState());
            if (state.equals((Object)LifecycleState.Updating)) {
                return Result.updResourceStatusTmt("protected database", this.protectedDatabaseId);
            }
            if (!state.equals((Object)LifecycleState.Active)) {
                return Result.verifyLifecycleStatusError("protected database", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Updating.getValue());
            }
        }
        return new Result(Status.SUCCESS);
    }

    private UpdateProtectedDatabaseDetails getUpdateProtectedDatabaseDetails() {
        UpdateProtectedDatabaseDetails.Builder bodyBuilder = UpdateProtectedDatabaseDetails.builder();
        if (this.protectionPolicyId != null) {
            bodyBuilder.protectionPolicyId(this.protectionPolicyId);
        }
        if (this.recoverySubnets != null && !this.recoverySubnets.isEmpty()) {
            bodyBuilder.recoveryServiceSubnets(this.recoverySubnets);
        }
        if (this.realtimeRedo != null) {
            bodyBuilder.isRedoLogsShipped(this.realtimeRedo);
        }
        if (this.password != null && this.password.length != 0) {
            bodyBuilder.password(new String(this.password));
        }
        return bodyBuilder.build();
    }
}

