/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.WalletEntry;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.UserDefinedInput;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleWallet;

public class InputConfig
implements UserDefinedInput,
DatabaseConfig {
    private static final String ENDPOINT = "recoveryServiceEndpoint";
    private static final String DB_UNIQUE_NAME = "dbUniqueName";
    private static final String DISPLAY_NAME = "displayName";
    private static final String COMPARTMENT_ID = "compartmentId";
    private static final String PROTECTION_POLICY = "protectionPolicy";
    private static final String SBT_LIBRARY = "sbtLibrary";
    private static final String RECOVERY_SERVICE_SUBNETS = "recoveryServiceSubnets";
    private static final String COMPRESSION_RATIO = "compressionRatio";
    private static final String CHANGE_RATE = "changeRate";
    private static final String ORACLE_HOME = "oracleHome";
    private static final String ORACLE_SID = "oracleSid";
    private static final String DRY_RUN = "dryRun";
    private static final String REALTIME_REDO = "realtimeRedo";
    private static final String WALLET = "wallet";
    private static final String ALIAS = "alias";
    private static final String DATABASE_ID = "databaseId";
    private String endpoint;
    private String dbUniqueName;
    private String displayName;
    private String compartmentId;
    private String protectionPolicy;
    private String sbtLibrary;
    private List<String> recoveryServiceSubnets;
    private Double compressionRatio;
    private Double changeRate;
    private String oracleHome;
    private String oracleSid;
    private boolean dryRun;
    private boolean realtimeRedo;
    private String walletLocation;
    private String alias;
    private char[] password;
    private String databaseId;

    private InputConfig(Builder builder) {
        this.endpoint = builder.endpoint;
        this.dbUniqueName = builder.dbUniqueName;
        this.displayName = builder.displayName;
        this.compartmentId = builder.compartmentId;
        this.protectionPolicy = builder.protectionPolicy;
        this.recoveryServiceSubnets = builder.recoveryServiceSubnets;
        this.sbtLibrary = builder.sbtLibrary;
        this.compressionRatio = builder.compressionRatio;
        this.changeRate = builder.changeRate;
        this.oracleHome = builder.oracleHome;
        this.oracleSid = builder.oracleSid;
        this.realtimeRedo = builder.realtimeRedo;
        this.dryRun = builder.dryRun;
        this.walletLocation = builder.wallet;
        this.alias = builder.alias;
        this.databaseId = builder.databaseId;
        if (builder.password != null) {
            this.setPassword(builder.password);
        } else {
            this.setPassword();
        }
    }

    public JsonObjectBuilder toJsonObjectBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder().add(DB_UNIQUE_NAME, this.dbUniqueName);
        if (this.endpoint != null) {
            builder.add(ENDPOINT, this.endpoint);
        }
        if (this.displayName != null) {
            builder.add(DISPLAY_NAME, this.displayName);
        }
        if (this.compartmentId != null) {
            builder.add(COMPARTMENT_ID, this.compartmentId);
        }
        if (this.protectionPolicy != null) {
            builder.add(PROTECTION_POLICY, this.protectionPolicy);
        }
        if (this.sbtLibrary != null) {
            builder.add(SBT_LIBRARY, this.sbtLibrary);
        }
        if (this.compressionRatio != null) {
            builder.add(COMPRESSION_RATIO, this.compressionRatio.doubleValue());
        }
        if (this.changeRate != null) {
            builder.add(CHANGE_RATE, this.changeRate.doubleValue());
        }
        if (this.oracleHome != null) {
            builder.add(ORACLE_HOME, this.oracleHome);
        }
        if (this.oracleSid != null) {
            builder.add(ORACLE_SID, this.oracleSid);
        }
        if (this.dryRun) {
            builder.add(DRY_RUN, true);
        }
        if (this.realtimeRedo) {
            builder.add(REALTIME_REDO, true);
        }
        if (this.walletLocation != null) {
            builder.add(WALLET, this.walletLocation);
        }
        if (this.alias != null) {
            builder.add(ALIAS, this.alias);
        }
        if (this.databaseId != null) {
            builder.add(DATABASE_ID, this.databaseId);
        }
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        this.recoveryServiceSubnets.forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        builder.add(RECOVERY_SERVICE_SUBNETS, arrayBuilder);
        return builder;
    }

    public void write(String jsonFile) {
        JsonObjectBuilder builder = this.toJsonObjectBuilder();
        File f = new File(jsonFile);
        Map<String, Boolean> jsonWriterConfig = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(jsonWriterConfig);
        try (JsonWriter jsonWriter = writerFactory.createWriter((OutputStream)new FileOutputStream(f));){
            jsonWriter.writeObject(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create config JSON", e);
        }
    }

    public static List<InputConfig> load(String jsonFile) {
        File f = new File(jsonFile);
        ArrayList<InputConfig> databaseConfigs = new ArrayList<InputConfig>();
        if (Files.exists(Paths.get(jsonFile, new String[0]), new LinkOption[0])) {
            JsonArray jsonArray;
            try (FileInputStream fileStream = new FileInputStream(f);
                 JsonReader jsonReader = Json.createReader((InputStream)fileStream);){
                jsonArray = jsonReader.readArray();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to parse json " + jsonFile, e);
            }
            for (JsonValue databaseJson : jsonArray) {
                if (databaseJson.getValueType() != JsonValue.ValueType.OBJECT) continue;
                JsonObject jsonObject = (JsonObject)databaseJson;
                if (!jsonObject.containsKey((Object)DB_UNIQUE_NAME) || !jsonObject.containsKey((Object)RECOVERY_SERVICE_SUBNETS)) {
                    String error = String.format("The provided JSON is invalid. It is missing required fields %s and/or %s", DB_UNIQUE_NAME, RECOVERY_SERVICE_SUBNETS);
                    throw new IllegalArgumentException(error);
                }
                ArrayList<String> subnetsList = new ArrayList<String>();
                JsonArray subnetsJsonArray = jsonObject.getJsonArray(RECOVERY_SERVICE_SUBNETS);
                for (JsonValue value : subnetsJsonArray) {
                    if (value.getValueType() == JsonValue.ValueType.STRING) {
                        subnetsList.add(((JsonString)value).getString());
                        continue;
                    }
                    String error = String.format("The provided JSON is invalid. The % field must be a list of strings.", RECOVERY_SERVICE_SUBNETS);
                    throw new IllegalArgumentException(error);
                }
                Builder builder = new Builder(jsonObject.getString(DB_UNIQUE_NAME), subnetsList);
                if (jsonObject.containsKey((Object)ENDPOINT)) {
                    builder.endpoint(jsonObject.getString(ENDPOINT));
                }
                if (jsonObject.containsKey((Object)COMPARTMENT_ID)) {
                    builder.compartmentId(jsonObject.getString(COMPARTMENT_ID));
                }
                if (jsonObject.containsKey((Object)DISPLAY_NAME)) {
                    builder.displayName(jsonObject.getString(DISPLAY_NAME));
                }
                if (jsonObject.containsKey((Object)PROTECTION_POLICY)) {
                    builder.protectionPolicyId(jsonObject.getString(PROTECTION_POLICY));
                }
                if (jsonObject.containsKey((Object)SBT_LIBRARY)) {
                    builder.sbtLibrary(jsonObject.getString(SBT_LIBRARY));
                }
                if (jsonObject.containsKey((Object)COMPRESSION_RATIO)) {
                    builder.compressionRatio(jsonObject.getJsonNumber(COMPRESSION_RATIO).doubleValue());
                }
                if (jsonObject.containsKey((Object)CHANGE_RATE)) {
                    builder.changeRate(jsonObject.getJsonNumber(CHANGE_RATE).doubleValue());
                }
                if (jsonObject.containsKey((Object)ORACLE_HOME)) {
                    builder.oracleHome(jsonObject.getString(ORACLE_HOME));
                }
                if (jsonObject.containsKey((Object)ORACLE_SID)) {
                    builder.oracleSid(jsonObject.getString(ORACLE_SID));
                }
                if (jsonObject.containsKey((Object)DRY_RUN)) {
                    builder.dryRun(jsonObject.getBoolean(DRY_RUN));
                }
                if (jsonObject.containsKey((Object)REALTIME_REDO)) {
                    builder.realtimeRedo(jsonObject.getBoolean(REALTIME_REDO));
                }
                if (jsonObject.containsKey((Object)WALLET)) {
                    builder.wallet(jsonObject.getString(WALLET));
                }
                if (jsonObject.containsKey((Object)ALIAS)) {
                    builder.alias(jsonObject.getString(ALIAS));
                }
                if (jsonObject.containsKey((Object)DATABASE_ID)) {
                    builder.databaseId(jsonObject.getString(DATABASE_ID));
                }
                databaseConfigs.add(builder.build());
            }
            return databaseConfigs;
        }
        String error = jsonFile + " does not exist!";
        throw new RuntimeException(error);
    }

    public static void write(List<InputConfig> inputConfigs, String jsonFile) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (InputConfig inputConfig : inputConfigs) {
            JsonObjectBuilder configBuilder = inputConfig.toJsonObjectBuilder();
            arrayBuilder.add(configBuilder);
        }
        File f = new File(jsonFile);
        Utils.createParentDirectoryForFile(jsonFile);
        Map<String, Boolean> jsonWriterConfig = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(jsonWriterConfig);
        try (JsonWriter jsonWriter = writerFactory.createWriter((OutputStream)new FileOutputStream(f));){
            jsonWriter.writeArray(arrayBuilder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create config JSON", e);
        }
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getDbUniqueName() {
        return this.dbUniqueName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getCompartmentId() {
        return this.compartmentId;
    }

    @Override
    public String getProtectionPolicy() {
        return this.protectionPolicy;
    }

    @Override
    public List<String> getRecoveryServiceSubnets() {
        return this.recoveryServiceSubnets;
    }

    @Override
    public String getSbtLibrary() {
        return this.sbtLibrary;
    }

    @Override
    public Double getCompressionRatio() {
        return this.compressionRatio;
    }

    @Override
    public Double getChangeRate() {
        return this.changeRate;
    }

    @Override
    public String getOracleHome() {
        return this.oracleHome;
    }

    @Override
    public String getOracleSid() {
        return this.oracleSid;
    }

    @Override
    public boolean getDryRun() {
        return this.dryRun;
    }

    @Override
    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getDatabaseId() {
        return this.databaseId;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public void setPassword() {
        if (this.walletLocation != null) {
            OracleWallet wallet = WalletManager.getWallet(this.walletLocation);
            if (this.alias != null) {
                char[] passwordCharArray = WalletManager.getSecretForAlias(wallet, this.alias);
                if (passwordCharArray != null) {
                    this.password = passwordCharArray;
                }
            } else {
                HashMap<String, WalletEntry> entries = WalletManager.getWalletEntries(wallet);
                if (entries.keySet().isEmpty()) {
                    String error = String.format("The specified wallet %s is empty. Please store the credentials for the VPC user in this wallet.", wallet);
                    throw new IllegalArgumentException(error);
                }
                if (entries.keySet().size() > 1) {
                    String error = String.format("The specified wallet %s has multiple entries. Please specify the alias for the vpc user with '-alias <vpc_user_alias>'", wallet);
                    throw new IllegalArgumentException(error);
                }
                for (String id : entries.keySet()) {
                    this.password = entries.get(id).getPassword();
                }
            }
        }
    }

    public ParsedCommand toParsedCommand(ScriptRunnerContext ctx) {
        RCVCommand addDbCommand = new RCVCommand(RCVCommand.SubCommand.ADD_DATABASE);
        if (this.compartmentId != null) {
            addDbCommand.addOption(RCVOptions.Options.COMPARTMENT_ID, this.compartmentId);
        }
        if (this.protectionPolicy != null) {
            addDbCommand.addOption(RCVOptions.Options.PROTECTION_POLICY_ID, this.protectionPolicy);
        }
        if (!this.recoveryServiceSubnets.isEmpty()) {
            addDbCommand.addOption(RCVOptions.Options.RECOVERY_SERVICE_SUBNETS, String.join((CharSequence)",", this.recoveryServiceSubnets));
        }
        if (this.sbtLibrary != null) {
            addDbCommand.addOption(RCVOptions.Options.SBT_LIBRARY, this.sbtLibrary);
        }
        if (this.compressionRatio != null) {
            addDbCommand.addOption(RCVOptions.Options.COMPRESSION_RATIO, String.valueOf(this.compressionRatio));
        }
        if (this.changeRate != null) {
            addDbCommand.addOption(RCVOptions.Options.CHANGE_RATE, String.valueOf(this.changeRate));
        }
        return addDbCommand.build(ctx);
    }

    protected static class Builder {
        private String endpoint;
        private String dbUniqueName;
        private String displayName;
        private String compartmentId;
        private String protectionPolicy;
        private String sbtLibrary;
        private List<String> recoveryServiceSubnets;
        private Double compressionRatio;
        private Double changeRate;
        private String oracleHome;
        private String oracleSid;
        private boolean dryRun;
        private boolean realtimeRedo;
        private String wallet;
        private String alias;
        private char[] password;
        private String databaseId;

        public Builder(String dbUniqueName, List<String> recoveryServiceSubnets) {
            this.dbUniqueName = dbUniqueName;
            this.displayName = dbUniqueName;
            this.recoveryServiceSubnets = recoveryServiceSubnets;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder protectionPolicyId(String protectionPolicy) {
            this.protectionPolicy = protectionPolicy;
            return this;
        }

        public Builder sbtLibrary(String sbtLibrary) {
            this.sbtLibrary = sbtLibrary;
            return this;
        }

        public Builder compressionRatio(Double compressionRatio) {
            this.compressionRatio = compressionRatio;
            return this;
        }

        public Builder changeRate(Double changeRate) {
            this.changeRate = changeRate;
            return this;
        }

        public Builder oracleHome(String oracleHome) {
            this.oracleHome = oracleHome;
            return this;
        }

        public Builder oracleSid(String oracleSid) {
            this.oracleSid = oracleSid;
            return this;
        }

        public Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public Builder realtimeRedo(boolean realtimeRedo) {
            this.realtimeRedo = realtimeRedo;
            return this;
        }

        public Builder wallet(String wallet) {
            this.wallet = wallet;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }

        public InputConfig build() {
            return new InputConfig(this);
        }
    }
}

