/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import com.oracle.bmc.database.model.DatabaseSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.oci.DatabaseClientManager;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.AddDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.CommandLineInput;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.InputConfig;

public class AutoDiscoverDatabasesUtils {
    public static List<InputConfig> generateInputConfigs(List<? extends DatabaseConfig> databaseConfigs, CommandLineInput input) {
        ArrayList<InputConfig> inputConfigs = new ArrayList<InputConfig>();
        GlobalMetadata globalMetadata = GlobalMetadata.load();
        boolean inOci = globalMetadata.getSystemType().equals("OCI");
        for (DatabaseConfig databaseConfig : databaseConfigs) {
            Optional<String> defaultSbtLibrary;
            String sbtLibrary = input.getSbtLibrary();
            if (sbtLibrary == null && (defaultSbtLibrary = AddDatabaseWorkflow.getDefaultSbtLibrary(databaseConfig.getDbUniqueName())).isPresent()) {
                sbtLibrary = defaultSbtLibrary.get();
            }
            InputConfig.Builder builder = new InputConfig.Builder(databaseConfig.getDbUniqueName(), input.getRecoveryServiceSubnets()).oracleHome(databaseConfig.getOracleHome()).oracleSid(databaseConfig.getOracleSid()).endpoint(input.getEndpoint()).compartmentId(input.getCompartmentId()).protectionPolicyId(input.getProtectionPolicy()).compressionRatio(input.getCompressionRatio()).changeRate(input.getChangeRate()).sbtLibrary(sbtLibrary).displayName(databaseConfig.getDbUniqueName()).realtimeRedo(input.getRealtimeRedo()).password(input.getPassword()).wallet(input.getWallet()).alias(input.getAlias()).dryRun(input.getDryRun());
            if (inOci) {
                DatabaseClientManager databaseClientManager;
                DatabaseSummary dbSummary;
                String dbId = input.getDatabaseId();
                if (dbId == null && (dbSummary = (databaseClientManager = new DatabaseClientManager(globalMetadata.getAuthentication())).getDatabaseSummary(databaseConfig.getDbUniqueName())) != null) {
                    dbId = dbSummary.getId();
                }
                builder = builder.databaseId(dbId);
            }
            InputConfig inputConfig = builder.build();
            inputConfigs.add(inputConfig);
        }
        return inputConfigs;
    }
}

