/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.utils.LogManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.FileLocker;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class Workflow
implements Step {
    public static boolean REQUIRES_CONNECTION = false;
    private RCVCommand.SubCommand rcvCommand;
    private ScriptRunnerContext ctx;
    private Status status;
    private WorkflowLogger logger;
    private Connection conn;
    private List<Step> steps;

    public Workflow(RCVCommand.SubCommand rcvCommand, Connection conn, ScriptRunnerContext ctx) {
        this.rcvCommand = rcvCommand;
        this.conn = conn;
        this.ctx = ctx;
        this.status = Status.NOT_STARTED;
        this.steps = new ArrayList<Step>();
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public WorkflowLogger getWorkflowLogger() {
        if (this.logger == null) {
            String logFile;
            if (this.conn == null) {
                logFile = LogManager.getLogFile(this.rcvCommand.toString());
            } else {
                String dbUniqueName = RCVCommandBase.getDbUniqueName(this.conn);
                logFile = LogManager.getLogFile(this.rcvCommand.toString(), dbUniqueName);
            }
            this.logger = LogManager.getLogger(logFile);
        }
        return this.logger;
    }

    public void initState() {
    }

    public RCVCommand.SubCommand getRcvCommand() {
        return this.rcvCommand;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public ScriptRunnerContext getContext() {
        return this.ctx;
    }

    public void setLogger(WorkflowLogger logger) {
        this.logger = logger;
    }

    public void logException(Throwable e) {
        Workflow.logException(e, this.getWorkflowLogger().getLogger());
    }

    public static void logException(Throwable e, Logger logger) {
        if (e == null) {
            return;
        }
        if (logger == null) {
            return;
        }
        logger.log(Level.INFO, Utils.getFirstString(Objects.toString(e.getMessage(), e.toString())).replaceFirst("^Error: ", ""));
        logger.log(Level.FINE, "-".repeat(50), e);
        logger.log(Level.FINE, "-".repeat(50));
    }

    public void logExceptionMessage(Throwable e) {
        this.getWorkflowLogger();
        if (e == null) {
            return;
        }
        if (this.logger == null) {
            return;
        }
        this.logger.log(Level.INFO, Utils.getFirstString(Objects.toString(e.getMessage(), e.toString())).replaceFirst("^Error: ", ""));
    }

    public void logResult(Result result) {
        this.logger = this.getWorkflowLogger();
        if (this.logger == null) {
            return;
        }
        if (result.getMessage() != null) {
            this.logger.log(Level.WARNING, result.getMessage());
        }
        if (result.getStatus().equals((Object)Status.FAILED)) {
            this.logger.log(Level.INFO, "Please see " + this.logger.getLogFile() + " for more details.");
        }
    }

    public void handleFailure() {
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public String getLockFileName() {
        return null;
    }

    public int getLockTimeout() {
        return 0;
    }

    public Result run(boolean verbose) {
        this.getWorkflowLogger();
        if (verbose) {
            this.logger.log(Level.INFO, "Log file: " + this.logger.getLogFile());
        }
        this.initState();
        int numSteps = this.steps.size();
        boolean printProgress = verbose && numSteps > 1;
        for (int i = 0; i < numSteps; ++i) {
            Result stepResult;
            Status status;
            Step step = this.steps.get(i);
            if (printProgress) {
                String progress = String.format("Start - step %d of %d", i + 1, numSteps);
                this.logger.log(Level.INFO, progress);
            }
            if ((status = (stepResult = step.run()).getStatus()).equals((Object)Status.FAILED) || status.equals((Object)Status.TIMED_OUT)) {
                this.logger.log(Level.INFO, status.toString());
                return stepResult;
            }
            if (status.equals((Object)Status.SKIPPED)) {
                this.logger.log(Level.FINE, stepResult.getMessage());
            }
            if (!printProgress) continue;
            this.logger.log(Level.INFO, status.toString());
            this.logger.log(Level.INFO, String.valueOf('-').repeat(50));
        }
        return new Result(Status.SUCCESS);
    }

    public Result runWithLock(boolean verbose) {
        String lockFileName = this.getLockFileName();
        if (lockFileName != null) {
            Optional<Result> possibleResult = new FileLocker(lockFileName, this.getLockTimeout()).execute(() -> this.run(verbose), otherProcess -> this.logger.log(Level.INFO, "Process " + otherProcess + " is running the same command."));
            return possibleResult.orElseGet(() -> new Result(Status.FAILED, "There is another process running the same command. Exiting."));
        }
        return this.run(verbose);
    }

    @Override
    public Result run() {
        return this.runWithLock(true);
    }
}

