/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ShowRestoreRangeWorkflow
extends ProtectedDatabaseWorkflow {
    public ShowRestoreRangeWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.SHOW_RESTORE_RANGE, conn, ctx);
    }

    @Override
    public Result run(boolean verbose) {
        WorkflowLogger logger = this.getWorkflowLogger();
        if (verbose) {
            logger.log(Level.INFO, "Log file: " + logger.getLogFile());
        }
        Database database = this.getDatabase();
        String dbUniqueName = database.getDbUniqueName();
        String WHO_AM_I = "select tenant_name, db_unique_name FROM ra_user_database";
        String GET_RESTORE_RANGE = "select low_time, high_time, keepbkp_rspname from ra_restore_range where upper(db_unique_name) = ? order by low_time";
        try (Connection fleetEngineConnection = FleetEngine.getEngineConnection(dbUniqueName);){
            try (ResultSet rs = DBUtil.getInstance((Connection)fleetEngineConnection).executeOracleQuery("select tenant_name, db_unique_name FROM ra_user_database", null);){
                if (rs != null) {
                    while (rs.next()) {
                        dbUniqueName = rs.getString("db_unique_name");
                    }
                }
            }
            rs = DBUtil.getInstance((Connection)fleetEngineConnection).executeQuery("select low_time, high_time, keepbkp_rspname from ra_restore_range where upper(db_unique_name) = ? order by low_time", List.of(dbUniqueName.toUpperCase()));
            try {
                if (rs != null) {
                    int rows = 0;
                    boolean printHeader = true;
                    int columnWidth = 30;
                    while (rs.next()) {
                        ++rows;
                        String lowTime = rs.getString("low_time");
                        String highTime = rs.getString("high_time");
                        String rspname = rs.getString("keepbkp_rspname");
                        if (printHeader) {
                            logger.info("DB Unique Name: " + dbUniqueName);
                            String lowTimeCol = "Low Time";
                            String highTimeCol = "High Time";
                            String restorePointNameCol = "Restore Point Name";
                            String padding1 = " ".repeat(Math.max(columnWidth - lowTimeCol.length(), 1));
                            String padding2 = " ".repeat(Math.max(columnWidth - highTimeCol.length(), 1));
                            logger.info(lowTimeCol + padding1 + highTimeCol + padding2 + restorePointNameCol);
                            logger.info("-".repeat(lowTimeCol.length()) + padding1 + "-".repeat(highTimeCol.length()) + padding2 + "-".repeat(restorePointNameCol.length()));
                            printHeader = false;
                        }
                        rspname = rspname == null ? "" : rspname;
                        String padding1 = " ".repeat(Math.max(columnWidth - lowTime.length(), 1));
                        String padding2 = " ".repeat(Math.max(columnWidth - highTime.length(), 1));
                        logger.info(lowTime + padding1 + highTime + padding2 + rspname);
                    }
                    if (rows == 0) {
                        logger.info("No restore range found for " + dbUniqueName + ". Please verify if backups are running.");
                    }
                } else {
                    logger.log(Level.INFO, "No restore range found.");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.FINE, e.getMessage());
            return new Result(Status.FAILED, "Failed to get restore range: " + e.getMessage());
        }
        return new Result(Status.SUCCESS);
    }
}

