/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.workflows.Status;

public class Result {
    private Status status;
    private String message;
    private String error_code;
    public static final String ERR_PREFIX = "Error";
    private static final String ERR_CODE_BASE = "RCV";
    public static final String FA_UNHANDLED_EXCEPTION = "00005";
    private static final String WF_INVALID_OPTION = "00010";
    private static final String WF_MISSING_OPTION = "00011";
    public static final String WF_UNHANDLED_EXCEPTION = "00015";
    private static final String WF_REMOTE_COMMAND_ERROR = "00020";
    private static final String PD_DB_NOT_ONBOARDED = "00025";
    private static final String PD_CHECK_PDB_ERROR = "00026";
    private static final String APD_METADATA_EXCEPTION = "00030";
    private static final String APD_METADATA_2_EXCEPTION = "00031";
    private static final String APD_METADATA_3_EXCEPTION = "00032";
    private static final String APD_PRECHECK_ERROR = "00033";
    private static final String APD_ONBOARD_DB_ERROR = "00040";
    private static final String APD_DB_NOT_ONBOARDED_ERROR = "00043";
    private static final String APD_VPC_USER_WALLET_ERROR = "00047";
    private static final String APD_LIFECYCLE_GET_STATUS = "00048";
    private static final String ADD_RESOURCE_LIFECYCLE_STATUS_TMT = "00049";
    private static final String APD_LIFECYCLE_STATUS_ERROR = "00050";
    private static final String APD_REGISTER_DB_META_ERROR = "00052";
    private static final String APD_REGISTER_DB_ERROR = "00054";
    private static final String APD_REGISTER_DB_ERROR2 = "00056";
    private static final String APD_RMAN_BACKUP_CF_ERROR = "00057";
    private static final String APD_SAVE_METADATA_ERROR = "00058";
    private static final String RPD_REMOVE_DB_ERROR = "00070";
    private static final String RPD_WAIT_TMT = "00072";
    private static final String RPD_LIFECYCLE_ERROR = "00073";
    private static final String RPD_RM_METADATA_ERROR = "00074";
    private static final String BPD_LOGMODE_ERROR = "00080";
    private static final String UPD_HTTP_CALL_ERROR = "00090";
    private static final String UPD_DB_STATUS_TMT = "00092";
    private static final String UPD_CLIENT_CALL_ERROR = "00094";
    private static final String UPD_VPC_WALLET_ERROR = "00096";
    private static final String CHW_CHECKS_ERROR = "00170";
    private static final String CHW_INVALID_CHECK_NAME_ERROR = "00171";
    private static final String CHW_INVALID_GROUP_NAME_ERROR = "00172";
    private static final String UCW_UPDATE_CLIENT_CONF_ERROR = "00190";
    private static final String UCW_GET_ALIASES_ERROR = "00191";
    private static final String UCW_GET_VPCUSER_ERROR = "00193";
    private static final String UCW_GET_VPCUSER_PWD_ERROR = "00194";
    private static final String FTW_ENGINE_ACTION_EXCEPTION = "00200";
    private static final String FTW_ENGINE_ACTION_ERROR = "00201";
    private static final String FTW_UNHANDLED_ERROR = "00209";
    private static final String TASKMAN_RMAN_SCRIPT_ERROR = "00210";
    private static final String TASKMAN_DB_NOT_CONFIGURED_ERROR = "00212";
    private static final String TASKMAN_DB_NOT_REGISTERED_ERROR = "00213";
    private static final String TASKMAN_INCORRECT_ACTION_ERROR = "00214";
    private static final String TASKMAN_TASK_EXPIRED_ERROR = "00215";
    private static final String TASKMAN_TASK_UNKNOWN_ERROR = "00216";
    private static final String ERR_INIT_LOG_DEST_EXCEPTION = "00230";
    private static final String ERR_INIT_LOG_DEST_DB_EXCEPTION = "00233";
    private static final String ERR_CHECK_REDO_USER_ERROR = "00241";
    private static final String ERR_CHECK_WALLET_ERROR = "00242";
    private static final String ERR_CONFIG_WALLET_LINK_EXISTS_ERROR = "00243";
    private static final String ERR_CONFIG_WALLET_LINK_ERROR = "00245";
    private static final String ERR_VERIFY_DB_CONNECTION_ERROR = "00254";
    private static final String ERR_VERIFY_BACKUP_EXISTS_ERROR = "00257";
    private static final String ERR_CONF_REDO_USER_ERROR = "00265";
    private static final String CAW_VALIDATE_AUTH_ERROR = "00300";
    private static final String ARS_SS_LIFECYCLE_STATUS_TMT = "00310";
    private static final String ARS_SS_LIFECYCLE_STATUS_ERROR = "00312";
    public static final String SSH_CREATE_CONNECTION_EXCEPTION = "00400";
    public static final String SSH_AUTH_EXCEPTION = "00401";
    public static final String SSH_CHANNEL_EXCEPTION = "00402";
    public static final String SSH_FILE_COPY_EXCEPTION = "00404";
    public static final String NAMED_CONN_SAVE_ERROR = "00420";
    private static final String SCHEDULER_FILE_ERROR = "00430";
    private static final String SCHEDULER_JOB_SYNTAX_ERROR = "00432";
    private static final String SCHEDULER_LOAD_JOBS_SYNTAX_ERROR = "00433";
    private static final String SCHEDULER_START_DAEMON_ERROR = "00434";
    private static final String METADATA_JSON_PROCESSING_EXCEPTION = "00500";
    private static final String METADATA_GLOBAL_DIR_EXCEPTION = "00502";
    private static final String METADATA_FILE_SAVE_EXCEPTION = "00503";
    private static final String METADATA_STATE_EXCEPTION = "00504";
    private static final String METADATA_GET_SERVICE_ENDPOINT_EXCEPTION = "00505";
    private static final String PDB_METADATA_LOAD_EXCEPTION = "00510";
    private static final String PDB_METADATA_SAVE_EXCEPTION = "00512";
    private static final String CONMAN_READ_CONFIG_EXCEPTION = "00520";
    private static final String WALLET_CREATE_WALLET_EXCEPTION = "00550";
    private static final String WALLET_ADD_CREDENTIAL_EXCEPTION = "00551";
    private static final String WALLET_WALLET_WORK_EXCEPTION = "00552";
    private static final String WALLET_STORE_WORK_EXCEPTION = "00554";
    private static final String WALLET_MIGRATION_ERROR = "00556";
    private static final String RCVS_GET_PROTECTED_DATABASE_EXCEPTION = "00601";
    private static final String RCVS_FETCH_PROTECTED_DATABASE_CONFIG_EXCEPTION = "00602";
    private static final String RCVS_GET_PROTECTION_POLICY_EXCEPTION = "00605";
    private static final String RCVS_CREATE_RECOVERY_SERVICE_SUBNET_EXCEPTION = "00606";
    private static final String RCVS_GET_RECOVERY_SERVICE_SUBNET_EXCEPTION = "00609";
    private static final String RCVS_INTERRUPTED_WAIT_EXCEPTION = "00610";
    private static final String OCI_DATABASE_API_EXCEPTION = "00620";
    private static final String OCI_AUTH_FILE_CONFIG_EXCEPTION = "00621";
    private static final String OCI_REQUEST_PARSE_EXCEPTION = "00622";
    public static final String FENG_DATABASE_CONNECTION_EXCEPTION = "00630";
    public static final String FENG_DATABASE_SQL_ERROR = "00632";
    public static final String FENG_SERVER_RESPONSE_ERROR = "00634";
    public static final String DATABASE_SQL_ERROR = "00650";
    public static final String DATABASE_ORABASE_ERROR = "00651";
    public static final String FILE_CREATE_DIRECTORY_ERROR = "00680";
    public static final String FILE_READ_ERROR = "00681";
    public static final String FILE_WRITE_ERROR = "00682";
    public static final String COMMAND_EXEC_ERROR = "00690";
    public static final String PASSWORD_PROTECTED_WALLET_ERROR = "00700";

    public Result() {
        this.status = Status.NOT_STARTED;
    }

    public Result(Status status) {
        this.status = status;
    }

    public Result(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Result(Status status, String message, String error_code) {
        this(status, message);
        this.error_code = error_code;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        if (this.error_code != null && !Result.isHandled(this.message)) {
            this.message = Result.getMessage(this.message, this.error_code);
        }
        return this.message;
    }

    public static String getMessage(String msg, String code) {
        return String.format("%s: %s-%s: %s", ERR_PREFIX, ERR_CODE_BASE, code, msg);
    }

    public static boolean isHandled(String message) {
        if (message == null) {
            return false;
        }
        return message.matches("(?s)^Error: RCV-\\d+.*");
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public static RuntimeException invalidOptionException(String msg) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WF_INVALID_OPTION", msg), WF_INVALID_OPTION));
    }

    public static Result invalidOption(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("WF_INVALID_OPTION", msg), WF_INVALID_OPTION));
    }

    public static RuntimeException missingOptionException(String msg) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WF_MISSING_OPTION", msg), WF_MISSING_OPTION));
    }

    public static Result missingOption(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("WF_MISSING_OPTION", msg), WF_MISSING_OPTION));
    }

    public static RuntimeException wfResultToException(String msg) {
        return new RuntimeException(msg);
    }

    public static Result wfRemoteCommandError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("WF_REMOTE_COMMAND_ERROR", msg), WF_REMOTE_COMMAND_ERROR));
    }

    public static Result pdDatabaseNotOnboarded(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("PD_DB_NOT_ONBOARDED", msg), PD_DB_NOT_ONBOARDED));
    }

    public static Result pdCheckPdbError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("PD_CHECK_PDB_ERROR", new Object[0]), PD_CHECK_PDB_ERROR));
    }

    public static RuntimeException apdMetadataInitException(String protectionPolicyName) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("APD_METADATA_EXCEPTION", protectionPolicyName), APD_METADATA_EXCEPTION));
    }

    public static RuntimeException apdMetadataInit2Exception(String protectionPolicyName) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("APD_METADATA_2_EXCEPTION", protectionPolicyName), APD_METADATA_2_EXCEPTION));
    }

    public static RuntimeException apdMetadataInit3Exception(String msg) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("APD_METADATA_3_EXCEPTION", msg), APD_METADATA_3_EXCEPTION));
    }

    public static Result apdPrecheckError(String msg) {
        return new Result(Status.FAILED, RcvMessages.format("APD_PRECHECK_ERROR", Result.getMessage(msg, APD_PRECHECK_ERROR)));
    }

    public static Result apdOnboardDbError(String msg) {
        return new Result(Status.FAILED, RcvMessages.format("APD_ONBOARD_DB_ERROR", Result.getMessage(msg, APD_ONBOARD_DB_ERROR)));
    }

    public static Result apdDbNotOnboarded(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_DB_NOT_ONBOARDED_ERROR", msg), APD_DB_NOT_ONBOARDED_ERROR));
    }

    public static Result apdVpcUserWalletError(String walletLocation) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_VPC_USER_WALLET_ERROR", walletLocation), APD_VPC_USER_WALLET_ERROR));
    }

    public static Result apdLifecycleGetStatusError(String ocid) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_LIFECYCLE_GET_STATUS", ocid), APD_LIFECYCLE_GET_STATUS));
    }

    public static Result addResourceLifecycleStatusTmt(String resource) {
        return new Result(Status.TIMED_OUT, Result.getMessage(RcvMessages.format("ADD_RESOURCE_LIFECYCLE_STATUS_TMT", resource), ADD_RESOURCE_LIFECYCLE_STATUS_TMT));
    }

    public static Result verifyLifecycleStatusError(String resource, String currentState, String expectedState1, String expectedState2) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_LIFECYCLE_STATUS_ERROR", resource, currentState, expectedState1, expectedState2), APD_LIFECYCLE_STATUS_ERROR));
    }

    public static Result apdVpcUserMetadataError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_REGISTER_DB_META_ERROR", new Object[0]), APD_REGISTER_DB_META_ERROR));
    }

    public static Result apdRegisterDbError(String logFile) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_REGISTER_DB_ERROR", logFile), APD_REGISTER_DB_ERROR));
    }

    public static Result apdRegisterDbError2() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_REGISTER_DB_ERROR2", new Object[0]), APD_REGISTER_DB_ERROR2));
    }

    public static Result apdRmanBackupCfError(String code) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_RMAN_BACKUP_CF_ERROR", code), APD_RMAN_BACKUP_CF_ERROR));
    }

    public static Result apdSaveMetadataError(String metadataType) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("APD_SAVE_METADATA_ERROR", metadataType), APD_SAVE_METADATA_ERROR));
    }

    public static Result rpdRemoveProtectedDbError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("RPD_REMOVE_DB_ERROR", new Object[0]), RPD_REMOVE_DB_ERROR));
    }

    public static Result rpdRemoveProtectedDbTmt() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("RPD_WAIT_TMT", new Object[0]), RPD_WAIT_TMT));
    }

    public static Result rpdRemoveLifecycleError(String status) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("RPD_LIFECYCLE_ERROR", status), RPD_LIFECYCLE_ERROR));
    }

    public static Result rpdRemoveMetadataError(String directory) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("RPD_RM_METADATA_ERROR", directory), RPD_RM_METADATA_ERROR));
    }

    public static Result bpdLogmodeError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("BPD_LOGMODE_ERROR", new Object[0]), BPD_LOGMODE_ERROR));
    }

    public static Result updProtectedDatabaseHttpError(String protectedDatabaseId) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UPD_HTTP_CALL_ERROR", protectedDatabaseId), UPD_HTTP_CALL_ERROR));
    }

    public static Result updResourceStatusTmt(String resource, String resourceId) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UPD_DB_STATUS_TMT", resource, resourceId), UPD_DB_STATUS_TMT));
    }

    public static Result updProtectedDatabaseCallError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UPD_CLIENT_CALL_ERROR", new Object[0]), UPD_CLIENT_CALL_ERROR));
    }

    public static Result updVpcWalletError(String walletLocation) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UPD_VPC_WALLET_ERROR", walletLocation), UPD_VPC_WALLET_ERROR));
    }

    public static Result chwChecksError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.get("CHW_CHECKS_ERROR"), CHW_CHECKS_ERROR));
    }

    public static Result chwInvalidCheckNameError(String checkId) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("CHW_INVALID_CHECK_NAME_ERROR", checkId), CHW_INVALID_CHECK_NAME_ERROR));
    }

    public static Result chwInvalidGroupNameError(String checkId) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("CHW_INVALID_GROUP_NAME_ERROR", checkId), CHW_INVALID_GROUP_NAME_ERROR));
    }

    public static Result ucwUpdateClientConfError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UCW_UPDATE_CLIENT_CONF_ERROR", msg), UCW_UPDATE_CLIENT_CONF_ERROR));
    }

    public static Result ucwGetAliasesError(String confFile) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UCW_GET_ALIASES_ERROR", confFile), UCW_GET_ALIASES_ERROR));
    }

    public static Result ucwGetVpcUserError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UCW_GET_VPCUSER_ERROR", new Object[0]), UCW_GET_VPCUSER_ERROR));
    }

    public static Result ucwGetVpcUserPwdError(String vpcUserName, String walletLocation) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("UCW_GET_VPCUSER_PWD_ERROR", vpcUserName, walletLocation), UCW_GET_VPCUSER_PWD_ERROR));
    }

    public static RuntimeException ftwEngineActionException(String msg) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("FTW_ENGINE_ACTION_EXCEPTION", msg), FTW_ENGINE_ACTION_EXCEPTION));
    }

    public static Result ftwEngineActionError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FTW_ENGINE_ACTION_ERROR", msg), FTW_ENGINE_ACTION_ERROR));
    }

    public static Result ftwUnhandledError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FTW_UNHANDLED_ERROR", new Object[0]), FTW_UNHANDLED_ERROR));
    }

    public static Result taskmanRmanScriptError(String error_code) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_RMAN_SCRIPT_ERROR", error_code), TASKMAN_RMAN_SCRIPT_ERROR));
    }

    public static Result taskmanDbNotConfiguredError(String dbUniqueName) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_DB_NOT_CONFIGURED_ERROR", dbUniqueName), TASKMAN_DB_NOT_CONFIGURED_ERROR));
    }

    public static Result taskmanDbNotRegisteredError(String dbUniqueName) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_DB_NOT_REGISTERED_ERROR", dbUniqueName), TASKMAN_DB_NOT_REGISTERED_ERROR));
    }

    public static Result taskmanIncorrectActionError(String id) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_INCORRECT_ACTION_ERROR", id), TASKMAN_INCORRECT_ACTION_ERROR));
    }

    public static Result taskmanTaskExpiredError(String id) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_TASK_EXPIRED_ERROR", id), TASKMAN_TASK_EXPIRED_ERROR));
    }

    public static Result taskmanTaskUnknownError(String type) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("TASKMAN_TASK_UNKNOWN_ERROR", type), TASKMAN_TASK_UNKNOWN_ERROR));
    }

    public static RuntimeException errInitLogDestException(String rcvConfFile, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("ERR_INIT_LOG_DEST_EXCEPTION", rcvConfFile), ERR_INIT_LOG_DEST_EXCEPTION), e);
    }

    public static RuntimeException errInitLogDestDbException(Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("ERR_INIT_LOG_DEST_DB_EXCEPTION", new Object[0]), ERR_INIT_LOG_DEST_DB_EXCEPTION), e);
    }

    public static Result errCheckRedoUserError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_CHECK_REDO_USER_ERROR", new Object[0]), ERR_CHECK_REDO_USER_ERROR));
    }

    public static Result errCheckWalletError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_CHECK_WALLET_ERROR", new Object[0]), ERR_CHECK_WALLET_ERROR));
    }

    public static Result errConfigWalletLinkExistsError(String src) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_CONFIG_WALLET_LINK_EXISTS_ERROR", src), ERR_CONFIG_WALLET_LINK_EXISTS_ERROR));
    }

    public static Result errConfigWalletLinkError(String src, String dst) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_CONFIG_WALLET_LINK_ERROR", src, dst), ERR_CONFIG_WALLET_LINK_ERROR));
    }

    public static Result errVerifyDbConnectionError(String service) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_VERIFY_DB_CONNECTION_ERROR", service), ERR_VERIFY_DB_CONNECTION_ERROR));
    }

    public static Result errVerifyBackupExistsError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_VERIFY_BACKUP_EXISTS_ERROR", new Object[0]), ERR_VERIFY_BACKUP_EXISTS_ERROR));
    }

    public static Result errConfRedoUserError(String currentRedoTransportUser) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ERR_CONF_REDO_USER_ERROR", currentRedoTransportUser), ERR_CONF_REDO_USER_ERROR));
    }

    public static Result uawValidateAuthenticationError(String method) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("CAW_VALIDATE_AUTH_ERROR", method), CAW_VALIDATE_AUTH_ERROR));
    }

    public static Result arsLifecycleStatusTmt(String subnetId, String lifecycleState) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ARS_SS_LIFECYCLE_STATUS_TMT", subnetId, lifecycleState), ARS_SS_LIFECYCLE_STATUS_TMT));
    }

    public static Result arsVerifyLifecycleStatusError(String subnetId, String lifecycleState, String lifecycleStateActive, String lifecycleStateCreating) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("ARS_SS_LIFECYCLE_STATUS_ERROR", subnetId, lifecycleState, lifecycleStateActive, lifecycleStateCreating), ARS_SS_LIFECYCLE_STATUS_ERROR));
    }

    public static RuntimeException sshCreateConnectionException(String host, String port, String user, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("SSH_CREATE_CONNECTION_EXCEPTION", user, host, port), SSH_CREATE_CONNECTION_EXCEPTION), e);
    }

    public static RuntimeException sshAuthException(Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("SSH_AUTH_EXCEPTION", new Object[0]), SSH_AUTH_EXCEPTION), e);
    }

    public static RuntimeException sshChannelException(Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("SSH_CHANNEL_EXCEPTION", new Object[0]), SSH_CHANNEL_EXCEPTION), e);
    }

    public static RuntimeException sshFileCopyException(String file, String host, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("SSH_FILE_COPY_EXCEPTION", file, host), SSH_FILE_COPY_EXCEPTION), e);
    }

    public static RuntimeException namedConnectionSaveException(String connectionName, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("NAMED_CONN_SAVE_ERROR", connectionName), NAMED_CONN_SAVE_ERROR), e);
    }

    public static Result schedulerFileError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("SCHEDULER_FILE_ERROR", msg), SCHEDULER_FILE_ERROR));
    }

    public static Result schedulerJobSyntaxError(String jobName) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("SCHEDULER_JOB_SYNTAX_ERROR", jobName), SCHEDULER_JOB_SYNTAX_ERROR));
    }

    public static Result schedulerLoadJobsSyntaxError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("SCHEDULER_LOAD_JOBS_SYNTAX_ERROR", new Object[0]), SCHEDULER_LOAD_JOBS_SYNTAX_ERROR));
    }

    public static Result sbjStartSchedulerError() {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("SCHEDULER_START_DAEMON_ERROR", new Object[0]), SCHEDULER_START_DAEMON_ERROR));
    }

    public static RuntimeException metadataJsonProcessingException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("METADATA_JSON_PROCESSING_EXCEPTION", new Object[0]), METADATA_JSON_PROCESSING_EXCEPTION), e);
    }

    public static RuntimeException metadataGlobalDirectoryException(String metadataDirectory, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("METADATA_GLOBAL_DIR_EXCEPTION", metadataDirectory), METADATA_GLOBAL_DIR_EXCEPTION), e);
    }

    public static RuntimeException metadataFileSaveException(String metadataFile, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("METADATA_FILE_SAVE_EXCEPTION", metadataFile), METADATA_FILE_SAVE_EXCEPTION), e);
    }

    public static RuntimeException metadataGetServiceEndpointException(String metadataFile) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("METADATA_GET_SERVICE_ENDPOINT_EXCEPTION", metadataFile), METADATA_GET_SERVICE_ENDPOINT_EXCEPTION));
    }

    public static RuntimeException metadataStateException() {
        return new RuntimeException(Result.getMessage(RcvMessages.format("METADATA_STATE_EXCEPTION", new Object[0]), METADATA_STATE_EXCEPTION));
    }

    public static RuntimeException pdbMetadataLoadException(String file, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("PDB_METADATA_LOAD_EXCEPTION", file), PDB_METADATA_LOAD_EXCEPTION), e);
    }

    public static RuntimeException pdbMetadataSaveException(String file, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("PDB_METADATA_SAVE_EXCEPTION", file), PDB_METADATA_SAVE_EXCEPTION), e);
    }

    public static RuntimeException conmanReadConfigException(String rcvConfFile, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("CONMAN_READ_CONFIG_EXCEPTION", rcvConfFile), CONMAN_READ_CONFIG_EXCEPTION), e);
    }

    public static RuntimeException walletCreateWalletException(String path, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WALLET_CREATE_WALLET_EXCEPTION", path), WALLET_CREATE_WALLET_EXCEPTION), e);
    }

    public static RuntimeException walletAddCredentialException(String path, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WALLET_ADD_CREDENTIAL_EXCEPTION", path), WALLET_ADD_CREDENTIAL_EXCEPTION), e);
    }

    public static RuntimeException walletWalletWorkException(String wrl, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WALLET_WALLET_WORK_EXCEPTION", wrl), WALLET_WALLET_WORK_EXCEPTION), e);
    }

    public static RuntimeException walletStoreWorkException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("WALLET_STORE_WORK_EXCEPTION", msg), WALLET_STORE_WORK_EXCEPTION), e);
    }

    public static Result walletMigrationError(String srcWallet, String dstWallet) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("WALLET_MIGRATION_ERROR", srcWallet, dstWallet), WALLET_MIGRATION_ERROR));
    }

    public static RuntimeException rcvGetProtectedDatabaseException(String databaseId, String metadataFile, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_GET_PROTECTED_DATABASE_EXCEPTION", databaseId, metadataFile), RCVS_GET_PROTECTED_DATABASE_EXCEPTION), e);
    }

    public static Result rcvGetProtectedDatabaseError(String databaseId, String metadataFile) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("RCVS_GET_PROTECTED_DATABASE_EXCEPTION", databaseId, metadataFile), RCVS_GET_PROTECTED_DATABASE_EXCEPTION));
    }

    public static RuntimeException rcvFetchProtectedDatabaseConfigurationException(String protectedDatabaseId, String configurationType, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_FETCH_PROTECTED_DATABASE_CONFIG_EXCEPTION", protectedDatabaseId, configurationType), RCVS_FETCH_PROTECTED_DATABASE_CONFIG_EXCEPTION), e);
    }

    public static RuntimeException rcvGetProtectionPolicyException(String compatmentId, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_GET_PROTECTION_POLICY_EXCEPTION", compatmentId), RCVS_GET_PROTECTION_POLICY_EXCEPTION), e);
    }

    public static RuntimeException rcvCreateRecoveryServiceSubnetException(String compatmentId, String vcnId, String subnetId, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_CREATE_RECOVERY_SERVICE_SUBNET_EXCEPTION", compatmentId, vcnId, subnetId), RCVS_CREATE_RECOVERY_SERVICE_SUBNET_EXCEPTION), e);
    }

    public static RuntimeException rcvGetRecoveryServiceSubnetException(String getRecoveryServiceSubnetId, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_GET_RECOVERY_SERVICE_SUBNET_EXCEPTION", getRecoveryServiceSubnetId), RCVS_GET_RECOVERY_SERVICE_SUBNET_EXCEPTION), e);
    }

    public static RuntimeException rcvInterruptedWaitException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("RCVS_INTERRUPTED_WAIT_EXCEPTION", msg), RCVS_INTERRUPTED_WAIT_EXCEPTION), e);
    }

    public static RuntimeException ociDatabaseApiException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("OCI_DATABASE_API_EXCEPTION", msg), OCI_DATABASE_API_EXCEPTION), e);
    }

    public static RuntimeException ociAuthFileConfigException(Exception e, String ociConfigFile) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("OCI_AUTH_FILE_CONFIG_EXCEPTION", ociConfigFile), OCI_AUTH_FILE_CONFIG_EXCEPTION), e);
    }

    public static RuntimeException ociRequestParseException(Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("OCI_REQUEST_PARSE_EXCEPTION", new Object[0]), OCI_REQUEST_PARSE_EXCEPTION), e);
    }

    public static RuntimeException fengDatabaseConnectionException(String credentialAlias, String tnsAdmin, String walletLocation, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("FENG_DATABASE_CONNECTION_EXCEPTION", credentialAlias, tnsAdmin, walletLocation), FENG_DATABASE_CONNECTION_EXCEPTION), e);
    }

    public static RuntimeException fengDatabaseSqlException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("FENG_DATABASE_SQL_ERROR", msg), FENG_DATABASE_SQL_ERROR), e);
    }

    public static Result fengDatabaseSqlError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FENG_DATABASE_SQL_ERROR", msg), FENG_DATABASE_SQL_ERROR));
    }

    public static Result fengServerResponseError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FENG_SERVER_RESPONSE_ERROR", msg), FENG_SERVER_RESPONSE_ERROR));
    }

    public static RuntimeException databaseSqlException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("DATABASE_SQL_ERROR", msg), DATABASE_SQL_ERROR), e);
    }

    public static Result databaseSqlError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("DATABASE_SQL_ERROR", msg), DATABASE_SQL_ERROR));
    }

    public static RuntimeException databaseOrabaseException() {
        return new RuntimeException(Result.getMessage(RcvMessages.format("DATABASE_ORABASE_ERROR", new Object[0]), DATABASE_ORABASE_ERROR));
    }

    public static Result fileCreateDirectoryError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FILE_CREATE_DIRECTORY_ERROR", msg), FILE_CREATE_DIRECTORY_ERROR));
    }

    public static RuntimeException fileReadError(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("FILE_READ_ERROR", msg), FILE_READ_ERROR), e);
    }

    public static RuntimeException fileWriteException(String msg, Exception e) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("FILE_WRITE_ERROR", msg), FILE_WRITE_ERROR), e);
    }

    public static Result fileWriteError(String msg) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("FILE_WRITE_ERROR", msg), FILE_WRITE_ERROR));
    }

    public static RuntimeException commandExecException(String msg) {
        return new RuntimeException(Result.getMessage(RcvMessages.format("COMMAND_EXEC_ERROR", msg), COMMAND_EXEC_ERROR));
    }

    public static Result walletIsPasswordProtectedError(String wallet) {
        return new Result(Status.FAILED, Result.getMessage(RcvMessages.format("PASSWORD_PROTECTED_WALLET_ERROR", wallet), PASSWORD_PROTECTED_WALLET_ERROR));
    }
}

