/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.logging.LogCleaner;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class RemoveOldLogsWorkflow
extends Workflow {
    public RemoveOldLogsWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.REMOVE_LOG, conn, ctx);
    }

    @Override
    public Result run() {
        String dbsDirectory = RCVCommandBase.getDatabasesDirectory();
        File directory = new File(dbsDirectory);
        File[] subdirectories = directory.listFiles(File::isDirectory);
        if (subdirectories != null) {
            for (File subdirectory : subdirectories) {
                String dbUniqueName = subdirectory.getName();
                FleetAgentContext fleetAgentContext = FleetAgentContext.get(dbUniqueName);
                String logsDirectory = RCVCommandBase.getLogDirectory(dbUniqueName);
                for (RCVCommand.SubCommand subCommand : RCVCommand.SubCommand.values()) {
                    LogCleaner.cleanLogFiles(logsDirectory, subCommand.toString().toLowerCase().replaceAll("\\s+", "_"), 10);
                }
                String taskLogsDirectory = fleetAgentContext.getTaskLogsDirectory();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss");
                LocalDateTime now = LocalDateTime.now();
                String formattedTime = now.format(formatter);
                String zip = String.join((CharSequence)File.separator, taskLogsDirectory, "task_logs." + formattedTime + ".zip");
                try {
                    LogCleaner.compressLogs(taskLogsDirectory, "task", 100, zip);
                }
                catch (IOException e) {
                    this.getWorkflowLogger().getLogger().log(Level.FINE, "Failed to zip up old task logs.", e);
                }
                String rmanScriptsDirectory = fleetAgentContext.getScriptsDirectory();
                zip = String.join((CharSequence)File.separator, rmanScriptsDirectory, "task_scripts." + formattedTime + ".zip");
                try {
                    LogCleaner.compressLogs(rmanScriptsDirectory, "task", "rman", 100, zip);
                }
                catch (IOException e) {
                    this.getWorkflowLogger().getLogger().log(Level.FINE, "Failed to zip up old task scripts.", e);
                }
            }
        }
        return new Result(Status.SUCCESS);
    }
}

