/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.oci.VirtualNetworkClientManager;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class AddRecoveryServiceSubnetWorkflow
extends Workflow {
    private String vcnId;
    private String subnetId;
    private String displayName;
    private String compartmentId;
    private RecoveryClientManager recoveryClientManager;
    private VirtualNetworkClientManager virtualNetworkClientManager;
    private Database database;
    private RecoveryServiceSubnet recoveryServiceSubnet;
    private static GlobalMetadata globalMetadata = GlobalMetadata.load();
    private ParsedCommand command;
    private WorkflowLogger logger;
    private Connection conn;

    public AddRecoveryServiceSubnetWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_RECOVERY_SERVICE_SUBNET, conn, ctx);
        this.command = command;
        this.conn = conn;
        this.logger = this.getWorkflowLogger();
    }

    @Override
    public void initState() {
        this.vcnId = (String)this.command.getOptionValue((Id)RCVOptions.Options.VCN_ID);
        this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        this.subnetId = (String)this.command.getOptionValue((Id)RCVOptions.Options.SUBNET_ID);
        this.displayName = (String)this.command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME);
        String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.virtualNetworkClientManager = new VirtualNetworkClientManager(GlobalMetadata.load().getAuthentication(), this.logger.getLogger());
        Subnet subnet = this.virtualNetworkClientManager.getSubnet(this.subnetId);
        if (subnet == null) {
            throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_SUBNET_ID_OPTION", RCVOptions.Options.SUBNET_ID.getName().toLowerCase(), this.subnetId));
        }
        if (endpoint == null && this.conn != null) {
            endpoint = RCVCommandBase.getDatabase(this.conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.logger.getLogger());
        if (this.vcnId == null) {
            this.vcnId = subnet.getVcnId();
        }
        if (this.compartmentId == null) {
            this.compartmentId = subnet.getCompartmentId();
        }
        if (this.displayName == null) {
            this.displayName = this.conn == null ? String.format("%s_recovery_subnet", subnet.getDisplayName()) : String.format("%s_recovery_subnet", RCVCommandBase.getDbUniqueName(this.conn));
        }
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new AddRecoveryServiceSubnet());
        steps.add(new WaitForRecoveryServiceSubnet());
        super.setSteps(steps);
    }

    private class AddRecoveryServiceSubnet
    implements Step {
        private AddRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            AddRecoveryServiceSubnetWorkflow.this.logger.log(Level.INFO, "Creating recovery service subnet");
            AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet = AddRecoveryServiceSubnetWorkflow.this.recoveryClientManager.createRecoveryServiceSubnet(AddRecoveryServiceSubnetWorkflow.this.vcnId, AddRecoveryServiceSubnetWorkflow.this.compartmentId, AddRecoveryServiceSubnetWorkflow.this.displayName, AddRecoveryServiceSubnetWorkflow.this.subnetId);
            return new Result(Status.SUCCESS);
        }
    }

    private class WaitForRecoveryServiceSubnet
    implements Step {
        private WaitForRecoveryServiceSubnet() {
        }

        @Override
        public Result run() {
            AddRecoveryServiceSubnetWorkflow.this.logger.log(Level.INFO, "Verifying lifecycle state");
            AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet = AddRecoveryServiceSubnetWorkflow.this.recoveryClientManager.waitForRecoveryServiceSubnetUpdate(AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet, 600, 20);
            LifecycleState lifeCycleState = AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet.getLifecycleState();
            if (lifeCycleState.equals((Object)LifecycleState.Creating)) {
                return Result.arsLifecycleStatusTmt(AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet.getSubnetId(), lifeCycleState.toString());
            }
            if (!lifeCycleState.equals((Object)LifecycleState.Active)) {
                return Result.arsVerifyLifecycleStatusError(AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet.getSubnetId(), lifeCycleState.toString(), LifecycleState.Active.toString(), LifecycleState.Creating.toString());
            }
            AddRecoveryServiceSubnetWorkflow.this.logger.log(Level.INFO, "The recovery service subnet ID is: " + AddRecoveryServiceSubnetWorkflow.this.recoveryServiceSubnet.getId());
            return new Result(Status.SUCCESS);
        }
    }
}

