/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.workflows.FileLocker;

public class Utils {
    public static void copyFileContent(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        Utils.copyFileContent(srcFile, destFile);
    }

    public static void copyFileContent(File src, File dest) throws IOException {
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dest);
        Utils.copyFileContent(in, out);
    }

    public static void copyFileContent(FileInputStream in, FileOutputStream out) throws IOException {
        try {
            int n;
            while ((n = in.read()) != -1) {
                out.write(n);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void deleteDirectory(String path) throws IOException {
        Utils.deleteDirectory(Paths.get(path, new String[0]));
    }

    public static void deleteDirectory(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public boolean createEmptyFile(String filePath) throws IOException {
        File file = new File(filePath);
        return file.createNewFile();
    }

    public static String getOracleBase() {
        String oracleHome = RCVCommandBase.getOracleHome();
        if (oracleHome == null) {
            return null;
        }
        SystemCommand command = new SystemCommand();
        ArrayList<CallSite> oraBaseHome = new ArrayList<CallSite>(List.of(oracleHome + File.separator + "bin" + File.separator + "orabase"));
        SystemCommand.ExecutionResult result = command.run(oraBaseHome);
        if (result.getReturnCode() == 0) {
            return result.getOutput().replaceAll(System.getProperty("line.separator"), "");
        }
        return null;
    }

    public static String getOracleBaseHome() {
        String oracleHome = RCVCommandBase.getOracleHome();
        if (oracleHome == null) {
            return null;
        }
        SystemCommand command = new SystemCommand();
        ArrayList<String> oraBaseHome = new ArrayList<String>(Arrays.asList(oracleHome + File.separator + "bin" + File.separator + "orabasehome"));
        SystemCommand.ExecutionResult result = command.run(oraBaseHome);
        if (result.getReturnCode() == 0) {
            return result.getOutput().replaceAll(System.getProperty("line.separator"), "");
        }
        return null;
    }

    private static char[] promptPasswordWithTimeout(ExecutorService executor, Console console, String prompt) throws InterruptedException, ExecutionException, TimeoutException {
        Future<char[]> future = executor.submit(() -> console.readPassword(prompt, new Object[0]));
        try {
            return future.get(30L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
    }

    public static char[] promptAndConfirmPassword(String prompt, String confirm) {
        Console console = System.console();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        char[] pwdCharArr = null;
        try {
            while (true) {
                if ((pwdCharArr = Utils.promptPasswordWithTimeout(executor, console, prompt)).length == 0) {
                    System.out.println("Password cannot be empty!");
                    continue;
                }
                char[] pwdCharArr2 = Utils.promptPasswordWithTimeout(executor, console, confirm);
                if (Arrays.equals(pwdCharArr, pwdCharArr2)) {
                    break;
                }
                System.out.println("Passwords do not match. Please try again.");
            }
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out while waiting for user input", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("An error occurred while reading input.", e);
        }
        finally {
            executor.shutdownNow();
        }
        return pwdCharArr;
    }

    public static char[] promptForPassword(String prompt) {
        char[] pwdCharArr;
        Console console = System.console();
        while (true) {
            System.out.println(prompt);
            pwdCharArr = console.readPassword();
            if (pwdCharArr.length != 0) break;
            System.out.println("Password cannot be empty!");
        }
        return pwdCharArr;
    }

    public static boolean confirm(String confirmMessage) {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print(confirmMessage);
            String userInput = scanner.nextLine().trim().toLowerCase();
            if (userInput.equals("yes")) {
                return true;
            }
            if (userInput.equals("no")) {
                return false;
            }
            System.out.println("Invalid input. Please enter 'yes' or 'no'.");
        }
    }

    public static void unzipFile(String archive, String outputDir) {
        FileLocker fl = new FileLocker(String.join((CharSequence)File.separator, outputDir, "unzip_zrcv_config.lock"), 10);
        fl.execute(() -> {
            File dir = new File(outputDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            try (FileInputStream fis = new FileInputStream(archive);
                 ZipInputStream zis = new ZipInputStream(fis);){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    File file = new File(outputDir + File.separatorChar + entry.getName());
                    new File(file.getParent()).mkdirs();
                    try (FileOutputStream out = new FileOutputStream(file);){
                        int n;
                        while ((n = zis.read()) != -1) {
                            out.write(n);
                        }
                    }
                    zis.closeEntry();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public static String generateRandomString(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(26);
            char c = (char)(65 + index);
            sb.append(c);
        }
        return sb.toString();
    }

    public static char[] generateRandomPassword(int length) {
        int i;
        char[] passwordChars = new char[length];
        String specialChars = "@%+!#$^?:.(){}[][]~";
        String upperCaseChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String lowerCaseChars = "abcdefghijklmnopqrstuvwxyz";
        String numbers = "0123456789";
        String allChars = specialChars + upperCaseChars + lowerCaseChars + numbers;
        SecureRandom random = new SecureRandom();
        String[] charTypes = new String[]{specialChars, upperCaseChars, lowerCaseChars, numbers};
        for (i = 0; i < 2; ++i) {
            for (String charType : charTypes) {
                int randomPosition;
                while (passwordChars[randomPosition = random.nextInt(length)] != '\u0000') {
                }
                passwordChars[randomPosition] = charType.charAt(random.nextInt(charType.length()));
            }
        }
        for (i = 0; i < passwordChars.length; ++i) {
            if (passwordChars[i] != '\u0000') continue;
            passwordChars[i] = allChars.charAt(random.nextInt(allChars.length()));
        }
        return passwordChars;
    }

    public static String getTimeStamp() {
        Instant now = Instant.now();
        return now.toString();
    }

    public static String getTimeStampWithTimeZone() {
        ZonedDateTime now = ZonedDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss VV");
        return now.format(formatter);
    }

    public static String getDateAsString() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String timestamp = now.format(formatter);
        return timestamp;
    }

    public static String getRFC3339Format(Date dateTime) {
        Instant instant = dateTime.toInstant();
        ZonedDateTime localZonedDateTime = instant.atZone(ZoneId.systemDefault());
        ZonedDateTime utcZomedDateTime = localZonedDateTime.withZoneSameInstant(ZoneId.of("UTC"));
        ZonedDateTime zonedDateTimeWithMillis = utcZomedDateTime.truncatedTo(ChronoUnit.MILLIS);
        DateTimeFormatter rfc3339Formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return zonedDateTimeWithMillis.format(rfc3339Formatter);
    }

    public static String getFirstString(String s) {
        if (s == null) {
            return null;
        }
        String newline = System.getProperty("line.separator");
        int index = s.contains(newline) ? s.indexOf(newline) : s.length();
        return s.substring(0, index);
    }

    public static long findStringPosition(String filePath, String searchString) throws IOException {
        return Utils.findFirstStringPosition(filePath, searchString, 0);
    }

    public static long findFirstStringPosition(String filePath, String searchString, int start) throws IOException {
        int chunkSize = Math.max(4096, searchString.length());
        byte[] buffer = new byte[chunkSize];
        try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
            int bytesRead;
            file.seek(start);
            int position = start;
            while ((bytesRead = file.read(buffer)) != -1) {
                String chunk = new String(buffer, 0, bytesRead);
                int index = chunk.indexOf(searchString);
                if (index != -1) {
                    long l = position + index;
                    return l;
                }
                position += bytesRead;
                if (bytesRead < chunkSize) {
                    break;
                }
                file.seek(position - searchString.length());
                position -= searchString.length();
            }
        }
        return -1L;
    }

    public static String readBytesFromPosition(String filePath, long start, int numberOfBytes) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(filePath, "r");){
            long fileLength = file.length();
            if (start >= fileLength) {
                throw new IllegalArgumentException("Start position is beyond the end of the file.");
            }
            long bytesToRead = Math.min((long)numberOfBytes, fileLength - start);
            byte[] buffer = new byte[(int)bytesToRead];
            file.seek(start);
            file.readFully(buffer);
            String string = new String(buffer, StandardCharsets.UTF_8);
            return string;
        }
    }

    public static String getMD5Sum(String filePath) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        try (FileInputStream fis = new FileInputStream(filePath);){
            int nRead;
            byte[] dataBytes = new byte[1024];
            while ((nRead = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nRead);
            }
        }
        byte[] mdBytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : mdBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getShortHostName() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String hostName = localHost.getHostName();
        int i = hostName.indexOf(46);
        if (i > 0) {
            return hostName.substring(0, i);
        }
        return hostName;
    }

    public static String getFullHostName() {
        InetAddress localHost = null;
        try {
            localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return localHost.getCanonicalHostName();
    }

    public static void createParentDirectoryForFile(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        Path parentDir = filePath.getParent();
        if (parentDir != null && !Files.exists(parentDir, new LinkOption[0])) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory " + String.valueOf(parentDir) + ": " + e.getMessage());
            }
        }
    }

    public static Optional<Path> getMostRecentFile(String directoryPath, String prefix, String suffix) {
        Path dir = Paths.get(directoryPath, new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Files.list(dir).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().startsWith(prefix) && p.getFileName().toString().endsWith(suffix)).max(Comparator.comparingLong(p -> p.toFile().lastModified()));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

