/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.task.RMANTask;
import oracle.dbtools.extension.rcv.models.task.TaskInfo;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;

public class TaskManager {
    public static Result executeTask(TaskInfo taskInfo, Database database, String rmanLogFile, Logger logger) throws SQLException, IOException {
        int type = taskInfo.getType();
        int id = taskInfo.getId();
        Clob clobContent = taskInfo.getContent();
        String dbUniqueName = taskInfo.getDbUniqueName();
        String scriptPath = taskInfo.getScriptPath();
        if (type == 1) {
            return new Result(Status.SKIPPED);
        }
        if (type == 2) {
            RMANTask rmanTask = new RMANTask(taskInfo, database, rmanLogFile, logger);
            return rmanTask.run();
        }
        if (type == 3) {
            return new Result(Status.SUCCESS);
        }
        if (type == 4) {
            return Result.taskmanDbNotConfiguredError(dbUniqueName);
        }
        if (type == 5) {
            return Result.taskmanDbNotRegisteredError(dbUniqueName);
        }
        if (type == 6) {
            return Result.taskmanIncorrectActionError(String.valueOf(id));
        }
        if (type == 9) {
            return Result.taskmanTaskExpiredError(String.valueOf(id));
        }
        return Result.taskmanTaskUnknownError(String.valueOf(type));
    }
}

