/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public class SshHelper {
    private SshClient client;
    private ClientSession session;
    private String user;
    private String host;
    private String password;
    private String keyFile;
    private int port;
    private SftpClientFactory sftpClientFactory;
    private SftpFileSystemProvider provider;
    private FileSystem fs;

    public SshHelper(String user, String host, int port, String privateKeyFile) {
        this(user, host, port);
        this.keyFile = privateKeyFile;
    }

    public SshHelper(String user, String host, int port) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.sftpClientFactory = SftpClientFactory.instance();
        this.client = SshClient.setUpDefaultClient();
        this.client.start();
    }

    public static SshHelper generateSshHelperInteractive(String host, Logger logger) {
        SshHelper sshHelper;
        char[] sshPassword;
        block11: {
            String homeDirectory = System.getProperty("user.home");
            File sshDirectory = new File(homeDirectory + File.separator + ".ssh");
            FilenameFilter privateKeyFileFilter = (dir, name) -> name.startsWith("id_") && !name.endsWith(".pub") && Files.exists(Paths.get(String.valueOf(sshDirectory) + File.separator + name + ".pub", new String[0]), new LinkOption[0]);
            File[] privateKeyFiles = sshDirectory.listFiles(privateKeyFileFilter);
            sshPassword = null;
            String privateKeyFile = null;
            assert (privateKeyFiles != null);
            if (privateKeyFiles.length != 1) {
                Scanner scanner = new Scanner(System.in);
                Object message = privateKeyFiles.length == 0 ? String.format("Failed to locate SSH key files in %s. ", sshDirectory) : "Found multiple SSH key files. ";
                message = (String)message + "Please choose one of the following ways to connect to remote node(s).\n1. Password\n2. SSH key\nPlease enter 1 or 2.";
                while (true) {
                    logger.log(Level.INFO, (String)message);
                    String choice = scanner.nextLine().strip();
                    if (choice.equals("1")) {
                        sshPassword = Utils.promptForPassword("Please enter the oracle SSH password: ");
                        break block11;
                    }
                    if (choice.equals("2")) {
                        while (true) {
                            logger.log(Level.INFO, "Please enter the full path to the oracle SSH private key file: ");
                            privateKeyFile = scanner.nextLine().strip();
                            if (!Files.exists(Paths.get(privateKeyFile, new String[0]), new LinkOption[0])) {
                                logger.log(Level.INFO, "The file you provided does not exist.");
                                continue;
                            }
                            break block11;
                            break;
                        }
                    }
                    logger.log(Level.INFO, "Invalid option.");
                }
            }
            privateKeyFile = String.valueOf(privateKeyFiles[0]);
        }
        if (sshPassword != null) {
            sshHelper = new SshHelper("oracle", host, 22, null);
            sshHelper.setPassword(new String(sshPassword));
        } else {
            sshHelper = new SshHelper("oracle", host, 22, null);
        }
        try {
            sshHelper.connect();
        }
        catch (IOException e) {
            throw Result.sshCreateConnectionException("oracle", host, "22", e);
        }
        return sshHelper;
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void connect() throws IOException {
        if (this.session == null || !this.session.isOpen()) {
            this.session = (ClientSession)((ConnectFuture)this.client.connect(this.user, this.host, this.port).verify(10000L)).getSession();
            if (this.password != null && !this.password.isEmpty()) {
                this.session.addPasswordIdentity(this.password);
            }
            this.session.auth().verify();
        }
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.close(false);
            this.session = null;
        }
        if (this.fs != null) {
            try {
                this.fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fs = null;
        }
    }

    public SftpClient createSftpClient() throws IOException {
        SftpClientFactory factory = SftpClientFactory.instance();
        SftpClient client = factory.createSftpClient(this.session);
        return client.singleSessionInstance();
    }

    private FileSystem getSftpFileSystem() throws IOException {
        if (this.provider == null) {
            this.provider = new SftpFileSystemProvider(this.client);
        }
        if (this.fs == null) {
            URI uri = this.password == null || this.password.isEmpty() ? SftpFileSystemProvider.createFileSystemURI((String)this.host, (int)this.port, (String)this.user, null) : SftpFileSystemProvider.createFileSystemURI((String)this.host, (int)this.port, (String)this.user, (String)this.password);
            this.fs = this.provider.newFileSystem(uri, Collections.emptyMap());
        }
        return this.fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isDirectoryShared(Path localDirectory, FileSystem remoteFileSystem) {
        boolean bl;
        Path testFile;
        block16: {
            block14: {
                boolean bl2;
                block15: {
                    testFile = null;
                    testFile = Files.createTempFile(localDirectory, "rcv", String.valueOf(ProcessHandle.current().pid()), new FileAttribute[0]);
                    Path remoteTestFile = remoteFileSystem.getPath(testFile.toString(), new String[0]);
                    if (!Files.exists(remoteTestFile, new LinkOption[0])) break block14;
                    bl2 = true;
                    if (testFile == null) break block15;
                    try {
                        Files.deleteIfExists(testFile);
                    }
                    catch (IOException deleteException) {
                        RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to remove temporary test file.", deleteException);
                    }
                }
                return bl2;
            }
            bl = false;
            if (testFile == null) break block16;
            try {
                Files.deleteIfExists(testFile);
            }
            catch (IOException deleteException) {
                RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to remove temporary test file.", deleteException);
            }
        }
        return bl;
        catch (IOException e) {
            boolean bl3;
            block17: {
                try {
                    RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to check if wallet_root points to a shared location", e);
                    bl3 = false;
                    if (testFile == null) break block17;
                }
                catch (Throwable throwable) {
                    if (testFile != null) {
                        try {
                            Files.deleteIfExists(testFile);
                        }
                        catch (IOException deleteException) {
                            RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to remove temporary test file.", deleteException);
                        }
                    }
                    throw throwable;
                }
                try {
                    Files.deleteIfExists(testFile);
                }
                catch (IOException deleteException) {
                    RCVCommandBase.getLogger().getLogger().log(Level.FINE, "Failed to remove temporary test file.", deleteException);
                }
            }
            return bl3;
        }
    }

    public void copy(String src, String target) {
        try {
            this.connect();
            Path srcPath = Paths.get(src, new String[0]);
            FileSystem remoteFileSystem = this.getSftpFileSystem();
            Path targetPath = remoteFileSystem.getPath(target, new String[0]);
            Path targetParentPath = targetPath.getParent();
            boolean directoryIsShared = false;
            if (src.equals(target)) {
                Path srcParentPath = Files.isDirectory(srcPath, new LinkOption[0]) ? srcPath : srcPath.getParent();
                directoryIsShared = this.isDirectoryShared(srcParentPath, remoteFileSystem);
            }
            if (directoryIsShared) {
                return;
            }
            if (targetParentPath != null && !Files.exists(targetParentPath, new LinkOption[0])) {
                Files.createDirectories(targetParentPath, new FileAttribute[0]);
            }
            ArrayList<Path> filePaths = new ArrayList<Path>();
            filePaths.add(srcPath);
            while (!filePaths.isEmpty()) {
                Path path = (Path)filePaths.remove(0);
                Path remotePath = remoteFileSystem.getPath(path.toString(), new String[0]);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    File[] filesInDirectory;
                    if (!Files.exists(remotePath, new LinkOption[0])) {
                        Files.createDirectories(remotePath, new FileAttribute[0]);
                    }
                    if ((filesInDirectory = path.toFile().listFiles()) == null) continue;
                    for (File nestedFile : filesInDirectory) {
                        filePaths.add(nestedFile.toPath());
                    }
                    continue;
                }
                Files.copy(path, remotePath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw Result.sshFileCopyException(src, this.host, e);
        }
    }

    public void deleteRemoteFile(SftpClient sftpClient, String remotePath) throws IOException {
        SftpClient.Attributes attrs;
        try {
            attrs = sftpClient.stat(remotePath);
        }
        catch (IOException e) {
            return;
        }
        if (attrs.isDirectory()) {
            for (SftpClient.DirEntry entry : sftpClient.readDir(remotePath)) {
                String fullPath;
                String name = entry.getFilename();
                if (".".equals(name) || "..".equals(name)) continue;
                String string = fullPath = remotePath.endsWith("/") ? remotePath + name : remotePath + "/" + name;
                if (entry.getAttributes().isDirectory()) {
                    this.deleteRemoteFile(sftpClient, fullPath);
                    continue;
                }
                sftpClient.remove(fullPath);
            }
            sftpClient.rmdir(remotePath);
        } else {
            sftpClient.remove(remotePath);
        }
    }

    public void deleteRemoteFile(String remotePath) throws IOException {
        try (SftpClient sftpClient = this.sftpClientFactory.createSftpClient(this.session);){
            this.deleteRemoteFile(sftpClient, remotePath);
        }
    }

    public SystemCommand.ExecutionResult executeCommand(String command) {
        SystemCommand.ExecutionResult executionResult;
        block11: {
            try {
                this.connect();
            }
            catch (IOException e) {
                throw Result.sshCreateConnectionException(this.user, this.host, "" + this.port, e);
            }
            ClientChannel channel = this.session.createChannel("exec", command);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                channel.setOut((OutputStream)out);
                channel.setErr((OutputStream)err);
                channel.open().verify(10L, TimeUnit.SECONDS);
                channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), TimeUnit.SECONDS.toMillis(10L));
                int exitCode = channel.getExitStatus();
                String output = out.toString(StandardCharsets.UTF_8);
                String error = err.toString(StandardCharsets.UTF_8);
                executionResult = new SystemCommand.ExecutionResult(output + "\n" + error, exitCode);
                if (channel == null) break block11;
            }
            catch (Throwable out) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable) {
                            out.addSuppressed(throwable);
                        }
                    }
                    throw out;
                }
                catch (IOException e) {
                    throw Result.sshChannelException(e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String error = String.format("Failed to execute %s on node %s: %s", command, this.host, e.getMessage());
                    return new SystemCommand.ExecutionResult(error, -1);
                }
            }
            channel.close();
        }
        return executionResult;
    }

    public SystemCommand.ExecutionResult executeCommand(String command, String input) {
        SystemCommand.ExecutionResult executionResult;
        block10: {
            try {
                this.connect();
            }
            catch (IOException e) {
                throw Result.sshCreateConnectionException(this.user, this.host, "" + this.port, e);
            }
            ClientChannel channel = this.session.createChannel("exec", command);
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ByteArrayOutputStream err = new ByteArrayOutputStream();
                OutputStream stdin = channel.getInvertedIn();
                channel.setErr((OutputStream)err);
                channel.open().verify(10L, TimeUnit.SECONDS);
                stdin.write(input.getBytes());
                stdin.flush();
                stdin.close();
                channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), TimeUnit.SECONDS.toMillis(10L));
                int exitCode = channel.getExitStatus();
                String output = out.toString(StandardCharsets.UTF_8);
                String error = err.toString(StandardCharsets.UTF_8);
                executionResult = new SystemCommand.ExecutionResult(!output.isEmpty() ? output : error, exitCode);
                if (channel == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Result.sshChannelException(e);
                }
            }
            channel.close();
        }
        return executionResult;
    }

    private static void createSqlScriptForRcvCommand(RCVCommand rcvCommand, String scriptPath) {
        Path filePath = Paths.get(scriptPath, new String[0]);
        Path parentDir = filePath.getParent();
        if (parentDir != null) {
            try {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directory " + String.valueOf(parentDir), e);
            }
        }
        try (FileWriter fileWriter = new FileWriter(scriptPath, false);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(rcvCommand.toString() + ";\n");
            bufferedWriter.write("\nexit;\n");
            bufferedWriter.flush();
        }
        catch (IOException e) {
            throw Result.fileWriteException(RcvMessages.format("SSH_HELP_REMOTE_COMMAND_SPOOL_ERROR_MSG", scriptPath), e);
        }
    }

    public SystemCommand.ExecutionResult executeRcvCommand(String connectionName, RCVCommand rcvCommand, String scriptPath, String oracleSid) {
        SshHelper.createSqlScriptForRcvCommand(rcvCommand, scriptPath);
        this.copy(scriptPath, scriptPath);
        String sqlclHome = System.getenv("SQL_HOME");
        if (sqlclHome == null) {
            sqlclHome = String.join((CharSequence)File.separator, RCVCommandBase.getOracleHome(), "sqlcl");
        }
        String sqlPath = String.join((CharSequence)File.separator, sqlclHome, "bin", "sql");
        String oracleHome = RCVCommandBase.getOracleHome();
        String command = String.format("export ORACLE_HOME=%s; export ORACLE_SID=%s; %s -name %s @%s", oracleHome, oracleSid, sqlPath, connectionName, scriptPath);
        return this.executeCommand(command);
    }

    public SystemCommand.ExecutionResult executeRcvCommand(String connectionName, RCVCommand rcvCommand, String scriptPath) {
        SshHelper.createSqlScriptForRcvCommand(rcvCommand, scriptPath);
        this.copy(scriptPath, scriptPath);
        String sqlclHome = System.getenv("SQL_HOME");
        if (sqlclHome == null) {
            sqlclHome = String.join((CharSequence)File.separator, RCVCommandBase.getOracleHome(), "sqlcl");
        }
        String sqlPath = String.join((CharSequence)File.separator, sqlclHome, "bin", "sql");
        String oracleHome = RCVCommandBase.getOracleHome();
        String command = String.format("export ORACLE_HOME=%s; %s -name %s @%s", oracleHome, sqlPath, connectionName, scriptPath);
        return this.executeCommand(command);
    }
}

