/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class LogManager {
    private static Level logLevel = Level.FINEST;
    private static Handler consoleHandler = new ConsoleHandler();
    private static ConsoleHandler actionHandler = new ConsoleHandler();

    private LogManager() {
    }

    private static FileHandler createFileHandler(String logFile) throws IOException {
        Path logDirectory = Paths.get(logFile, new String[0]).getParent();
        if (!Files.exists(logDirectory, new LinkOption[0])) {
            Files.createDirectories(logDirectory, new FileAttribute[0]);
        }
        FileHandler fileHandler = new FileHandler(logFile, true);
        Filter fileFilter = record -> true;
        fileHandler.setFilter(fileFilter);
        fileHandler.setFormatter(new SimpleFormatter());
        return fileHandler;
    }

    private static ConsoleHandler createActionHandler() {
        ConsoleHandler actionHandler = new ConsoleHandler();
        actionHandler.setLevel(Level.WARNING);
        actionHandler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
        return actionHandler;
    }

    private static boolean hasHandlerOfType(Logger logger, Class<? extends Handler> handlerClass) {
        for (Handler handler : logger.getHandlers()) {
            if (!handlerClass.isInstance(handler)) continue;
            return true;
        }
        return false;
    }

    public static WorkflowLogger getLogger(String logFile) {
        Logger logger = Logger.getLogger(logFile);
        logger.setLevel(logLevel);
        logger.setUseParentHandlers(false);
        if (!LogManager.hasHandlerOfType(logger, ConsoleHandler.class)) {
            consoleHandler.setFormatter(new CustomFormatter());
            Filter consoleFilter = record -> {
                if (record.getLevel().intValue() == Level.WARNING.intValue()) {
                    return false;
                }
                return record.getLevel().intValue() >= Level.INFO.intValue();
            };
            consoleHandler.setFilter(consoleFilter);
            logger.addHandler(consoleHandler);
            logger.addHandler(actionHandler);
        }
        if (!LogManager.hasHandlerOfType(logger, FileHandler.class)) {
            try {
                FileHandler fileHandler = LogManager.createFileHandler(logFile);
                logger.addHandler(fileHandler);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, String.format("Failed to create log file %s: %s", logFile, e.getMessage()));
            }
        }
        if (!logger.getLevel().equals(logLevel)) {
            logger.setLevel(logLevel);
        }
        return new WorkflowLogger(logger, logFile);
    }

    public static String getLogFile(String workflowName) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss");
        LocalDateTime now = LocalDateTime.now();
        String formattedTime = now.format(formatter);
        String name = workflowName + "." + formattedTime;
        String logName = name.replaceAll("\\s+", "_") + ".log";
        String logDirectory = String.join((CharSequence)File.separator, RCVCommandBase.getAgentBaseDirectory(), "log");
        return String.join((CharSequence)File.separator, logDirectory, logName.toLowerCase());
    }

    public static String getLogFile(String workflowName, String dbUniqueName) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss");
        LocalDateTime now = LocalDateTime.now();
        String formattedTime = now.format(formatter);
        String name = workflowName + "." + formattedTime;
        String logName = name.replaceAll("\\s+", "_") + ".log";
        String logDirectory = FleetAgentContext.get(dbUniqueName).getLogsDirectory();
        return String.join((CharSequence)File.separator, logDirectory, logName.toLowerCase());
    }

    public static void setLogLevel(Level newLevel) {
        logLevel = newLevel;
    }

    static {
        actionHandler.setLevel(Level.WARNING);
        actionHandler.setFormatter(new SimpleFormatter(){

            @Override
            public String format(LogRecord record) {
                return record.getMessage() + "\n";
            }
        });
    }

    private static class CustomFormatter
    extends SimpleFormatter {
        private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private CustomFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            String timestamp = dateFormat.format(new Date(record.getMillis()));
            return timestamp + ": " + record.getMessage() + "\n";
        }
    }
}

