/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.core.VirtualNetworkClient;
import com.oracle.bmc.core.model.Subnet;
import com.oracle.bmc.core.requests.GetSubnetRequest;
import com.oracle.bmc.core.responses.GetSubnetResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.OCIUtils;

public class VirtualNetworkClientManager {
    private static AbstractAuthenticationDetailsProvider provider;
    private Logger logger;
    private static VirtualNetworkClient client;

    public VirtualNetworkClientManager(OCIAuthentication ociAuthentication, Logger logger) {
        if (client == null) {
            provider = OCIUtils.getAuthenticationDetailsProvider(ociAuthentication);
            client = VirtualNetworkClient.builder().build(provider);
        }
        this.logger = logger;
    }

    private void log(Level level, String message) {
        if (this.logger != null) {
            this.logger.log(level, message);
        } else {
            System.out.println(message);
        }
    }

    public Subnet getSubnet(String subnetId) {
        GetSubnetRequest request = GetSubnetRequest.builder().subnetId(subnetId).build();
        GetSubnetResponse response = client.getSubnet(request);
        return response.getSubnet();
    }

    public String getVcnId(String subnetId) {
        Subnet subnet = this.getSubnet(subnetId);
        if (subnet == null) {
            return null;
        }
        return subnet.getVcnId();
    }
}

