/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.oci;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.database.DatabaseClient;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.database.model.DbHomeSummary;
import com.oracle.bmc.database.model.DbSystem;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.InstanceMetadata;
import oracle.dbtools.extension.rcv.oci.InstanceMetadataClient;
import oracle.dbtools.extension.rcv.oci.OCIUtils;
import oracle.dbtools.extension.rcv.workflows.Result;

public class DatabaseClientManager {
    private static DatabaseClient databaseClient;

    public DatabaseClientManager(OCIAuthentication authentication) {
        OCIAuthentication.Method method = authentication.getMethod();
        AbstractAuthenticationDetailsProvider provider = OCIUtils.getAuthenticationDetailsProvider(authentication);
        databaseClient = DatabaseClient.builder().build(provider);
    }

    public static String getDbSystemOcid() throws IOException, InterruptedException {
        InstanceMetadata instanceMetadata = new InstanceMetadata(InstanceMetadataClient.getInstanceMetadataResponse());
        return instanceMetadata.getDisplayName();
    }

    public DbSystem getDbSystem(String dbSystemId) {
        GetDbSystemResponse getDbSystemResponse;
        GetDbSystemRequest getDbSystemRequest = GetDbSystemRequest.builder().dbSystemId(dbSystemId).build();
        try {
            getDbSystemResponse = databaseClient.getDbSystem(getDbSystemRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException(RcvMessages.format("OCI_DATABASE_API_GET_DBSYSTEM", dbSystemId), e);
        }
        return getDbSystemResponse.getDbSystem();
    }

    public DatabaseSummary getDatabaseSummary(String dbUniqueName) {
        ListDatabasesResponse response;
        ListDbHomesResponse listDbHomesResponse;
        GlobalMetadata globalMetadata = RCVCommandBase.getGlobalMetadata();
        String dbSystemId = globalMetadata.getDbSystemOcid();
        DbSystem dbSystem = this.getDbSystem(dbSystemId);
        if (dbSystem == null) {
            return null;
        }
        String compartmentId = dbSystem.getCompartmentId();
        ListDbHomesRequest listDbHomesRequest = ListDbHomesRequest.builder().compartmentId(compartmentId).dbSystemId(dbSystemId).build();
        try {
            listDbHomesResponse = databaseClient.listDbHomes(listDbHomesRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException(RcvMessages.format("OCI_DATABASE_API_GET_HOMES", compartmentId, dbSystemId), e);
        }
        List dbHomeSummaryList = listDbHomesResponse.getItems();
        if (dbHomeSummaryList.isEmpty()) {
            return null;
        }
        DbHomeSummary dbHomeSummary = (DbHomeSummary)dbHomeSummaryList.get(0);
        if (dbHomeSummary == null) {
            return null;
        }
        String dbHomeId = dbHomeSummary.getId();
        ListDatabasesRequest listDatabasesRequest = ListDatabasesRequest.builder().systemId(dbSystemId).compartmentId(compartmentId).dbHomeId(dbHomeId).build();
        try {
            response = databaseClient.listDatabases(listDatabasesRequest);
        }
        catch (Exception e) {
            throw Result.ociDatabaseApiException(RcvMessages.format("OCI_DATABASE_API_GET_DBSYSTEM", compartmentId, dbSystemId, dbHomeId), e);
        }
        List databases = response.getItems();
        databases = databases.stream().filter(db -> db.getDbUniqueName() != null && db.getDbUniqueName().equalsIgnoreCase(dbUniqueName) && db.getLifecycleState().equals((Object)DatabaseSummary.LifecycleState.Available)).collect(Collectors.toList());
        if (databases != null && !databases.isEmpty()) {
            return (DatabaseSummary)databases.get(0);
        }
        return null;
    }
}

