/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.task;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.models.ConnectString;
import oracle.dbtools.extension.rcv.models.RMANScript;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.systemcommands.RMANCommand;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.models.task.Task;
import oracle.dbtools.extension.rcv.models.task.TaskInfo;
import oracle.dbtools.extension.rcv.utils.ScriptFactory;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Workflow;

public class RMANTask
extends Task {
    private Database database;
    private boolean runInBackground;
    private Logger logger;
    private Process process;
    private String rmanLogFile;

    public RMANTask(TaskInfo taskInfo, Database database, String rmanLogFile, Logger logger) {
        super(taskInfo);
        this.database = database;
        this.rmanLogFile = rmanLogFile;
        this.logger = logger;
    }

    public RMANTask logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public RMANTask runInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
        return this;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public void setRmanLogFile(String rmanLogFile) {
        this.rmanLogFile = rmanLogFile;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getRmanLogFile() {
        return this.rmanLogFile;
    }

    @Override
    public Result run() {
        TaskInfo taskInfo = this.getTaskInfo();
        Object scriptPath = taskInfo.getScriptPath();
        int i = ((String)scriptPath).lastIndexOf(".");
        if (i > 0 && i < ((String)scriptPath).length() - 1) {
            String extension = ((String)scriptPath).substring(i + 1);
            if (!extension.equals("rman")) {
                scriptPath = (String)scriptPath + ".rman";
            }
        } else {
            scriptPath = (String)scriptPath + ".rman";
        }
        RMANScript rmanScript = null;
        try {
            rmanScript = ScriptFactory.generateScriptFromClob((String)scriptPath, taskInfo.getContent());
        }
        catch (IOException | SQLException e) {
            Workflow.logException(e, this.logger);
            return Result.ftwUnhandledError();
        }
        ConnectString target = new ConnectString.Builder().privilege("sysbackup").build();
        ConnectString catalog = new ConnectString.Builder(this.database.getFleetAgentContext().getProtectedDatabaseCache().getCredentialAlias()).build();
        RMANCommand rmanCommand = new RMANCommand.Builder(target, catalog, rmanScript).tnsAdmin(this.database.getFleetAgentContext().getTnsAdmin()).oracleSid(this.database.getDatabaseMetadataCache().getOracleSid()).oracleHome(DatabaseConfig.getOracleHome(this.database.getDbUniqueName())).logFile(this.rmanLogFile).logger(this.logger).build();
        if (this.runInBackground) {
            try {
                this.process = rmanCommand.runInBackground(rmanCommand.generateCommand());
            }
            catch (IOException e) {
                return new Result(Status.FAILED, "Failed to execute RMAN task: " + e.getMessage());
            }
            return new Result(Status.SUCCESS);
        }
        SystemCommand.ExecutionResult rmanTaskResult = rmanCommand.execute();
        if (rmanTaskResult.getReturnCode() == 0) {
            return new Result(Status.SUCCESS);
        }
        return Result.taskmanRmanScriptError(String.valueOf(rmanTaskResult.getReturnCode()));
    }
}

