/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.ora;

import java.util.ArrayList;
import java.util.List;

public class Node<V> {
    private V value;
    private List<Node<V>> children;

    public Node(V value) {
        this.value = value;
        this.children = new ArrayList<Node<V>>();
    }

    public V getValue() {
        return this.value;
    }

    public List<Node<V>> getChildren() {
        return this.children;
    }

    public Node<V> addChild(Node<V> child) {
        this.children.add(child);
        return this;
    }

    public Node<V> addChildren(List<Node<V>> children) {
        this.children.addAll(children);
        return this;
    }

    public Node<V> setChildren(List<Node<V>> newChildren) {
        this.children = newChildren;
        return this;
    }

    public Node<V> setValue(V v) {
        this.value = v;
        return this;
    }

    public Node<V> getNode(V value) {
        if (this.value.equals(value)) {
            return this;
        }
        for (Node<V> child : this.children) {
            Node<V> result;
            if (child == null || (result = child.getNode(value)) == null) continue;
            return result;
        }
        return null;
    }

    public List<Node<V>> getAllNodes(V value) {
        ArrayList<Node<V>> results = new ArrayList<Node<V>>();
        ArrayList<Node<V>> nodes = new ArrayList<Node<V>>();
        nodes.add(this);
        while (!nodes.isEmpty()) {
            Node n = (Node)nodes.remove(0);
            if (n == null) continue;
            if (n.getValue().equals(value)) {
                results.add(n);
            }
            nodes.addAll(n.children);
        }
        return results;
    }

    public Node<V> remove(V value) {
        for (Node<V> child : this.children) {
            if (child == null) continue;
            if (child.value.equals(value)) {
                this.children.remove(child);
                return child;
            }
            Node<V> removed = child.remove(value);
            if (removed == null) continue;
            return removed;
        }
        return null;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }
}

