/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.jobs;

import java.nio.file.Path;
import java.time.LocalTime;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.jobs.FleetAgentJob;
import oracle.dbtools.extension.rcv.models.jobs.JobType;
import oracle.dbtools.extension.rcv.models.jobs.TimeUnit;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.raptor.scheduler.job.Job;

public class BackupJob
extends FleetAgentJob {
    private static final JobType type = JobType.BACKUP;
    private static final int INTERVAL = 15;
    private String dbUniqueName;
    private String jobName;
    private RCVCommand rcvCommand;

    public BackupJob(String dbUniqueName) {
        super(FleetAgentContext.getJobName(dbUniqueName, type), new RCVCommand(RCVCommand.SubCommand.FETCH_TASK).addFlag(RCVOptions.Options.SCHEDULED));
        this.dbUniqueName = dbUniqueName;
    }

    @Override
    public boolean isLocalOnly() {
        return false;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return TimeUnit.MINUTE;
    }

    @Override
    public int getDefaultInterval() {
        return 15;
    }

    @Override
    public Job createJob(Integer start, Integer interval) {
        if (interval != null && (interval == 0 || interval > 60)) {
            throw Result.invalidOptionException("The backup job interval must be between 1 to 60 minutes.");
        }
        if (start != null && (start < 0 || start > 59)) {
            throw Result.invalidOptionException("The backup job starting minute must be between 0 to 59.");
        }
        if (interval == null) {
            interval = 15;
        }
        if (start == null) {
            LocalTime now = LocalTime.now();
            int minute = now.getMinute();
            int second = now.getSecond();
            int targetMinute = second < 30 ? minute + 1 : minute + 2;
            start = targetMinute % interval;
        }
        String cron = String.format("0 %d/%d * * * ?", start, interval);
        return new Job(super.getJobName(), cron, super.getCommand().toString(), FleetAgentContext.get(this.dbUniqueName).getConnectionName());
    }

    private int getRandomStartMinute(int interval) {
        if (interval == 1) {
            return 0;
        }
        if (60 % interval == 0) {
            return ThreadLocalRandom.current().nextInt(interval - 1);
        }
        return ThreadLocalRandom.current().nextInt(59 % interval);
    }

    @Override
    public Optional<Path> getLastExecutedLog() {
        String logDir = FleetAgentContext.get(this.dbUniqueName).getLogsDirectory();
        String prefix = RCVCommand.SubCommand.FETCH_TASK.toString().replaceAll("\\s+", "_").toLowerCase();
        return Utils.getMostRecentFile(logDir, prefix, "log");
    }
}

