/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.models.commandengine;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineRequest;
import oracle.dbtools.extension.rcv.models.commandengine.FleetEngineResponse;
import oracle.dbtools.extension.rcv.workflows.Result;

public class UpdateActionStatusRequest
extends FleetEngineRequest {
    private int sessionId;
    private int actionId;
    private String errorString;
    private int errorNum;
    private static final String ACTION_STATUS = "call dbms_ra_cmd_engine.action_status(?, ?, ?, ?, ?, ?)";

    private UpdateActionStatusRequest(Builder builder) {
        super(builder);
        String dbUniqueName = super.getDbUniqueName();
        this.getLogger().log(Level.FINE, "DbUniqueName: " + dbUniqueName.toUpperCase());
        this.getLogger().log(Level.FINE, "SessionId     : " + builder.sessionId);
        this.getLogger().log(Level.FINE, "ActionId    : " + builder.actionId);
        this.getLogger().log(Level.FINE, "ErrorString : " + builder.errorString);
        this.getLogger().log(Level.FINE, "ErrorNum    : " + builder.errorNum);
        try {
            this.errorString = builder.errorString;
            this.errorNum = builder.errorNum;
            this.actionId = builder.actionId;
            this.sessionId = builder.sessionId;
            CallableStatement cs = super.getCallableStatement();
            cs.setInt("ACTION_ID", this.actionId);
            cs.setInt("SESSION_ID", this.sessionId);
            if (this.errorString == null) {
                cs.setNull("ERROR_STRING", 12);
            } else {
                cs.setString("ERROR_STRING", this.errorString);
            }
            if (this.errorNum == -1) {
                cs.setNull("ERROR_NUM", 4);
            } else {
                cs.setInt("ERROR_NUM", this.errorNum);
            }
            cs.registerOutParameter("STATUS_CODE_OUT", 4);
            cs.registerOutParameter("STATUS_MESG_OUT", 12);
        }
        catch (SQLException e) {
            throw Result.fengDatabaseSqlException(RcvMessages.format("FENG_UPDATE_TASK_STATUS_ERROR_MSG", new Object[0]), e);
        }
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    public FleetEngineResponse<Void> execute() throws SQLException {
        CallableStatement cs = super.getCallableStatement();
        cs.execute();
        int statusCode = cs.getInt("STATUS_CODE_OUT");
        String statusMessage = cs.getString("STATUS_MESG_OUT");
        this.getLogger().log(Level.FINE, "StatusCode: " + statusCode);
        this.getLogger().log(Level.FINE, "StatusMesg: " + statusMessage);
        return new FleetEngineResponse<Object>(statusCode, statusMessage, null);
    }

    public static class Builder
    extends FleetEngineRequest.Builder<Builder> {
        private int sessionId;
        private int actionId;
        private String errorString;
        private int errorNum = -1;

        public Builder(Connection conn, String dbUniqueName, int sessionId, int actionId, Logger logger) {
            super(conn, dbUniqueName, UpdateActionStatusRequest.ACTION_STATUS, logger);
            this.sessionId = sessionId;
            this.actionId = actionId;
        }

        public Builder errorNum(int errorNum) {
            this.errorNum = errorNum;
            return this.self();
        }

        public Builder errorString(String errorString) {
            this.errorString = errorString;
            return this.self();
        }

        public Builder logger(Logger logger) {
            super.setLogger(logger);
            return this.self();
        }

        @Override
        public UpdateActionStatusRequest build() {
            return new UpdateActionStatusRequest(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }

    public static enum Status {
        AGENT_FAIL(500),
        AGENT_FAIL_RMAN(501),
        AGENT_FAIL_DB_SHUTDOWN(502),
        AGENT_WORK_IN_PROGRESS(600),
        UNKNOWN_VALUE(-1);

        private final int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Status fromInt(int i) {
            for (Status status : Status.values()) {
                if (status.getValue() != i) continue;
                return status;
            }
            return UNKNOWN_VALUE;
        }
    }
}

