/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.commands.completer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.app.CompletionItem;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.OCIAuthentication;
import oracle.dbtools.extension.rcv.oci.OCIDatabaseRecoveryClient;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.completer.SemanticCompleter;
import oracle.dbtools.util.Logger;

public final class RecoverySubnetsListCompleter
implements SemanticCompleter {
    public List<CompletionItem> complete(String prefix, ScriptRunnerContext ctx, Map<String, Object> transformedOptionsMap) {
        try {
            OCIAuthentication authentication = GlobalMetadata.load().getAuthentication();
            OCIProfiles profiles = OCIProfiles.builder().configPath(authentication.getConfigFile()).build();
            OCIProfile profile = profiles.getProfile(authentication.getProfileName());
            if (profile != null) {
                OCIDatabaseRecoveryClient.Builder builder = OCIDatabaseRecoveryClient.builder(profile);
                String region = ctx.getStringProperty("oci.region.name", null);
                if (region != null) {
                    builder.region(region);
                }
                OCIDatabaseRecoveryClient client = builder.build();
                Object compartmentId = transformedOptionsMap.get(RCVOptions.COMPARTMENT_ID_O.getId().toString());
                if (compartmentId != null) {
                    ctx.putProperty("oci.recoverySubnet.compartment", compartmentId);
                    return this.getItems(client, (String)compartmentId, prefix);
                }
                return this.getItems(client, profile.getTenantId(), prefix);
            }
        }
        catch (IOException e) {
            Logger.warn(this.getClass(), (String)e.getMessage(), (Throwable)e);
        }
        return List.of();
    }

    private List<CompletionItem> getItems(OCIDatabaseRecoveryClient client, String compartmentId, String prefix) {
        return client.listRecoverySubnets(compartmentId).stream().filter(rs -> !rs.getDisplayName().equals(prefix.replace(",", ""))).map(recoverySubnet -> new CompletionItem((String)(prefix.isBlank() ? recoverySubnet.getDisplayName() : prefix + recoverySubnet.getDisplayName()), CompletionItem.Type.KEYWORD)).collect(Collectors.toUnmodifiableList());
    }
}

