/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.rtrt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.util.List;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseMetadataCache;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.check.rtrt.CheckMessages;

public class WalletRootCheck
extends Check {
    private Connection conn;
    public static final String NAME = "Wallet Root Setup";
    public static final String ID = "wallet_root";
    private String walletRoot;
    private boolean onboardingCheck;
    private Database database;

    public WalletRootCheck(Connection conn) {
        this(conn, false);
    }

    public WalletRootCheck(Connection conn, boolean onboardingCheck) {
        super(conn, NAME, ID);
        this.conn = conn;
        this.database = RCVCommandBase.getDatabase(conn);
        this.walletRoot = this.database.getDatabaseMetadataCache().getWalletRoot();
        this.onboardingCheck = onboardingCheck;
    }

    @Override
    public CheckResult run() {
        if (this.walletRoot == null || this.walletRoot.isEmpty() || this.walletRoot.equals("null")) {
            if (this.onboardingCheck) {
                return new CheckResult(CheckResult.Status.SKIPPED, "wallet_root is not configured.");
            }
            return new CheckResult(CheckResult.Status.FAIL, CheckMessages.getString("UNCONFIGURED_WALLET_ROOT"));
        }
        if (!Files.exists(Paths.get(this.walletRoot, new String[0]), new LinkOption[0])) {
            return new CheckResult(CheckResult.Status.FAIL, CheckMessages.getString("INVALID_WALLET_ROOT"));
        }
        return new CheckResult(CheckResult.Status.PASS, "wallet_root is configured correctly.");
    }

    public boolean isWalletRootShared() {
        DatabaseMetadataCache dbMetadataCache = this.database.getDatabaseMetadataCache();
        if (dbMetadataCache.runsOnMultipleNodes()) {
            Path testFile;
            try {
                testFile = Files.createTempFile(Paths.get(this.walletRoot, new String[0]), "rcv", String.valueOf(ProcessHandle.current().pid()), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to check if wallet_root points to a shared location", e);
            }
            List<SshHelper> sshConnections = dbMetadataCache.getSshConnections();
            String command = String.format("ls %s", testFile.toString());
            for (SshHelper sshConnection : sshConnections) {
                SystemCommand.ExecutionResult result = sshConnection.executeCommand(command);
                if (result.getReturnCode() == 0) continue;
                try {
                    Files.deleteIfExists(testFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            try {
                Files.deleteIfExists(testFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return true;
    }
}

