/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.check.health;

import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.CheckResult;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.RCVContext;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class SchedulerStatusCheck
extends Check {
    public static final String NAME = "Scheduler Status";
    public static final String ID = "scheduler_status";
    private WorkflowLogger logger;
    private Connection conn;

    public SchedulerStatusCheck(Connection conn) {
        super(conn, NAME, ID);
        this.conn = conn;
        this.logger = this.getLogger();
    }

    @Override
    public CheckResult run() {
        List<SshHelper> sshConnections = RCVCommandBase.getDatabase(this.conn).getDatabaseMetadataCache().getSshConnections();
        ArrayList<String> failedNodes = new ArrayList<String>();
        String sqlclHome = System.getenv("SQL_HOME");
        if (sqlclHome == null) {
            sqlclHome = RCVCommandBase.getOracleHome();
        }
        String sqlPath = String.join((CharSequence)File.separator, sqlclHome, "bin", "sql");
        List<String> daemonStatusArgs = List.of(sqlPath, "-daemon", "status");
        SystemCommand.ExecutionResult statusResult = new SystemCommand().logger(this.logger.getLogger()).run(daemonStatusArgs);
        this.logger.log(Level.FINE, statusResult.getOutput());
        if (!this.isDaemonRunning(statusResult)) {
            failedNodes.add(RCVContext.getLocalHost());
        }
        for (SshHelper sshConnection : sshConnections) {
            String remoteCommand = String.join((CharSequence)" ", sqlPath, "-daemon", "status");
            String remoteHost = sshConnection.getHost();
            statusResult = sshConnection.executeCommand(remoteCommand);
            this.logger.log(Level.FINE, remoteHost + ": " + statusResult.getOutput());
            if (this.isDaemonRunning(statusResult)) continue;
            failedNodes.add(remoteHost);
        }
        if (failedNodes.isEmpty()) {
            return new CheckResult(CheckResult.Status.PASS, "Scheduler daemon is running.");
        }
        String message = "Scheduler daemon is not running on the following nodes: " + String.join((CharSequence)", ", failedNodes);
        return new CheckResult(CheckResult.Status.FAIL, message, "Please start the scheduler on these nodes to protect your database by running: sql -daemon start");
    }

    private boolean isDaemonRunning(SystemCommand.ExecutionResult executionResult) {
        if (executionResult.getReturnCode() == 0) {
            String output = executionResult.getOutput();
            return output.toLowerCase().contains("daemon is running");
        }
        return false;
    }
}

