/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.function.Consumer;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.OracleConfigurationSyntaxException;
import oracle.dbtools.core.tns.SyntaxErrors;
import oracle.dbtools.core.tns.Token;

class TokenParser
implements Consumer<Token> {
    private final OracleConfiguration.Builder root;
    private Token previousToken;
    private OracleConfiguration.Builder builder;
    private boolean rhs;

    private TokenParser(OracleConfiguration.Builder root) {
        this.root = root;
        this.builder = root;
        this.rhs = true;
    }

    TokenParser() {
        this(OracleConfiguration.builder());
    }

    OracleConfiguration configuration() {
        return this.root.build();
    }

    private void allowAtomOrStartList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR);
    }

    private void allowAtomOrStartListOrEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR, Token.Type.END_PAIR);
    }

    private void allowAtom(Token token) {
        SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
    }

    private void allowEquals(Token token) {
        SyntaxErrors.allow(token, Token.Type.EQ);
    }

    private void allowSeparatorOrEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.SEPARATOR, Token.Type.END_PAIR);
    }

    private void allowEndList(Token token) {
        SyntaxErrors.allow(token, Token.Type.END_PAIR);
    }

    private void allowEndListOrStartList(Token token) {
        SyntaxErrors.allow(token, Token.Type.END_PAIR, Token.Type.BEGIN_PAIR);
    }

    private void allowUnquotedAtom(Token token) {
        SyntaxErrors.allow(token, Token.Type.UNQUOTED_ATOM);
    }

    @Override
    public void accept(Token token) {
        if (this.previousToken == null) {
            this.allowAtomOrStartList(token);
        } else {
            switch (this.previousToken.type) {
                case SINGLE_QUOTED_ATOM: 
                case DOUBLE_QUOTED_ATOM: {
                    if (this.rhs) {
                        this.allowEndList(token);
                        break;
                    }
                    this.allowEquals(token);
                    break;
                }
                case UNQUOTED_ATOM: {
                    if (this.rhs) {
                        this.allowSeparatorOrEndList(token);
                        break;
                    }
                    this.allowEquals(token);
                    break;
                }
                case SEPARATOR: {
                    this.allowUnquotedAtom(token);
                    break;
                }
                case EQ: {
                    this.allowAtomOrStartListOrEndList(token);
                    break;
                }
                case BEGIN_PAIR: {
                    this.rhs = false;
                    this.allowAtom(token);
                    break;
                }
                case END_PAIR: {
                    this.allowEndListOrStartList(token);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected previous token: " + String.valueOf((Object)this.previousToken.type));
                }
            }
        }
        switch (token.type) {
            case EQ: {
                this.rhs = true;
                break;
            }
            case SINGLE_QUOTED_ATOM: 
            case DOUBLE_QUOTED_ATOM: 
            case UNQUOTED_ATOM: {
                if (this.rhs) {
                    this.builder.value(token.text);
                    break;
                }
                this.builder.name(token.text);
                break;
            }
            case SEPARATOR: {
                this.builder.value(",");
                break;
            }
            case BEGIN_PAIR: {
                this.builder = this.builder.beginPair();
                break;
            }
            case END_PAIR: {
                try {
                    this.builder = this.builder.endPair();
                    break;
                }
                catch (IllegalStateException e) {
                    OracleConfiguration.Position position = token.start();
                    String message = "Unbalanced parentheses detected";
                    OracleConfiguration.SyntaxError syntaxError = OracleConfiguration.SyntaxError.builder().kind(OracleConfiguration.SyntaxError.Kind.UNBALANCED_PARENS).position(position).message("Unbalanced parentheses detected").build();
                    throw OracleConfigurationSyntaxException.of(syntaxError, e);
                }
            }
            default: {
                throw SyntaxErrors.expected(token, Token.Type.EQ, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR, Token.Type.END_PAIR);
            }
        }
        this.previousToken = token;
    }

    public String toString() {
        return this.root.toString();
    }
}

