/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.system;

import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import oracle.dbtools.core.system.SystemLocale;

public interface SystemContext {
    public static SystemContext global() {
        return SystemContext.builder().fileSystem(FileSystems.getDefault()).systemProperties(System.getProperties()).environment(System.getenv()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> environment();

    default public String getEnvironmentVariable(String name) {
        return this.environment().get(name);
    }

    default public Path getPath(String first, String ... more) {
        return this.fileSystem() == null ? null : this.fileSystem().getPath(first, more);
    }

    default public String getSystemProperty(String name) {
        return this.systemProperties().get(name);
    }

    default public Locale locale() {
        return SystemLocale.of(this.systemProperties()).locale();
    }

    public FileSystem fileSystem();

    public Map<String, String> systemProperties();

    public Clock clock();

    public Builder modify();

    public static class Builder
    implements SystemContext {
        private final Map<String, String> environment;
        private final Map<String, String> systemProperties;
        private Clock clock = Clock.systemUTC();
        private FileSystem fileSystem;
        private Locale locale;

        protected Builder() {
            this.environment = new TreeMap<String, String>();
            this.systemProperties = new TreeMap<String, String>();
        }

        @Override
        public Map<String, String> environment() {
            return this.environment;
        }

        @Override
        public Map<String, String> systemProperties() {
            return this.systemProperties;
        }

        @Override
        public Clock clock() {
            return this.clock;
        }

        @Override
        public Builder modify() {
            return this;
        }

        @Override
        public FileSystem fileSystem() {
            return this.fileSystem;
        }

        public Builder clock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder environment(String name, String value) {
            this.environment.put(name, value);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            if (environment != null) {
                environment.forEach(this::environment);
            }
            return this;
        }

        public Builder fileSystem(FileSystem fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder systemProperties(Properties properties) {
            if (properties != null) {
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.systemProperty(entry.getKey().toString(), entry.getValue().toString());
                }
            }
            return this;
        }

        public Builder systemProperties(Map<String, String> systemProperties) {
            if (systemProperties != null) {
                this.systemProperties.putAll(systemProperties);
            }
            return this;
        }

        public Builder systemProperty(String name, String value) {
            this.systemProperties.put(name, value);
            return this;
        }

        public SystemContext build() {
            return new Base(this);
        }

        public String toString() {
            return this.build().toString();
        }
    }

    public static class Base
    implements SystemContext {
        private final Clock clock;
        private final Map<String, String> environment;
        private final FileSystem fileSystem;
        private final Map<String, String> systemProperties;
        private final Locale locale;

        protected Base(Builder builder) {
            this.clock = builder.clock;
            this.fileSystem = builder.fileSystem;
            this.systemProperties = new TreeMap<String, String>(builder.systemProperties);
            this.locale = builder.locale == null ? SystemLocale.of(this.systemProperties).locale() : builder.locale;
            this.environment = new TreeMap<String, String>(builder.environment);
        }

        @Override
        public Map<String, String> environment() {
            return this.environment;
        }

        @Override
        public FileSystem fileSystem() {
            return this.fileSystem;
        }

        @Override
        public Map<String, String> systemProperties() {
            return this.systemProperties;
        }

        @Override
        public Locale locale() {
            return this.locale;
        }

        @Override
        public Clock clock() {
            return this.clock;
        }

        @Override
        public Builder modify() {
            return SystemContext.builder().clock(this.clock).environment(this.environment).fileSystem(this.fileSystem).systemProperties(this.systemProperties);
        }

        public String toString() {
            return "{clock=" + String.valueOf(this.clock) + ", fileSystem=" + String.valueOf(this.fileSystem) + ", locale=" + String.valueOf(this.locale) + "}";
        }
    }
}

