/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.feature.flags;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.HasSize;
import oracle.dbtools.core.feature.flags.FeatureFlag;
import oracle.dbtools.core.feature.flags.FeatureFlagParseException;
import oracle.dbtools.core.feature.flags.FeatureFlagsFile;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.io.file.HomeFolder;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;

public class FeatureFlags
implements Iterable<FeatureFlag>,
HasSize {
    private static final OracleJsonFactory JSON = new OracleJsonFactory();
    private static final FeatureFlags EMPTY_FLAGS = new FeatureFlags(Collections.emptySet());
    private final Set<FeatureFlag> flags;

    private FeatureFlags(Builder builder) {
        this.flags = FeatureFlags.copyOf(builder.flags);
    }

    private FeatureFlags(Set<FeatureFlag> flags) {
        this.flags = flags;
    }

    private static <E extends Comparable<E>> Set<E> copyOf(SortedSet<E> existing) {
        if (existing.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new TreeSet<E>(existing));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static FeatureFlags empty() {
        return EMPTY_FLAGS;
    }

    public static FeatureFlags read(Readable content) throws IOException {
        try (PushbackReader stream = new PushbackReader(InputOutputStreams.instance().asReader(content));){
            FeatureFlags featureFlags;
            block13: {
                int c = stream.read();
                if (c == -1) {
                    FeatureFlags featureFlags2 = FeatureFlags.empty();
                    return featureFlags2;
                }
                stream.unread(c);
                OracleJsonParser parser = JSON.createJsonTextParser((Reader)stream);
                try {
                    featureFlags = FeatureFlags.read(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return featureFlags;
        }
    }

    public static FeatureFlags read(CharSequence content) throws IOException {
        return FeatureFlags.read(InputOutputStreams.instance().asReader(content));
    }

    private static FeatureFlags read(OracleJsonParser parser) {
        Builder featureFlags = FeatureFlags.builder();
        try {
            parser.next();
            OracleJsonObject json = parser.getObject();
            Set keys = json.keySet();
            for (String key : keys) {
                FeatureFlag featureFlag = FeatureFlag.of(key);
                boolean enabled = json.getBoolean(key);
                if (!enabled) continue;
                featureFlags.add(featureFlag);
            }
        }
        catch (OracleJsonException e) {
            throw new FeatureFlagParseException(e);
        }
        return featureFlags.build();
    }

    public static FeatureFlags of(HomeFolder home) throws IOException {
        return FeatureFlagsFile.of(home).read();
    }

    public FeatureFlags forProduct(String product) {
        if (product == null || product.isBlank() || this.flags.isEmpty()) {
            return FeatureFlags.empty();
        }
        Builder flags = FeatureFlags.builder();
        this.flags.stream().filter(flag -> flag.product().equals(product)).forEach(flags::add);
        return flags.build();
    }

    public String toString() {
        return this.flags.toString();
    }

    public boolean isEnabled(FeatureFlag featureFlag) {
        return this.flags.contains(featureFlag);
    }

    @Override
    public int size() {
        return this.flags.size();
    }

    public Stream<FeatureFlag> stream() {
        return this.flags.stream();
    }

    @Override
    public Iterator<FeatureFlag> iterator() {
        return this.flags.iterator();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlags that = (FeatureFlags)o;
        return Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        return Objects.hashCode(this.flags);
    }

    public static class Builder {
        private final SortedSet<FeatureFlag> flags = new TreeSet<FeatureFlag>();

        private Builder() {
        }

        public Builder add(FeatureFlag featureFlag) {
            this.flags.add(featureFlag);
            return this;
        }

        public Builder remove(FeatureFlag featureFlag) {
            this.flags.remove(featureFlag);
            return this;
        }

        public FeatureFlags build() {
            return this.flags.isEmpty() ? FeatureFlags.empty() : new FeatureFlags(this);
        }
    }
}

