/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import oracle.dbtools.core.connections.api.DefaultExceptionFactory;

public interface Connections {
    public Identifier identifier(CharSequence var1) throws IdentifierSyntaxException;

    default public Provider resolve(Identifier identifier) throws ProviderUnavailableException {
        return this.resolver().resolve(identifier);
    }

    default public Provider resolve(CharSequence identifier) throws ProviderUnavailableException {
        Objects.requireNonNull(identifier);
        Identifier id = this.identifier(identifier);
        if (id == null) {
            return null;
        }
        return this.resolver().resolve(id);
    }

    public Resolver resolver();

    public static interface Resolver {
        public Provider resolve(Identifier var1) throws ProviderUnavailableException;
    }

    public static interface Identifier {
        public int hashCode();

        public boolean equals(Object var1);
    }

    public static abstract class Provider
    implements Supplier<Connection> {
        private final Exception.Factory errorFactory;
        private final Identifier identifier;

        protected Provider(Identifier identifier) {
            this(identifier, Exception.Factory.instance());
        }

        protected Provider(Identifier identifier, Exception.Factory errorFactory) {
            this.identifier = identifier;
            this.errorFactory = errorFactory;
        }

        protected Exception.Factory errorFactory() {
            return this.errorFactory;
        }

        public void execute(Operation operation) {
            try (Connection connection = this.get();){
                operation.accept(connection);
            }
            catch (SQLException e) {
                throw this.errorFactory.operationFailed(this.identifier(), e);
            }
        }

        @Override
        public abstract Connection get() throws ConnectionUnavailableException;

        public Identifier identifier() {
            return this.identifier;
        }
    }

    public static class ProviderUnavailableException
    extends Exception {
        protected ProviderUnavailableException(Identifier identifier, Throwable cause) {
            super(identifier, cause);
        }
    }

    public static class OperationFailedException
    extends Exception {
        protected OperationFailedException(Identifier identifier, Throwable cause) {
            super(identifier, cause);
        }
    }

    public static class IdentifierSyntaxException
    extends IllegalArgumentException {
        private final CharSequence text;

        protected IdentifierSyntaxException(CharSequence text, Throwable cause) {
            super(cause);
            this.text = text;
        }

        @Override
        public String getMessage() {
            return "Invalid Identifier Syntax: " + String.valueOf(this.text());
        }

        public CharSequence text() {
            return this.text;
        }
    }

    public static abstract class Exception
    extends IllegalStateException {
        private final Identifier identifier;

        protected Exception(Identifier identifier, Throwable cause) {
            super(cause);
            this.identifier = identifier;
        }

        public Identifier identifier() {
            return this.identifier;
        }

        public static interface Factory {
            public static Factory instance() {
                return DefaultExceptionFactory.instance();
            }

            public ConnectionUnavailableException connectionUnavailable(Identifier var1, Throwable var2);

            default public ConnectionNotAuthorizedOrNotFoundException connectionNotAuthorizedOrNotFound(Identifier identifier, Throwable cause) {
                return new ConnectionNotAuthorizedOrNotFoundException(identifier, cause);
            }

            public IdentifierSyntaxException identifierSyntaxException(CharSequence var1, Throwable var2);

            public OperationFailedException operationFailed(Identifier var1, Throwable var2);

            default public ProviderUnavailableException providerUnavailable(Identifier identifier, Throwable cause) {
                return this.supplierUnavailable(identifier, cause);
            }

            @Deprecated
            public ProviderUnavailableException supplierUnavailable(Identifier var1, Throwable var2);
        }
    }

    public static class ConnectionNotAuthorizedOrNotFoundException
    extends ConnectionUnavailableException {
        protected ConnectionNotAuthorizedOrNotFoundException(Identifier identifier, Throwable cause) {
            super(identifier, cause);
        }
    }

    public static class ConnectionUnavailableException
    extends Exception {
        protected ConnectionUnavailableException(Identifier identifier, Throwable cause) {
            super(identifier, cause);
        }
    }

    public static interface Operation {
        public void accept(Connection var1) throws SQLException;

        default public Operation andThen(Operation after) {
            Objects.requireNonNull(after);
            return connection -> {
                this.accept(connection);
                after.accept(connection);
            };
        }
    }
}

