/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql.doc;

import java.io.Serializable;
import java.util.Set;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.plsql.SqlEarley;
import oracle.dbtools.parser.plsql.doc.HarvestDoc;
import oracle.dbtools.parser.plsql.doc.Substr;

public class DocURL
implements Serializable {
    private static final long serialVersionUID = 1L;
    static String docRoot = "https://docs.oracle.com/";
    public final String pageParagraph;
    public Manual man;

    public DocURL(Manual man, String doc) {
        this.pageParagraph = doc;
        this.man = man;
    }

    public DocURL(String man, String doc) {
        this.pageParagraph = doc;
        if (Manual.SQL.toString().equals(man)) {
            this.man = Manual.SQL;
        } else if (Manual.PLSQL.toString().equals(man)) {
            this.man = Manual.PLSQL;
        } else if (Manual.SQLPLUS.toString().equals(man)) {
            this.man = Manual.SQLPLUS;
        } else {
            throw new AssertionError((Object)(man + "??"));
        }
    }

    public String getPublicURL() {
        return this.man.getBasePublicURL() + this.pageParagraph;
    }

    public String getPrivateURL() {
        return this.man.getBasePrivateURL() + this.pageParagraph;
    }

    public String toString() {
        return this.getPublicURL();
    }

    public static void main(String[] args) {
        int regexp_like_condition = SqlEarley.getInstance().getSymbol("regexp_like_condition");
        int where_clause = SqlEarley.getInstance().getSymbol("where_clause");
        Set<Substr> templates = HarvestDoc.getTemplates().get(Service.lPair(regexp_like_condition, where_clause));
        for (Substr t : templates) {
            System.out.println(t.toString());
        }
    }

    public Object getMan() {
        return this.man;
    }

    public String getPageParagraph() {
        return this.pageParagraph;
    }

    public static enum Manual implements Serializable
    {
        SQL,
        PLSQL,
        SQLPLUS;


        public String getBasePrivateURL() {
            return this.getBasePublicURL();
        }

        public String getBasePublicURL() {
            switch (this.ordinal()) {
                case 0: {
                    return docRoot + "en/database/oracle/oracle-database/23/sqlrf/";
                }
                case 1: {
                    return docRoot + "en/database/oracle/oracle-database/23/lnpls/";
                }
                case 2: {
                    return docRoot + "en/database/oracle/oracle-database/19/sqpqr/";
                }
            }
            throw new AssertionError((Object)"VT:impossible");
        }
    }
}

