/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.arbori.util.Service;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parser;

public class RecognitionChain
extends ParseNode {
    LinkedList<Integer> deductions = new LinkedList();
    LinkedList<Integer> exceptions = new LinkedList();

    public RecognitionChain(ParseNode src) {
        super(src.from, src.to, -1, src.parser);
        if (src.lft != null) {
            this.lft = new RecognitionChain(src.lft);
            this.lft.parent = this;
        }
        if (src.rgt != null) {
            this.rgt = new RecognitionChain(src.rgt);
            this.rgt.parent = this;
        }
        this.symbols = src.symbols;
        LinkedList<Integer> content = new LinkedList<Integer>();
        for (int c : src.content()) {
            content.add(c);
        }
        Integer c = (Integer)content.removeLast();
        this.deductions.add(c);
        Parser.Tuple[] rules = this.parser.rules;
        block1: while (0 < content.size()) {
            Integer o;
            int cmp;
            Iterator iterator;
            c = this.deductions.getFirst();
            for (Parser.Tuple t : rules) {
                if (1 < t.rhs.length || t.rhs[0] == t.head) continue;
                iterator = content.iterator();
                while (iterator.hasNext()) {
                    cmp = (Integer)iterator.next();
                    if (cmp == c || t.head != c || t.rhs[0] != cmp) continue;
                    this.deductions.addFirst(cmp);
                    o = cmp;
                    content.remove(o);
                    continue block1;
                }
            }
            c = this.deductions.getLast();
            for (Parser.Tuple t : rules) {
                if (1 < t.rhs.length || t.rhs[0] == t.head) continue;
                iterator = content.iterator();
                while (iterator.hasNext()) {
                    cmp = (Integer)iterator.next();
                    if (cmp == c || t.head != cmp || t.rhs[0] != c) continue;
                    this.deductions.addLast(cmp);
                    o = cmp;
                    content.remove(o);
                    continue block1;
                }
            }
            this.exceptions.addAll(content);
            content.clear();
        }
    }

    @Override
    public String tree() {
        StringBuilder ret = new StringBuilder();
        Map<Long, Integer> depthMap = this.calculateDepth();
        for (ParseNode n : this.descendants()) {
            int depth = depthMap.get(Service.lPair(n.from, n.to));
            ret.append(new RecognitionChain(n).toString(depth, "___", false));
            ret.append("\n");
        }
        return ret.toString();
    }

    @Override
    protected String content(String auxMarker) {
        int s;
        StringBuilder ret = new StringBuilder();
        String pad = "  ";
        Iterator iterator = this.deductions.iterator();
        while (iterator.hasNext()) {
            s = (Integer)iterator.next();
            if (s == -1) continue;
            ret.append(pad + this.parser.allSymbols[s]);
            pad = " > ";
        }
        ret.append("  ");
        iterator = this.exceptions.iterator();
        while (iterator.hasNext()) {
            s = (Integer)iterator.next();
            ret.append(" " + this.parser.allSymbols[s]);
            if ((0 >= this.deductions.size() || 0 >= this.exceptions.size()) && 1 >= this.exceptions.size()) continue;
            ret.append("? ");
        }
        return ret.toString();
    }

    public static void main(String[] args) {
        Integer x11 = 11;
        Integer x22 = 22;
        LinkedList<Integer> content = new LinkedList<Integer>();
        content.add(11);
        content.add(22);
        content.remove(x22);
        System.out.println(content);
    }
}

