/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;

public class IdentiyColumnDescription {
    private String columnName = "";
    private String generate = "ALWAYS";
    private String startWith = "";
    private String incrementBy = "";
    private String maxValue = "";
    private String minValue = "";
    private String cycle = "NO";
    private String noCache = "NO";
    private String cache = "";
    private String order = "NO";
    private transient Column column;
    private transient Table table;

    public IdentiyColumnDescription() {
    }

    public IdentiyColumnDescription(Column column) {
        this.column = column;
        if (column != null && column.isIdentityColumn()) {
            this.table = column.getTable();
        }
    }

    public IdentiyColumnDescription(Table table) {
        this.table = table;
    }

    public static void main(String[] args) {
    }

    public String getColumnName() {
        if (this.column != null) {
            return this.column.getName();
        }
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getGenerate() {
        if (this.column != null) {
            if (this.column.isAutoIncrementGenerateAlways()) {
                return "ALWAYS";
            }
            return "BY DEFAULT";
        }
        return this.generate;
    }

    public void setGenerate(String generate) {
        this.generate = generate;
    }

    public String getStartWith() {
        if (this.column != null) {
            return this.column.getAutoIncrementStartWith();
        }
        return this.startWith;
    }

    public void setStartWith(String startWith) {
        this.startWith = startWith;
    }

    public String getIncrementBy() {
        if (this.column != null) {
            return this.column.getAutoIncrementIncrementBy().toString();
        }
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getMaxValue() {
        if (this.column != null) {
            return this.column.getAutoIncrementMaxValue();
        }
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMinValue() {
        if (this.column != null) {
            return this.column.getAutoIncrementMinValue();
        }
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getCycle() {
        if (this.column != null) {
            if (this.column.isAutoIncrementCycle()) {
                return "YES";
            }
            return "NO";
        }
        return this.cycle;
    }

    public void setCycle(String cycle) {
        this.cycle = cycle;
    }

    public String getNoCache() {
        if (this.column != null) {
            if (this.column.isAutoIncrementDisableCache()) {
                return "YES";
            }
            return "NO";
        }
        return this.noCache;
    }

    public void setNoCache(String noCache) {
        this.noCache = noCache;
    }

    public String getCache() {
        if (this.column != null && this.column.getAutoIncrementCache() != null) {
            return this.column.getAutoIncrementCache().toString();
        }
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getOrder() {
        if (this.column != null) {
            if (this.column.isAutoIncrementOrder()) {
                return "YES";
            }
            return "NO";
        }
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void resolveColumn() {
        if (this.columnName != null && !this.columnName.isEmpty() && this.table != null) {
            this.column = (Column)this.table.getElementByName(this.columnName);
        }
        if (this.column != null) {
            this.column.setAutoIncrementColumn(true);
            this.column.setIdentityColumn(true);
            if ("ALWAYS".equals(this.generate)) {
                this.column.setAutoIncrementGenerateAlways(true);
                this.column.setDefaultOnNull(false);
            } else {
                this.column.setAutoIncrementGenerateAlways(false);
                if ("BY DEFAULT ON NULL".equalsIgnoreCase(this.generate)) {
                    this.column.setDefaultOnNull(true);
                }
            }
            this.column.setAutoIncrementMinValue(this.minValue);
            this.column.setAutoIncrementMaxValue(this.maxValue);
            this.column.setAutoIncrementStartWith(this.startWith);
            if ("YES".equalsIgnoreCase(this.noCache)) {
                this.column.setAutoIncrementDisableCache(true);
            } else {
                this.column.setAutoIncrementDisableCache(false);
            }
            Integer incr = 20;
            try {
                incr = Integer.decode(this.cache);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.column.setAutoIncrementCache(incr);
            if ("YES".equalsIgnoreCase(this.cycle)) {
                this.column.setAutoIncrementCycle(true);
            } else {
                this.column.setAutoIncrementCycle(false);
            }
            incr = 1;
            try {
                incr = Integer.decode(this.incrementBy);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.column.setAutoIncrementIncrementBy(incr);
            if ("YES".equalsIgnoreCase(this.order)) {
                this.column.setAutoIncrementOrder(true);
            } else {
                this.column.setAutoIncrementOrder(false);
            }
        }
    }

    public void copy(IdentiyColumnDescription descr) {
        descr.setColumnName(this.getColumnName());
        descr.setCache(this.getCache());
        descr.setCycle(this.getCycle());
        descr.setGenerate(this.getGenerate());
        descr.setIncrementBy(this.getIncrementBy());
        descr.setMaxValue(this.getMaxValue());
        descr.setMinValue(this.getMinValue());
        descr.setNoCache(this.getNoCache());
        descr.setOrder(this.getOrder());
        descr.setStartWith(this.getStartWith());
    }
}

