/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.CollectionTypeSet;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTInheritanceSet;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DTReferenceSet;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.DistinctTypeSet;
import oracle.dbtools.crest.model.design.datatypes.MethodParamSet;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.StructuredTypeSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class DataTypesDesign
extends DesignPart
implements ObjectListener {
    public static final String OBJECT_TYPE_NAME = "Data Types";
    public static final String SDO_GEOMETRY = "SDO_GEOMETRY";
    public static final String XMLTYPE = "XMLTYPE";
    public static final String DISTINCT_TYPE_SET_NAME = "Distinct Types";
    public static final String COLLECTION_TYPE_SET_NAME = "Collection Types";
    public static final String STRUCTURED_TYPE_SET_NAME = "Structured Types";
    public static final String NOTE_SET_NAME = "Notes";
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    public static final String SDO_GEOMETRY_ID = "47E390DE-0671-C4B1-8428-0F45CBEE18F8";
    public static final String XMLTYPE_ID = "F72C39E0-D1CA-8821-2AD7-A1E95A37D3D1";
    private String collectionOfRefsPrefix;
    private String collectionPrefix;
    private int defaultArrayLimit;
    private String defaultCollectionType_Kind;
    private String defaultCollectionType_Suffix;
    private String embeddedStructuredTypePrefix;
    private String referencePrefix;
    private boolean useRoleInAssociationEndAsName;
    private DistinctTypeSet distinctTypes;
    private CollectionTypeSet collectionTypes;
    private StructuredTypeSet structuredTypes;
    private DTReferenceSet dtrSet;
    private MethodParamSet mpSet;
    private DTInheritanceSet dtiSet;
    private TypeElementSet teSet;
    private MethodSet methodSet;
    private DesignObjectCollection predefinedStCollection;
    private DesignObjectCollection stCollection;
    private DesignObjectCollection ctCollection;
    private DesignObjectCollection predefinedCtCollection;
    private String storagePath = null;

    public String getCollectionOfRefsPrefix() {
        return this.collectionOfRefsPrefix;
    }

    public void setCollectionOfRefsPrefix(String collectionOfRefsPrefix) {
        this.collectionOfRefsPrefix = collectionOfRefsPrefix;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    public String getCollectionPrefix() {
        return this.collectionPrefix;
    }

    public void setCollectionPrefix(String collectionPrefix) {
        this.collectionPrefix = collectionPrefix;
    }

    public int getDefaultArrayLimit() {
        return this.defaultArrayLimit;
    }

    public void setDefaultArrayLimit(int defaultArrayLimit) {
        this.defaultArrayLimit = defaultArrayLimit;
    }

    public String getDefaultCollectionType_Kind() {
        return this.defaultCollectionType_Kind;
    }

    public void setDefaultCollectionType_Kind(String defaultCollectionType_Kind) {
        this.defaultCollectionType_Kind = defaultCollectionType_Kind;
    }

    public String getDefaultCollectionType_Suffix() {
        return this.defaultCollectionType_Suffix;
    }

    public void setDefaultCollectionType_Suffix(String defaultCollectionType_Suffix) {
        this.defaultCollectionType_Suffix = defaultCollectionType_Suffix;
    }

    public String getEmbeddedStructuredTypePrefix() {
        return this.embeddedStructuredTypePrefix;
    }

    public void setEmbeddedStructuredTypePrefix(String embeddedStructuredTypePrefix) {
        this.embeddedStructuredTypePrefix = embeddedStructuredTypePrefix;
    }

    public String getReferencePrefix() {
        return this.referencePrefix;
    }

    public void setReferencePrefix(String referencePrefix) {
        this.referencePrefix = referencePrefix;
    }

    public boolean isUseRoleInAssociationEndAsName() {
        return this.useRoleInAssociationEndAsName;
    }

    public void setUseRoleInAssociationEndAsName(boolean useRoleInAssociationEndAsName) {
        this.useRoleInAssociationEndAsName = useRoleInAssociationEndAsName;
    }

    public DistinctTypeSet getDistinctTypeSet() {
        if (this.distinctTypes == null) {
            this.distinctTypes = new DistinctTypeSet(this);
            this.distinctTypes.setDesign(this.getDesign());
        }
        return this.distinctTypes;
    }

    public CollectionTypeSet getCollectionTypeSet() {
        if (this.collectionTypes == null) {
            this.collectionTypes = new CollectionTypeSet(this);
            this.collectionTypes.setDesign(this.getDesign());
        }
        return this.collectionTypes;
    }

    public DistinctType createDistinctType() {
        return this.getDistinctTypeSet().createDistinctType(null);
    }

    public StructuredType createStructuredType() {
        return this.getStructuredTypeSet().createStructuredType(null, true);
    }

    public CollectionType createCollectionType() {
        return this.getCollectionTypeSet().createCollectionType(null);
    }

    public DTInheritance createDTInheritance() {
        return this.getDTInheritanceSet().createInheritance(null);
    }

    public DTReference createDTReference() {
        return this.getDTReferenceSet().createReference(null);
    }

    public StructuredTypeSet getStructuredTypeSet() {
        if (this.structuredTypes == null) {
            this.structuredTypes = new StructuredTypeSet(this);
            this.structuredTypes.setDesign(this.getDesign());
        }
        return this.structuredTypes;
    }

    public DTInheritanceSet getDTInheritanceSet() {
        if (this.dtiSet == null) {
            this.dtiSet = new DTInheritanceSet(this);
            this.dtiSet.setDesign(this.getDesign());
            this.dtiSet.setName("Inheritances");
            this.dtiSet.setParent(this);
            this.dtiSet.addSetListener(this);
        }
        return this.dtiSet;
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public DTReferenceSet getDTReferenceSet() {
        if (this.dtrSet == null) {
            this.dtrSet = new DTReferenceSet(this);
            this.dtrSet.setDesign(this.getDesign());
            this.dtrSet.setName("References");
            this.dtrSet.setParent(this);
            this.dtrSet.addSetListener(this);
        }
        return this.dtrSet;
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getDistinctTypeSet());
        list.add(this.getStructuredTypeSet());
        list.add(this.getCollectionTypeSet());
        return list;
    }

    public MethodParamSet getMethodParamSet() {
        if (this.mpSet == null) {
            this.mpSet = new MethodParamSet(this);
            this.mpSet.setDesign(this.getDesign());
            this.mpSet.setName("Method Parameters");
            this.mpSet.setParent(this);
            this.mpSet.addSetListener(this);
        }
        return this.mpSet;
    }

    public TypeElementSet getTypeElementSet() {
        if (this.teSet == null) {
            this.teSet = new TypeElementSet(this);
            this.teSet.setDesign(this.getDesign());
            this.teSet.setName("TypeElements");
            this.teSet.setParent(this);
            this.teSet.addSetListener(this);
        }
        return this.teSet;
    }

    public MethodSet getMethodSet() {
        if (this.methodSet == null) {
            this.methodSet = new MethodSet(this);
            this.methodSet.setDesign(this.getDesign());
            this.methodSet.setName("Methods");
            this.methodSet.setParent(this);
            this.methodSet.addSetListener(this);
        }
        return this.methodSet;
    }

    public List<StructuredType> getStructuredTypesOrderedByParent() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            this.addST(list, st);
        }
        return list;
    }

    private void addST(List<StructuredType> list, StructuredType st) {
        if (!list.contains(st)) {
            StructuredType parent = st.getParentType();
            if (parent != null) {
                this.addST(list, parent);
                if (!list.contains(st)) {
                    list.add(st);
                }
            } else {
                list.add(st);
            }
        }
    }

    @Override
    public List getSearchableSets() {
        return this.getSearchableSets(false);
    }

    public List getSearchableSets(boolean global) {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(StructuredType.class), StructuredType.class, this, this.getStructuredTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(CollectionType.class), CollectionType.class, this, this.getCollectionTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(DistinctType.class), DistinctType.class, this, this.getDistinctTypeSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(TypeElement.class), TypeElement.class, this, this.getTypeElementSet()));
        if (!global) {
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(Domain.class), Domain.class, this, this.getDesign().getDomainSet()));
        }
        return sets;
    }

    @Override
    public void doBeforeLoad() {
        this.getPredefinedStCollection().removeAll();
        this.getStructuredTypeSet().removeAll();
        this.addStructureType();
    }

    public DesignObjectCollection getStructureTypeCollection() {
        if (this.stCollection == null) {
            this.stCollection = new DesignObjectCollection();
            this.stCollection.setDesign(this.getDesign());
            this.stCollection.setParent(this);
            this.stCollection.setName("StructuredTypes");
            this.stCollection.setElementDescriptor(StructuredType.class);
        }
        return this.stCollection;
    }

    public DesignObjectCollection getPredefinedStCollection() {
        if (this.predefinedStCollection == null) {
            this.predefinedStCollection = new DesignObjectCollection();
            this.predefinedStCollection.setDesign(this.getDesign());
            this.predefinedStCollection.setParent(this);
            this.predefinedStCollection.setName(Messages.getString("DataTypesDesign.PredefinedStructuredTypes"));
            this.predefinedStCollection.setElementDescriptor(StructuredType.class);
            this.addStructureType();
            this.setDirty(false);
        }
        return this.predefinedStCollection;
    }

    private void addStructureType() {
        String id = SDO_GEOMETRY_ID;
        DesignObject type2 = this.getStructuredTypeSet().getObjectByID(id);
        if (type2 == null) {
            type2 = this.getStructuredTypeSet().getByName(SDO_GEOMETRY);
        }
        if (type2 == null) {
            StructuredType type = this.getStructuredTypeSet().createStructuredType(id, false);
            type.setName(SDO_GEOMETRY);
            type.setPredefined(true);
            type.setIsNullInstance(true);
            String oldId = type.getObjectID();
            this.getDesign().updateDesignObjectId(oldId, type.getObjectID());
            this.getStructuredTypeSet().resetCounter();
            type.setDirty(false);
            this.listOfObjectsChanged = false;
        }
        id = XMLTYPE_ID;
        DesignObject xmltype = this.getStructuredTypeSet().getObjectByID(id);
        if (xmltype == null) {
            xmltype = this.getStructuredTypeSet().getByName(XMLTYPE);
        }
        if (xmltype == null) {
            StructuredType type = this.getStructuredTypeSet().createStructuredType(id, false);
            type.setName(XMLTYPE);
            type.setPredefined(true);
            type.setIsNullInstance(true);
            String oldId = type.getObjectID();
            this.getDesign().updateDesignObjectId(oldId, type.getObjectID());
            this.getStructuredTypeSet().resetCounter();
            type.setDirty(false);
            this.listOfObjectsChanged = false;
        }
    }

    @Override
    public synchronized StorableObject createObject(String objectType, String objectID, String name) {
        AbstractDTObject object = null;
        if ("DistinctType".equalsIgnoreCase(objectType)) {
            object = this.getDistinctTypeSet().createDistinctType(objectID);
        } else if ("CollectionType".equalsIgnoreCase(objectType)) {
            object = this.getCollectionTypeSet().createCollectionType(objectID);
        } else if ("StructuredType".equalsIgnoreCase(objectType)) {
            object = this.getStructuredTypeSet().createStructuredType(objectID, false);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("distincttype", "DistinctType");
            this.f2tMap.put("collectiontype", "CollectionType");
            this.f2tMap.put("structuredtype", "StructuredType");
        }
        return this.f2tMap;
    }

    @Override
    public String getStorageName() throws IOException {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                return new File(designPath, "datatypes/" + this.getName() + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStoragePath() throws IOException {
        String designPath;
        if (this.storagePath == null && (designPath = this.getDesign().getStoragePath()) != null && !designPath.isEmpty()) {
            this.storagePath = new File(designPath, "datatypes").getCanonicalPath();
        }
        return this.storagePath;
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getStructuredTypeSet().addAllElementsTo(collection);
        this.getDTInheritanceSet().addAllElementsTo(collection);
        this.getDTReferenceSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public DesignPartView getMainView() {
        return null;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        return null;
    }

    @Override
    public Note createNote() {
        return null;
    }
}

