/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.storage.oracle;

import java.util.List;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.metadata.ClassDescription;

public class IndexComparatorOracle
extends StoragePropertiesComparator {
    public static final String BITMAP_INDEX = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.BitmapIndex");
    public static final String INDEXTYPE = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Indextype");
    public static final String PARTITIONED = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Partitioned");
    public static final String LOGGING = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Logging");
    public static final String COMPRESS = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Compress");
    public static final String PARALLEL = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Parallel");
    public static final String DEGREE = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Degree");
    public static final String SORTED_ROWS = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.SortedRows");
    public static final String COMPUTE_STATS = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.ComputeStats");
    public static final String ONLINE = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Online");
    public static final String INVISIBLE = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.Invisible");
    public static final String INDEXTYPE_PARAMETERS = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.IndextypeParameters");
    public static final String HASH_COMPOSITE_BY_HASH_TABLESPACES = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.HashCompositeByHashTablespaces");
    public static final String CREATE_TABLE_FOR_NONLEAF_NODES = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.CreateTableForNonleafNodes");
    public static final String UPDATES_PER_BATCH = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.UpdatesPerBatch");
    public static final String WORK_TABLESPACE = IndexComparatorOracle.getPropertyNameOracle("IndexPropertyDialogOracle.WorkTablespace");
    private StorageDesign storageDesign;

    public IndexComparatorOracle(IndexProxy sourceIndexProxy, IndexProxy targetIndexProxy) {
        super(sourceIndexProxy, targetIndexProxy);
        if (sourceIndexProxy != null) {
            this.storageDesign = sourceIndexProxy.getStorageDesign();
        } else if (targetIndexProxy != null) {
            this.storageDesign = targetIndexProxy.getStorageDesign();
        }
        this.initPropertiesList();
        this.initPropertiesFilterList();
    }

    @Override
    protected void initPropertiesList() {
        this.initNameProperty();
        if (!DDL_ONLY) {
            this.initCommentProperty();
            this.initCommentInRDBMSProperty();
        }
        this.initProperty(USER_NAME, "user");
        this.initProperty(BITMAP_INDEX, "bitmapIndex");
        this.initProperty(INDEXTYPE, "indexType");
        this.initProperty(PARTITIONED, "indexPartitioned");
        this.initProperty(LOGGING, "logging");
        this.initProperty(COMPRESS, "compress");
        this.initProperty(PARALLEL, "parallel");
        this.initProperty(DEGREE, "degree");
        this.initProperty(SORTED_ROWS, "sortedRows");
        this.initProperty(COMPUTE_STATS, "computeStatistics");
        this.initProperty(ONLINE, "online");
        if (this.storageDesign instanceof StorageDesignOraclev11g) {
            this.initProperty(INVISIBLE, "invisible");
        }
        this.initProperty(INDEXTYPE_PARAMETERS, "indexDomainParameters");
        this.initProperty(HASH_COMPOSITE_BY_HASH_TABLESPACES, "allHashSubPartitionsTableSpaces", "hashSubPartitionsTableSpaces");
        this.initProperty(CREATE_TABLE_FOR_NONLEAF_NODES, "nonLeaf");
        this.initProperty(UPDATES_PER_BATCH, "batchSize");
        this.initProperty(WORK_TABLESPACE, "workTablespace");
    }

    @Override
    public List<ClassDescription.PropertyDescription> getPropsToMerge() {
        List<ClassDescription.PropertyDescription> propsList = super.getPropsToMerge();
        if (this.getChoosedPropertyValue(PARTITIONED).startsWith("GLOBAL") && this.classDescr != null) {
            ClassDescription.PropertyDescription partListPD = this.classDescr.getPropertyDescriptionByName("indexGlobalPartitionsList");
            propsList.add(partListPD);
        }
        return propsList;
    }

    @Override
    protected boolean isExcludedFromComparison(String propertyName) {
        if (TableComparatorOracle.LOGGING.equals(propertyName) || PropertyNames.TABLESPACE.equals(propertyName)) {
            return false;
        }
        return super.isExcludedFromComparison(propertyName);
    }
}

