/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.ElementSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.SchemaObject;

public class NameSpaceController
implements ModelObjectSetListener,
SetListener {
    protected Map<String, Object> names = new TreeMap<String, Object>();
    boolean caseSensitive = false;
    ElementSet set;

    public NameSpaceController(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public NameSpaceController() {
    }

    public void addElementSet(ElementSet set) {
        this.set = set;
        this.initNames(set);
    }

    void initNames(ElementSet set) {
        this.names.clear();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            this.addObject(obj);
        }
        if (set instanceof ModelObjectSet) {
            this.addModelObjectSetListener((ModelObjectSet)set);
        } else if (set instanceof DesignObjectSet) {
            this.addDesignObjectSetListener((DesignObjectSet)set);
        }
    }

    protected void addModelObjectSetListener(ModelObjectSet set) {
    }

    protected void addDesignObjectSetListener(DesignObjectSet set) {
    }

    public synchronized void addObject(Object obj) {
        if (obj instanceof ModelObject) {
            String name = ((ModelIDObject)obj).getLongName();
            if (!this.caseSensitive) {
                this.names.put(name.toUpperCase(), obj);
            } else {
                this.names.put(name, obj);
            }
        } else {
            this.names.put(obj.toString(), obj);
        }
    }

    public String getValidName(ModelIDObject obj, String schema, String name) {
        return this.getValidName(obj, schema, name, this.names);
    }

    protected String getValidName(ModelIDObject obj, String schema, String name, Map names) {
        ModelIDObject ex_obj;
        Object prefix = "";
        if (schema != null && !"".equals(schema)) {
            prefix = schema + ".";
        }
        Object newName = (String)prefix + name;
        if (!this.caseSensitive) {
            newName = ((String)newName).toUpperCase();
        }
        if ((ex_obj = (ModelIDObject)names.get(newName)) == null || ex_obj == obj || ex_obj.getObjectID().equals(obj.getObjectID())) {
            return name;
        }
        newName = this.createNameVariant(schema, name, obj);
        return newName;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    public String createNameVariant(String name) {
        return this.createNameVariant(name, this.names);
    }

    public String createNameVariant(String name, Map names) {
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append(this.getVariantSeparator());
        int length = buffer.length();
        for (int i = 1; i <= names.size(); ++i) {
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            if (!(!this.caseSensitive ? !names.containsKey(newName.toUpperCase()) : !names.containsKey(newName))) continue;
            return newName;
        }
        return newName;
    }

    protected String getSeparator() {
        return "_";
    }

    protected String getVariantSeparator() {
        return "v";
    }

    public String createNameVariant(String schema, String name, ModelIDObject object) {
        return this.createNameVariant(schema, name, this.names, object);
    }

    protected String createNameVariant(String schema, String name, Map names, ModelIDObject object) {
        if (schema == null || "".equals(schema)) {
            return this.createNameVariant(name, names);
        }
        StringBuffer buffer = new StringBuffer(name);
        String newName = name;
        buffer.append(this.getVariantSeparator());
        int length = buffer.length();
        for (int i = 1; i <= names.size(); ++i) {
            ModelIDObject obj;
            buffer.setLength(length);
            buffer.append(i);
            newName = buffer.toString();
            Object longName = schema + "." + newName;
            if (!this.caseSensitive) {
                longName = ((String)longName).toUpperCase();
            }
            if ((obj = (ModelIDObject)names.get(longName)) != null && obj != object && !obj.getObjectID().equals(object.getObjectID())) continue;
            return newName;
        }
        throw new IllegalStateException("NoNameVariantFound");
    }

    public void objectStatusChanged(Map oldStatus, ModelIDObject object) {
    }

    public void removeObject(Object obj) {
        this.removeObject(obj, this.names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeObject(Object obj, Map<String, Object> names) {
        Object rem = null;
        if (obj instanceof ModelObject) {
            String name = ((ModelIDObject)obj).getLongName();
            rem = !this.caseSensitive ? names.remove(name.toUpperCase()) : names.remove(name);
        } else {
            rem = names.remove(obj.toString());
        }
        if (rem == null) {
            Map.Entry<String, Object> fent = null;
            Iterator<Map.Entry<String, Object>> it = names.entrySet().iterator();
            NameSpaceController nameSpaceController = this;
            synchronized (nameSpaceController) {
                while (it.hasNext()) {
                    Map.Entry<String, Object> ent = it.next();
                    if (ent.getValue() != obj) continue;
                    fent = ent;
                    break;
                }
                if (fent != null) {
                    names.remove(fent.getKey());
                }
            }
        }
    }

    public void updateNamesMap(String schema, String oldName, String newName, ModelIDObject object) {
        this.updateNamesMap(schema, oldName, newName, object, this.names);
    }

    protected synchronized void updateNamesMap(String schema, String oldName, String newName, ModelIDObject object, Map names) {
        Object oname;
        ModelIDObject nonBackUp = null;
        if (object instanceof DesignObject && !((DesignObject)object).isBackup()) {
            nonBackUp = object;
        }
        if (oldName != null) {
            ModelIDObject dobj;
            oname = oldName;
            if (schema != null && !"".equals(schema)) {
                oname = schema + "." + (String)oname;
            }
            if (!this.caseSensitive) {
                oname = ((String)oname).toUpperCase();
            }
            if ((dobj = (ModelIDObject)names.get(oname)) != null && (dobj == object || dobj.getObjectID().equals(object.getObjectID()))) {
                names.remove(oname);
                if (nonBackUp == null && dobj instanceof DesignObject) {
                    nonBackUp = dobj;
                }
            }
        }
        oname = newName;
        if (schema != null && !"".equals(schema)) {
            oname = schema + "." + (String)oname;
        }
        if (nonBackUp == null) {
            nonBackUp = object;
        }
        if (!this.caseSensitive) {
            names.put(((String)oname).toUpperCase(), nonBackUp);
        } else {
            names.put(oname, nonBackUp);
        }
    }

    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        return this.updateNamesMap(oldSchema, oldName, newSchema, newName, object, this.names);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object, Map<String, Object> names) {
        String newLongName;
        String oldLongName = oldSchema != null ? (oldSchema.getName() + "." + oldName).toUpperCase() : oldName.toUpperCase();
        if (oldLongName.equals(newLongName = newSchema != null ? (newSchema.getName() + "." + newName).toUpperCase() : newName.toUpperCase())) {
            return true;
        }
        Object obj1 = names.get(oldLongName);
        if (obj1 != null) {
            if (obj1 != object) return false;
            names.remove(oldLongName);
            Object obj2 = names.get(newLongName);
            if (obj2 != null && obj2 != object) {
                return false;
            }
            if (obj2 != null) return true;
            names.put(newLongName, object);
            return true;
        } else {
            Object obj2 = names.get(newLongName);
            if (obj2 != null && obj2 != object) {
                return false;
            }
            if (obj2 != null) return true;
            names.put(newLongName, object);
        }
        return true;
    }

    public void clear() {
        this.names.clear();
    }

    public boolean updateNamesMapStr(String oldSchema, String oldName, String newSchema, String newName, DesignObject object) {
        return this.updateNamesMapStr(oldSchema, oldName, newSchema, newName, object, this.names);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean updateNamesMapStr(String oldSchema, String oldName, String newSchema, String newName, DesignObject object, Map names) {
        Object oldLongName = oldSchema != null && !"".equals(oldSchema) ? oldSchema + "." + oldName : oldName;
        if (!this.caseSensitive) {
            oldLongName = ((String)oldLongName).toUpperCase();
        }
        String newLongName = newSchema != null && !"".equals(newSchema) ? (newSchema + "." + newName).toUpperCase() : newName.toUpperCase();
        if (!this.caseSensitive) {
            newLongName = newLongName.toUpperCase();
        }
        if (((String)oldLongName).equals(newLongName)) {
            return true;
        }
        Object obj1 = names.get(oldLongName);
        if (obj1 != null) {
            if (obj1 != object) return false;
            names.remove(oldLongName);
            Object obj2 = names.get(newLongName);
            if (obj2 != null && obj2 != object) {
                return false;
            }
            if (obj2 != null) return true;
            names.put(newLongName, object);
            return true;
        } else {
            Object obj2 = names.get(newLongName);
            if (obj2 != null && obj2 != object) {
                return false;
            }
            if (obj2 != null) return true;
            names.put(newLongName, object);
        }
        return true;
    }
}

