/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.scheduling;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.scheduling.SQLStatementBuilderScheduler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;

public class SSBSchedulerWindow
extends SQLStatementBuilderScheduler {
    @Override
    public Map<String, String> getExcludeMap() {
        if (this.excludeMap == null) {
            this.excludeMap = new TreeMap();
        }
        this.excludeMap.put("OWNER", "OWNER");
        this.excludeMap.put("WINDOW_NAME", "WINDOW_NAME");
        this.excludeMap.put("SCHEDULE_OWNER", "WINDOW_NAME");
        this.excludeMap.put("SCHEDULE_NAME", "SCHEDULE_NAME");
        this.excludeMap.put("DURATION", "DURATION");
        this.excludeMap.put("REPEAT_INTERVAL", "REPEAT_INTERVAL");
        this.excludeMap.put("RESOURCE_PLAN", "RESOURCE_PLAN");
        this.excludeMap.put("SCHEDULE_TYPE", "SCHEDULE_TYPE");
        this.excludeMap.put("START_DATE", "START_DATE");
        this.excludeMap.put("END_DATE", "END_DATE");
        this.excludeMap.put("ENABLED", "ENABLED");
        return this.excludeMap;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof SchedulerWindow) {
            SchedulerWindow sched = (SchedulerWindow)object;
            if (sched.isMinimumDefined()) {
                Map<String, String> excludeMap = this.getExcludeMap();
                StringBuffer buffer = new StringBuffer();
                SSBSchedulerWindow.appendStringWithSpace(buffer, "BEGIN");
                SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerWindow.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.CREATE_WINDOW(");
                SSBSchedulerWindow.appendObjectName(buffer, sched, prettyPrint);
                SSBSchedulerWindow.appendParams(buffer, sched, prettyPrint);
                SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 1);
                SSBSchedulerWindow.appendStringWithSpace(buffer, ");");
                this.appendAtrtributes(buffer, sched, prettyPrint, excludeMap);
                SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerWindow.appendEnable(buffer, sched, prettyPrint);
                SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 0);
                SSBSchedulerWindow.appendString(buffer, "END");
                SSBSchedulerWindow.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, "");
            } else {
                SSBSchedulerWindow.appendStringWithSpace(oldbuffer, "invalid Window definitiion for " + String.valueOf(sched.getName() + "\n file window name, duration, schedule name or repeat interval should be defined"));
            }
        }
    }

    public static void appendSchedule(StringBuffer buffer, SchedulerWindow job, boolean prettyPrint) {
        String res = job.getFormatedScheduleName();
        if (res != null && !res.isEmpty()) {
            SSBSchedulerWindow.appendString(buffer, ',');
            SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerWindow.appendString(buffer, "schedule_name => '" + res + "'");
        }
    }

    public static void appendParams(StringBuffer buffer, SchedulerWindow obj, boolean prettyPrint) {
        String sched = obj.getProperty("SCHEDULE_NAME");
        SSBSchedulerWindow.appendArgument(buffer, obj, "RESOURCE_PLAN", prettyPrint);
        SSBSchedulerWindow.appendArgument(buffer, obj, "DURATION", prettyPrint);
        if (sched != null && !sched.isEmpty()) {
            SSBSchedulerWindow.appendSchedule(buffer, obj, prettyPrint);
        } else {
            SSBSchedulerWindow.appendRepeatInterval(buffer, obj, prettyPrint);
            SSBSchedulerWindow.appendArgument(buffer, obj, "START_DATE", prettyPrint);
            SSBSchedulerWindow.appendArgument(buffer, obj, "END_DATE", prettyPrint);
        }
    }

    public static void appendRepeatInterval(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        String type = obj.getProperty("REPEAT_INTERVAL");
        if (type != null && !type.isEmpty()) {
            SSBSchedulerWindow.appendString(buffer, ',');
            SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 2);
            SSBSchedulerWindow.appendString(buffer, "repeat_interval => '" + type + "'");
        }
    }

    public static void appendObjectName(StringBuffer buffer, SchedulerObject obj, boolean prettyPrint) {
        SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 2);
        SSBSchedulerWindow.appendString(buffer, "window_name => '" + obj.getNameFormatted() + "'");
    }

    public static void appendEnable(StringBuffer buffer, SchedulerObject job, boolean prettyPrint) {
        String res = job.getProperty("ENABLED");
        if (res != null && !res.isEmpty() && "TRUE".equalsIgnoreCase(res)) {
            String name = job.getNameFormatted();
            SSBSchedulerWindow.appendNewLine(buffer, prettyPrint, 1);
            SSBSchedulerWindow.appendStringWithSpace(buffer, "SYS.DBMS_SCHEDULER.enable(name => '" + name + "');");
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof SchedulerWindow;
    }
}

