/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeletePrivateEndpointRequest
extends BmcRequest<Void> {
    private String namespaceName;
    private String peName;
    private String ifMatch;
    private String opcClientRequestId;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getPeName() {
        return this.peName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcClientRequestId() {
        return this.opcClientRequestId;
    }

    public Builder toBuilder() {
        return new Builder().namespaceName(this.namespaceName).peName(this.peName).ifMatch(this.ifMatch).opcClientRequestId(this.opcClientRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",namespaceName=").append(String.valueOf(this.namespaceName));
        sb.append(",peName=").append(String.valueOf(this.peName));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcClientRequestId=").append(String.valueOf(this.opcClientRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeletePrivateEndpointRequest)) {
            return false;
        }
        DeletePrivateEndpointRequest other = (DeletePrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.namespaceName, other.namespaceName) && Objects.equals(this.peName, other.peName) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcClientRequestId, other.opcClientRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.namespaceName == null ? 43 : this.namespaceName.hashCode());
        result = result * 59 + (this.peName == null ? 43 : this.peName.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcClientRequestId == null ? 43 : this.opcClientRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeletePrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String namespaceName = null;
        private String peName = null;
        private String ifMatch = null;
        private String opcClientRequestId = null;

        public Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder peName(String peName) {
            this.peName = peName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcClientRequestId(String opcClientRequestId) {
            this.opcClientRequestId = opcClientRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeletePrivateEndpointRequest o) {
            this.namespaceName(o.getNamespaceName());
            this.peName(o.getPeName());
            this.ifMatch(o.getIfMatch());
            this.opcClientRequestId(o.getOpcClientRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeletePrivateEndpointRequest build() {
            DeletePrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeletePrivateEndpointRequest buildWithoutInvocationCallback() {
            DeletePrivateEndpointRequest request = new DeletePrivateEndpointRequest();
            request.namespaceName = this.namespaceName;
            request.peName = this.peName;
            request.ifMatch = this.ifMatch;
            request.opcClientRequestId = this.opcClientRequestId;
            return request;
        }
    }
}

