/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PrefixFqdns
extends ExplicitlySetBmcModel {
    @JsonProperty(value="objectStorageApiFqdn")
    private final String objectStorageApiFqdn;
    @JsonProperty(value="s3CompatibilityApiFqdn")
    private final String s3CompatibilityApiFqdn;
    @JsonProperty(value="swiftApiFqdn")
    private final String swiftApiFqdn;

    @Deprecated
    @ConstructorProperties(value={"objectStorageApiFqdn", "s3CompatibilityApiFqdn", "swiftApiFqdn"})
    public PrefixFqdns(String objectStorageApiFqdn, String s3CompatibilityApiFqdn, String swiftApiFqdn) {
        this.objectStorageApiFqdn = objectStorageApiFqdn;
        this.s3CompatibilityApiFqdn = s3CompatibilityApiFqdn;
        this.swiftApiFqdn = swiftApiFqdn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getObjectStorageApiFqdn() {
        return this.objectStorageApiFqdn;
    }

    public String getS3CompatibilityApiFqdn() {
        return this.s3CompatibilityApiFqdn;
    }

    public String getSwiftApiFqdn() {
        return this.swiftApiFqdn;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PrefixFqdns(");
        sb.append("super=").append(super.toString());
        sb.append("objectStorageApiFqdn=").append(String.valueOf(this.objectStorageApiFqdn));
        sb.append(", s3CompatibilityApiFqdn=").append(String.valueOf(this.s3CompatibilityApiFqdn));
        sb.append(", swiftApiFqdn=").append(String.valueOf(this.swiftApiFqdn));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrefixFqdns)) {
            return false;
        }
        PrefixFqdns other = (PrefixFqdns)((Object)o);
        return Objects.equals(this.objectStorageApiFqdn, other.objectStorageApiFqdn) && Objects.equals(this.s3CompatibilityApiFqdn, other.s3CompatibilityApiFqdn) && Objects.equals(this.swiftApiFqdn, other.swiftApiFqdn) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.objectStorageApiFqdn == null ? 43 : this.objectStorageApiFqdn.hashCode());
        result = result * 59 + (this.s3CompatibilityApiFqdn == null ? 43 : this.s3CompatibilityApiFqdn.hashCode());
        result = result * 59 + (this.swiftApiFqdn == null ? 43 : this.swiftApiFqdn.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="objectStorageApiFqdn")
        private String objectStorageApiFqdn;
        @JsonProperty(value="s3CompatibilityApiFqdn")
        private String s3CompatibilityApiFqdn;
        @JsonProperty(value="swiftApiFqdn")
        private String swiftApiFqdn;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder objectStorageApiFqdn(String objectStorageApiFqdn) {
            this.objectStorageApiFqdn = objectStorageApiFqdn;
            this.__explicitlySet__.add("objectStorageApiFqdn");
            return this;
        }

        public Builder s3CompatibilityApiFqdn(String s3CompatibilityApiFqdn) {
            this.s3CompatibilityApiFqdn = s3CompatibilityApiFqdn;
            this.__explicitlySet__.add("s3CompatibilityApiFqdn");
            return this;
        }

        public Builder swiftApiFqdn(String swiftApiFqdn) {
            this.swiftApiFqdn = swiftApiFqdn;
            this.__explicitlySet__.add("swiftApiFqdn");
            return this;
        }

        public PrefixFqdns build() {
            PrefixFqdns model = new PrefixFqdns(this.objectStorageApiFqdn, this.s3CompatibilityApiFqdn, this.swiftApiFqdn);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PrefixFqdns model) {
            if (model.wasPropertyExplicitlySet("objectStorageApiFqdn")) {
                this.objectStorageApiFqdn(model.getObjectStorageApiFqdn());
            }
            if (model.wasPropertyExplicitlySet("s3CompatibilityApiFqdn")) {
                this.s3CompatibilityApiFqdn(model.getS3CompatibilityApiFqdn());
            }
            if (model.wasPropertyExplicitlySet("swiftApiFqdn")) {
                this.swiftApiFqdn(model.getSwiftApiFqdn());
            }
            return this;
        }
    }
}

