/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.http;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.dbtools.http.HttpResources;

public class CloudStorageUrl {
    private static final String CS_PREFIX = "https://";
    private static final String SWIFT = "swift";
    private static final String OCI = "objectstorage";
    private static final String VTAG = "v1";
    private static final String VSTAG = "/v1/";
    private static final String NSTAG = "/n/";
    private static final String BSTAG = "/b/";
    private static final String OSTAG = "/o/";
    private static final String SLASH = "/";
    private static final String NL = "\n";
    URL _baseUrl;
    String _qualifier;
    ParsedUrl _baseParsedUrl;
    ParsedUrl _qualifiedParsedUrl;
    ParsedUrl _finalParsedUrl;

    public CloudStorageUrl(String baseUrl) throws MalformedURLException {
        this(new URL(baseUrl));
    }

    public CloudStorageUrl(URL baseUrl) throws MalformedURLException {
        this._baseUrl = baseUrl;
        this._finalParsedUrl = this._baseParsedUrl = new BaseParsedUrl(baseUrl);
    }

    public void qualifiedUrl(String qualifier) throws MalformedURLException {
        this._qualifier = qualifier;
        this._finalParsedUrl = this._qualifiedParsedUrl = new QualifiedParsedUrl(this._baseParsedUrl, qualifier);
    }

    public void dropQualifiedUrl() {
        this._qualifier = null;
        this._finalParsedUrl = this._baseParsedUrl;
    }

    public URL getFinalUrl() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            return this._finalParsedUrl.getURL();
        }
        String url = CS_PREFIX + this._finalParsedUrl.getHost();
        if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
            url = url + (this.isSwiftUrl() ? VSTAG + this._finalParsedUrl.getNameSpace() : NSTAG + this._finalParsedUrl.getNameSpace());
            if (!this._finalParsedUrl.getBucket().isEmpty()) {
                url = url + (this.isSwiftUrl() ? SLASH + this._finalParsedUrl.getBucket() : BSTAG + this._finalParsedUrl.getBucket());
                url = !this._finalParsedUrl.getObject().isEmpty() ? url + (this.isSwiftUrl() ? SLASH + this._finalParsedUrl.getObject() : OSTAG + this._finalParsedUrl.getObject()) : url + (this.isSwiftUrl() ? "" : (this._finalParsedUrl.hasOSTAG() ? OSTAG : ""));
            } else {
                url = url + (this.isSwiftUrl() ? "" : (this._finalParsedUrl.hasBSTAG() ? BSTAG : ""));
            }
        } else {
            url = url + (this.isSwiftUrl() ? "" : (this._finalParsedUrl.hasNSTAG() ? NSTAG : ""));
        }
        return new URL(url);
    }

    public URL getFinalUrlAsOCI() throws MalformedURLException {
        Object url = CS_PREFIX + this._finalParsedUrl.getHost();
        if (!this.isSwiftUrl()) {
            return this.getFinalUrl();
        }
        url = ((String)url).replace(SWIFT, "");
        if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
            url = (String)url + NSTAG + this._finalParsedUrl.getNameSpace();
            if (!this._finalParsedUrl.getBucket().isEmpty()) {
                url = (String)url + BSTAG + this._finalParsedUrl.getBucket();
                if (!this._finalParsedUrl.getObject().isEmpty()) {
                    url = (String)url + OSTAG + this._finalParsedUrl.getObject();
                }
            }
        }
        return new URL((String)url);
    }

    public URL getFinalUrlAsSwift() throws MalformedURLException {
        if (this.isSwiftUrl()) {
            return this.getFinalUrl();
        }
        String url = CS_PREFIX + this.getHostAsSwift();
        if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
            url = url + VSTAG + this._finalParsedUrl.getNameSpace();
            if (!this._finalParsedUrl.getBucket().isEmpty()) {
                url = url + SLASH + this._finalParsedUrl.getBucket();
                if (!this._finalParsedUrl.getObject().isEmpty()) {
                    url = url + SLASH + this._finalParsedUrl.getObject();
                }
            }
        }
        return new URL(url);
    }

    public boolean isSwiftUrl() {
        return this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.SWIFT;
    }

    public boolean isOciUrl() {
        return this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.OCI;
    }

    public boolean isUnknownUrl() {
        return this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN;
    }

    public URL getNamespaceUrl() throws MalformedURLException {
        Object url = "";
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            url = this._finalParsedUrl.getURL().toString();
            int bstagOffset = ((String)url).indexOf(BSTAG);
            if (bstagOffset != -1) {
                url = ((String)url).substring(0, bstagOffset);
            }
        } else {
            url = CS_PREFIX + this._finalParsedUrl.getHost();
            if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
                url = (String)url + (this.isSwiftUrl() ? VSTAG + this._finalParsedUrl.getNameSpace() : NSTAG + this._finalParsedUrl.getNameSpace());
            }
        }
        new CloudStorageUrl((String)url).validateUrlAsNamespace();
        return new URL((String)url);
    }

    public URL getNamespaceUrlAsOCI() throws MalformedURLException {
        String url = CS_PREFIX + this.getHostAsOCI();
        if (!this.isSwiftUrl()) {
            return this.getNamespaceUrl();
        }
        if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
            url = url + NSTAG + this._finalParsedUrl.getNameSpace() + BSTAG;
        }
        new CloudStorageUrl(url).validateUrlAsNamespace();
        return new URL(url);
    }

    public String getHostAsOCI() throws MalformedURLException {
        this.validateHost();
        return this.isSwiftUrl() ? this._finalParsedUrl.getHost().replace(SWIFT, "") : this._finalParsedUrl.getHost();
    }

    public String getHostAsSwift() throws MalformedURLException {
        this.validateHost();
        return this.isSwiftUrl() ? this._finalParsedUrl.getHost() : SWIFT + this._finalParsedUrl.getHost();
    }

    public String getHostAsID() throws MalformedURLException {
        this.validateHost();
        return this.isSwiftUrl() ? this._finalParsedUrl.getHost().replace("swiftobjectstorage", "identity") : this._finalParsedUrl.getHost().replace(OCI, "identity");
    }

    public String getNameSpace() {
        return this._finalParsedUrl.getNameSpace();
    }

    public String getBucket() {
        return this._finalParsedUrl.getBucket();
    }

    public String getObject() {
        return this._finalParsedUrl.getObject();
    }

    public String getQualifierForFileName(String fileName) {
        return !this.isSwiftUrl() ? OSTAG + fileName : fileName;
    }

    public void validateUrlAsObject() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            this.validateUnknownUrl();
        } else {
            this.validateObject();
            this.validateBucket();
            this.validateNameSpace();
            this.validateHost();
        }
    }

    public void validateUrlAsBucket() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            this.validateUnknownUrl();
        } else {
            this.validateNoObject();
            this.validateBucket();
            this.validateNameSpace();
            this.validateHost();
        }
    }

    public void validateUrlAsNameSpace() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            this.validateUnknownUrl();
        } else {
            this.validateNoObject();
            this.validateNoBucket();
            this.validateNameSpace();
            this.validateHost();
        }
    }

    public void validateUrlAsHost() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            this.validateUnknownUrl();
        } else {
            this.validateNoObject();
            this.validateNoBucket();
            this.validateNoNameSpace();
            this.validateHost();
        }
    }

    private void validateUnknownUrl() throws MalformedURLException {
        if (this._finalParsedUrl.getURL() == null) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_MISSING"));
        }
    }

    private void validateObject() throws MalformedURLException {
        if (this._finalParsedUrl.getObject().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_INCOMPLETE"));
        }
    }

    private void validateBucket() throws MalformedURLException {
        if (this._finalParsedUrl.getBucket().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_INCOMPLETE"));
        }
    }

    private void validateNameSpace() throws MalformedURLException {
        if (this._finalParsedUrl.getNameSpace().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_INCOMPLETE"));
        }
    }

    private void validateHost() throws MalformedURLException {
        if (this._finalParsedUrl.getHost().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_HOST_MISSING"));
        }
    }

    private void validateNoObject() throws MalformedURLException {
        if (!this._finalParsedUrl.getObject().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_OBJECT_ERROR"));
        }
    }

    private void validateNoBucket() throws MalformedURLException {
        if (!this._finalParsedUrl.getBucket().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_BUCKET_ERROR"));
        }
    }

    private void validateNoNameSpace() throws MalformedURLException {
        if (!this._finalParsedUrl.getNameSpace().isEmpty()) {
            throw new MalformedURLException(HttpResources.getString("CS_URL_NAMESPACE_ERROR"));
        }
    }

    public void validateUrlAsNamespace() throws MalformedURLException {
        if (this._finalParsedUrl.getUrlType() == ParsedUrl.UrlType.UNKNOWN) {
            this.validateUnknownUrl();
        } else {
            if (this._baseParsedUrl.getHost().isEmpty()) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_HOST_MISSING"));
            }
            if (this._baseParsedUrl.getNameSpace().isEmpty()) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_NAMESPACE_MISSING"));
            }
            if (!this._baseParsedUrl.getBucket().isEmpty()) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_BUCKET_ON_NS"));
            }
            if (!this._baseParsedUrl.getObject().isEmpty()) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_OBJECT_ON_NS"));
            }
        }
    }

    private static final class BaseParsedUrl
    implements ParsedUrl {
        ParsedUrl.UrlType _urlType;
        String _host = "";
        String _target = "";
        String _namespace = "";
        String _bucket = "";
        String _object = "";
        boolean _hasNSTAG;
        boolean _hasBSTAG;
        boolean _hasOSTAG;
        private URL _url = null;

        BaseParsedUrl(URL url) throws MalformedURLException {
            this._url = url;
            this._host = this._url.getHost();
            if (this._host == null || this._host.isEmpty()) {
                throw new MalformedURLException("Missing host");
            }
            String path = this._url.getPath();
            if (this._host.startsWith(CloudStorageUrl.SWIFT)) {
                this._urlType = ParsedUrl.UrlType.SWIFT;
                String[] parts = path.split(CloudStorageUrl.SLASH);
                if (!(parts.length <= 1 || parts[0].isEmpty() && parts[1].equals(CloudStorageUrl.VTAG))) {
                    throw new MalformedURLException(HttpResources.getString("CS_URL_V1"));
                }
                if (parts.length > 4) {
                    this._object = parts[4];
                }
                if (parts.length > 3) {
                    this._bucket = parts[3];
                }
                if (parts.length > 2) {
                    this._namespace = parts[2];
                }
                if (parts.length > 5) {
                    throw new MalformedURLException(HttpResources.getString("CS_URL_UNEXPECTED") + " " + this._namespace + CloudStorageUrl.SLASH + this._bucket + CloudStorageUrl.SLASH + this._object + CloudStorageUrl.SLASH);
                }
            } else if (!path.isEmpty()) {
                if (!path.startsWith(CloudStorageUrl.NSTAG)) {
                    this._urlType = ParsedUrl.UrlType.UNKNOWN;
                } else {
                    this._urlType = ParsedUrl.UrlType.OCI;
                    String pathSub = path.substring(3);
                    if (pathSub.length() > 0) {
                        int tag = 3;
                        int idx = pathSub.indexOf(CloudStorageUrl.BSTAG);
                        if (idx == -1) {
                            idx = pathSub.length();
                            tag = 0;
                        } else {
                            this._hasBSTAG = true;
                        }
                        this._hasNSTAG = true;
                        this._namespace = pathSub.substring(0, idx);
                        pathSub = pathSub.substring(idx + tag);
                        if (pathSub.length() > 0) {
                            idx = pathSub.indexOf(CloudStorageUrl.OSTAG);
                            if (idx == -1) {
                                idx = pathSub.length();
                                tag = 0;
                            } else {
                                this._hasOSTAG = true;
                            }
                            this._bucket = pathSub.substring(0, idx);
                            pathSub = pathSub.substring(idx + tag);
                            if (pathSub.length() > 0) {
                                this._object = pathSub.substring(0);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public String getNameSpace() {
            return this._namespace;
        }

        @Override
        public String getBucket() {
            return this._bucket;
        }

        @Override
        public String getObject() {
            return this._object;
        }

        @Override
        public ParsedUrl.UrlType getUrlType() {
            return this._urlType;
        }

        @Override
        public URL getURL() {
            return this._url;
        }

        @Override
        public boolean hasNSTAG() {
            return this._hasNSTAG;
        }

        @Override
        public boolean hasBSTAG() {
            return this._hasBSTAG;
        }

        @Override
        public boolean hasOSTAG() {
            return this._hasOSTAG;
        }
    }

    public static interface ParsedUrl {
        public String getHost();

        public String getNameSpace();

        public String getBucket();

        public String getObject();

        public UrlType getUrlType();

        public URL getURL();

        public boolean hasNSTAG();

        public boolean hasBSTAG();

        public boolean hasOSTAG();

        public static enum UrlType {
            OCI,
            SWIFT,
            UNKNOWN;

        }
    }

    private static final class QualifiedParsedUrl
    implements ParsedUrl {
        String _host = "";
        String _namespace = "";
        String _bucket = "";
        String _object = "";
        ParsedUrl.UrlType _urlType;
        URL _url;
        boolean _hasNSTAG;
        boolean _hasBSTAG;
        boolean _hasOSTAG;
        ParsedUrl _baseParsedUrl;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        QualifiedParsedUrl(ParsedUrl baseParsedUrl, String qualifier) throws MalformedURLException {
            this._baseParsedUrl = baseParsedUrl;
            this._urlType = this._baseParsedUrl.getUrlType();
            String pathSub = qualifier;
            if (pathSub == null || pathSub.isEmpty()) return;
            if (this._urlType == ParsedUrl.UrlType.UNKNOWN) {
                this._host = this._baseParsedUrl.getHost();
                this._url = new URL(this._baseParsedUrl.getURL().toString() + pathSub);
                return;
            }
            String[] parts = qualifier.split(CloudStorageUrl.SLASH);
            if (this._urlType == ParsedUrl.UrlType.SWIFT) {
                if (parts.length > 0) {
                    int i = 0;
                    if (parts[0].equals(CloudStorageUrl.VTAG) || parts[0].isEmpty()) {
                        ++i;
                        if (parts.length > 1 && parts[1].equals(CloudStorageUrl.VTAG)) {
                            ++i;
                        }
                    }
                    if (parts.length > i + 2) {
                        this._namespace = parts[i];
                        ++i;
                    }
                    if (parts.length > i + 1) {
                        if (this._baseParsedUrl.getNameSpace().isEmpty() && this._namespace.isEmpty() || this._baseParsedUrl.getNameSpace().equals(parts[i])) {
                            this._namespace = parts[i];
                        } else {
                            this._bucket = parts[i];
                        }
                        ++i;
                    }
                    if (parts.length > i) {
                        if (this._baseParsedUrl.getNameSpace().isEmpty() && this._namespace.isEmpty() || this._baseParsedUrl.getNameSpace().equals(parts[i])) {
                            this._namespace = parts[i];
                        } else if (this._baseParsedUrl.getBucket().isEmpty() && this._bucket.isEmpty() || this._baseParsedUrl.getBucket().equals(parts[i])) {
                            if (!this._bucket.isEmpty()) throw new MalformedURLException(HttpResources.getString("CS_URL_NAMESPACE_CONFLICT"));
                            this._bucket = parts[i];
                        } else {
                            this._object = parts[i];
                        }
                        ++i;
                    }
                }
            } else {
                int tag = 3;
                int idx = -1;
                if (!(pathSub.startsWith(CloudStorageUrl.NSTAG) || pathSub.startsWith(CloudStorageUrl.BSTAG) || pathSub.startsWith(CloudStorageUrl.OSTAG))) {
                    throw new MalformedURLException(HttpResources.getString("CS_URL_INVALID_QUALIFIER"));
                }
                if (pathSub.startsWith(CloudStorageUrl.NSTAG)) {
                    this._hasNSTAG = true;
                    pathSub = pathSub.substring(3);
                }
                if (pathSub.length() > 0) {
                    idx = pathSub.indexOf(CloudStorageUrl.BSTAG);
                    if (idx == -1) {
                        idx = pathSub.length();
                        tag = 0;
                    } else {
                        tag = 3;
                        this._hasBSTAG = true;
                    }
                    if (this._hasNSTAG) {
                        this._namespace = pathSub.substring(0, idx);
                        pathSub = pathSub.substring(idx);
                        idx = 0;
                    }
                    if (this._hasBSTAG) {
                        if (this._namespace.isEmpty() && idx != 0) {
                            this._namespace = pathSub.substring(0, idx);
                        }
                        pathSub = pathSub.substring(idx + tag);
                    }
                }
                if (pathSub.length() > 0) {
                    idx = pathSub.indexOf(CloudStorageUrl.OSTAG);
                    if (idx == -1) {
                        idx = pathSub.length();
                        tag = 0;
                    } else {
                        tag = 3;
                        this._hasOSTAG = true;
                    }
                    if (this._hasBSTAG) {
                        this._bucket = pathSub.substring(0, idx);
                        if (!this._hasOSTAG) {
                            pathSub = pathSub.substring(idx);
                        }
                    }
                    if (this._hasOSTAG) {
                        if (this._bucket.isEmpty() && idx != 0) {
                            this._bucket = pathSub.substring(0, idx);
                        }
                        pathSub = pathSub.substring(idx + tag);
                    }
                    if (pathSub.length() > 0) {
                        if (!(this._hasNSTAG || this._hasBSTAG || this._hasOSTAG)) {
                            if (this._baseParsedUrl.getNameSpace().isEmpty() && this._namespace.isEmpty()) {
                                this._namespace = pathSub;
                            } else if (this._baseParsedUrl.getBucket().isEmpty() && this._bucket.isEmpty()) {
                                this._bucket = pathSub;
                            } else {
                                this._object = pathSub;
                            }
                        } else {
                            this._object = pathSub;
                        }
                    }
                }
            }
            this.validateFinal();
        }

        private void validateFinal() throws MalformedURLException {
            if (!(this._baseParsedUrl.getHost().isEmpty() || this._host.isEmpty() || this._baseParsedUrl.getHost().equals(this._host))) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_HOST_CONFLICT"));
            }
            if (!(this._baseParsedUrl.getNameSpace().isEmpty() || this._namespace.isEmpty() || this._baseParsedUrl.getNameSpace().equals(this._namespace))) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_NAMESPACE_CONFLICT"));
            }
            if (!(this._baseParsedUrl.getBucket().isEmpty() || this._bucket.isEmpty() || this._baseParsedUrl.getBucket().equals(this._bucket))) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_BUCKET_CONFLICT"));
            }
            if (!(this._baseParsedUrl.getObject().isEmpty() || this._object.isEmpty() || this._baseParsedUrl.getObject().equals(this._object))) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_OBJECT_CONFLICT"));
            }
            if (this._host.isEmpty() && this._baseParsedUrl.getHost().isEmpty()) {
                throw new MalformedURLException(HttpResources.getString("CS_URL_HOST_MISSING"));
            }
            this._host = this._baseParsedUrl.getHost();
            if (this._namespace.isEmpty() && !this._baseParsedUrl.getNameSpace().isEmpty()) {
                this._namespace = this._baseParsedUrl.getNameSpace();
            }
            if (this._bucket.isEmpty() && !this._baseParsedUrl.getBucket().isEmpty()) {
                this._bucket = this._baseParsedUrl.getBucket();
            }
            if (this._object.isEmpty() && !this._baseParsedUrl.getObject().isEmpty()) {
                this._object = this._baseParsedUrl.getObject();
            }
        }

        @Override
        public String getHost() {
            return this._host;
        }

        @Override
        public String getNameSpace() {
            return this._namespace;
        }

        @Override
        public String getBucket() {
            return this._bucket;
        }

        @Override
        public String getObject() {
            return this._object;
        }

        @Override
        public ParsedUrl.UrlType getUrlType() {
            return this._urlType;
        }

        @Override
        public URL getURL() {
            return this._url;
        }

        @Override
        public boolean hasNSTAG() {
            return this._hasNSTAG;
        }

        @Override
        public boolean hasBSTAG() {
            return this._hasBSTAG;
        }

        @Override
        public boolean hasOSTAG() {
            return this._hasOSTAG;
        }
    }
}

