/* iod-telemetry Osstat.sql version 2019.06.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select /*+ INLINE */ --avoids ORA-02145: missing STORAGE option when database is mounted
        * from v$osstat
    ),
    v$metric as (
        select
            'Osstat.'||metric_name as metric_name
            ,'' as metric_dimensions
            ,metric_value
        from (
            select
                 round(load,2)                                                                      as "Load"
                ,num_cpus                                                                           as "Cpus"
                ,num_cpu_cores                                                                      as "CpuCores"
                ,physical_memory_bytes                                                              as "PhysicalMemoryBytes"
                ,free_memory_bytes                                                                  as "FreeMemoryBytes"
                ,inactive_memory_bytes                                                              as "InactiveMemoryBytes"
                ,swap_free_bytes                                                                    as "SwapFreeBytes"
                ,round(100*load/num_cpus,2)                                                         as "PercentCpusLoad"
                ,round(100*load/num_cpu_cores,2)                                                    as "PercentCpuCoresLoad"
                ,round(100*(free_memory_bytes+inactive_memory_bytes)/physical_memory_bytes,2)       as "PercentMemoryFree"
                ,round(100-100*(free_memory_bytes+inactive_memory_bytes)/physical_memory_bytes,2)   as "PercentMemoryUsed"
            from (
                select stat_name, value from v$metric_history
            ) pivot (
                sum(value) for stat_name in (
                     'LOAD' as load
                    ,'NUM_CPUS' as num_cpus
                    ,'NUM_CPU_CORES' as num_cpu_cores
                    ,'PHYSICAL_MEMORY_BYTES' as physical_memory_bytes
                    ,'FREE_MEMORY_BYTES' as free_memory_bytes
                    ,'INACTIVE_MEMORY_BYTES' as inactive_memory_bytes
                    ,'SWAP_FREE_BYTES' as swap_free_bytes
                )
            )
        ) unpivot (
            metric_value for metric_name in (
                 "Load"
                ,"Cpus"
                ,"CpuCores"
                ,"PhysicalMemoryBytes"
                ,"FreeMemoryBytes"
                ,"InactiveMemoryBytes"
                ,"SwapFreeBytes"
                ,"PercentCpusLoad"
                ,"PercentCpuCoresLoad"
                ,"PercentMemoryFree"
                ,"PercentMemoryUsed"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
