--include "std.arbori"

/*
 * Recognize various nodes on parse tree
 * Simple conditions, like
   "sql_statement": [sql_statement) sql_statement;
   are handled automatically without need to list them explicitly
   (SqlRecognizer sees no sql_statement in this file, so it adds one)
 */

"procedureCall": [procedureCall) function | [procedureCall) procedure_call;

"queryBlock": 
    [queryBlock) query_block
 ;

"main QB" : \/queryBlock("queryBlock");  -- auxiliary predicate (which is not listed among recognized symbols)
"nested QB" : "queryBlock" - "main QB";  -- ditto

-- When extracting columns the main challenge is not to look inside nested subqueries, for example 
--
--SELECT
--  DEPARTMENT_ID,
-- (select ignore from T) as scalarSubquery
-- FROM EMP_DETAILS_VIEW
--
-- "columnSelect" lists [DEPARTMENT_ID, COUNT(*), (select ignore from T1 where 1=1)] but not "ignore"
-- Hence query in three steps
-- 1. "all columns" 
-- 2. "columns in nested QB"
-- 3. subtract one from the other (projected to the column of interest, first)
"all columns": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause <= columnSelect
     & "main QB".queryBlock <= select_clause
;

"columns in nested QB": --[columnSelect) expr & ([columnSelect) select_term | [columnSelect^) select_term)
       [columnSelect) select_term
     & [select_clause) select_clause
     & select_clause < columnSelect
     & "nested QB".queryBlock < select_clause
;

"columnSelect": ([columnSelect]|"all columns") - ([columnSelect]|"columns in nested QB")
;

"all tables": ([tableFrom) query_table_expression | [tableFrom^) query_table_expression & [tableFrom-1) '.') 
     & [tableFrom) identifier
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "main QB".queryBlock < from_clause
;

"tables in nested QB": [tableFrom) query_table_expression & [tableFrom) identifier
     & [from_clause) from_clause
     & from_clause < tableFrom
     & "nested QB".queryBlock < from_clause
;

"tableFrom":  ([tableFrom]|"all tables") - ([tableFrom]|"tables in nested QB");

commonTableExprNames: ([cteName^) colmapped_query_name & [cteName) identifier
                      | [cteName) colmapped_query_name & [cteName) identifier)
      & [tableFrom) query_table_expression & [tableFrom) identifier
      & ?cteName = ?tableFrom
;

allTables:  ([tableFrom]|"all tables") - ([tableFrom]|commonTableExprNames)
->;


"where predicates":  
        [predicateWhere) condition
      & [predicateWhere^) where_clause
      & "main QB".queryBlock < predicateWhere
;
"ANSII JOIN predicates": 
        [predicateWhere) condition
      & [predicateWhere^) on_using_condition
      & "main QB".queryBlock < predicateWhere
;


"predicates in nested QB": predicateWhere^ = where_clause
      & [where_clause) where_clause
      & [predicateWhere) condition
      & "nested QB".queryBlock < where_clause
;


"predicateWhere": ([predicateWhere]|("where predicates"|"ANSII JOIN predicates")) 
     - ([predicateWhere]|"predicates in nested QB")
;

"expr in orderBy": [order_by_clause) order_by_clause 
	  & order_by_clause < orderBy
	  &  [orderBy) expr
	  & [order_by_clause^) subquery
;
"allOrderBys": \/orderBy("expr in orderBy")  -- e.g. order by 1+2 --<-- don't want returning nested 1 and 2 
;
"nestedOrderBys": "nested QB".queryBlock < "allOrderBys".orderBy 
; 
"orderBy": "allOrderBys" - "nestedOrderBys";

"expr in groupBy": [group_by_clause) group_by_clause 
	  & group_by_clause < groupBy
	  &  [groupBy) expr
;
"allGroupBys": \/groupBy("expr in groupBy")  
;
"nestedGroupBys": "nested QB".queryBlock < "allGroupBys".groupBy 
; 
"groupBy": "allGroupBys" - "nestedGroupBys";



functions:  [procedureCall) function & procedureCall < arg 
       & ([arg) string_literal | [arg) numeric_literal )
       & ([arg) expr | [arg) pls_expr )  -- 23246755: 
                                         -- SELECT SYS.XMLTYPE(xmlserialize(DOCUMENT XMLType('<poid>143598</poid>') AS
                                         -- CLOB indent size = 2)) "WORKFLOW_DATA"
                                         --                   ^^^ don't want this 
;

procedures:  [procedureCall) procedure_call & procedureCall < arg 
       & ([arg) string_literal | [arg) numeric_literal )
       & ([arg) expr | [arg) pls_expr )  -- 23246755: 
                                         -- SELECT SYS.XMLTYPE(xmlserialize(DOCUMENT XMLType('<poid>143598</poid>') AS
                                         -- CLOB indent size = 2)) "WORKFLOW_DATA"
                                         --                   ^^^ don't want this 
;


"arg":  functions | procedures
;


"user": [user) user;
"role": [role) identifier & [role^) revoke_roles_from_programs;

/*"pwd": ([pwd) identifier| [pwd) string_literal) & ( 
       [pwd-2) 'IDENTIFIED' & [pwd-1) 'BY'
     | [pwd^-1) 'IDENTIFIED' & [pwd-1) 'BY'
     | [pwd^-1) 'GLOBALLY' & [pwd-1) 'AS'
)     
;*/

"assignedBind": [assignedBind) bind_var & [assignedBind^) assignment_stmt & [assignedBind = [(assignedBind^)
              | [assignedBind) bind_var & [assignedBind^) into_list & [assignedBind-1) 'INTO'
;

standalone_procs: [object_name) identifier   
           &    ([object_type) 'PROCEDURE' | [object_type) 'FUNCTION'  )    
           & ![object_name+1) '.'   
           &   ( object_type = object_name-1
               | object_type = object_name^-1
               )
           &    ([object_name^^^) create_plsql | [object_name^^^^) create_plsql | [object_name^^^) ff_wo_external)
;
packages_types:      [object_name) identifier 
           &    ([object_type) 'PACKAGE' | [object_type) 'TYPE' | [object_type) 'BODY' | [object_type) wrap  ) 
           & ![object_name+1) '.'   
           &   (  object_type = object_name-1
                | object_type = object_name-3
                | object_type = object_name^^
               )
           &    ( [object_name^^) create_plsql | [object_name^^^) create_plsql | [object_name^^^^) create_plsql)
; 
triggers:  [object_name) identifier & object_type = object_name-1
           &  (  [object_name^) trigger  & ![object_name+1) '.'
              |  [object_name^^) trigger & [object_name-1) '.' & ![object_name+1) '.'
              )
; 


allConstraints:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'CONSTRAINT' & ![object_name+1) '.'
             |  [object_name-3) 'CONSTRAINT' & [object_name-1) '.' & ![object_name+1) '.'
              )
; 
tableConstraints: [table) relational_table 
           & table < object_name
           & [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'CONSTRAINT' & ![object_name+1) '.'
             |  [object_name-3) 'CONSTRAINT' & [object_name-1) '.' & ![object_name+1) '.'
              )
;
constraints: allConstraints - tableConstraints
;

dimensions:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'DIMENSION' & ![object_name+1) '.'
              | [object_name-3) 'DIMENSION' & [object_name-1) '.' & ![object_name+1) '.'
              )
; 
synonyms:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'SYNONYM' & ![object_name+1) '.'
              | [object_name-3) 'SYNONYM' & [object_name-1) '.' & ![object_name+1) '.'
              )
;
sequences:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'SEQUENCE' & ![object_name+1) '.'
              | [object_name-3) 'SEQUENCE' & [object_name-1) '.' & ![object_name+1) '.'
              )
;  
tables:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'TABLE' & ![object_name+1) '.'
              | [object_name-3) 'TABLE' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & [object_name^) create_table
; 
views1:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'VIEW' & ![object_name+1) '.'
              | [object_name-3) 'VIEW' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & ([object_name^) create_view | /*[object_name^) create_view# |*/ [object_name^) create_json_relational_duality_view
             )
;

views2:  
     [object_name) materialized_view  &  [object_type) 'VIEW' & object_type) <= [object_name
;

views:  views1 | views2
;



indexes:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'INDEX' & ![object_name+1) '.'
              | [object_name-3) 'INDEX' & [object_name-1) '.' & ![object_name+1) '.'
              )
           & ([object_name^) create_index | [object_name^^) create_index)
;  

dblinks:  [object_name) identifier & object_type = object_name-1
           &  ( [object_name-1) 'LINK' & [object_name-2) 'DATABASE'
              | /*[object_name-2) 'LINK' & [object_name-3) 'DATABASE' &*/ [object_name-1) create_database_link___0 
              )
;  

scheduler_programs:  [object_name) arg & [object_name-1) '(' & [object_name^) paren_expr_list
               & call^=object_name^-1 & ?call ='dbms_Scheduler' & [call+1) '.' & (
                    ?object_type ='create_program' 
                  | ?object_type ='create_job' 
                  | ?object_type ='create_job_class' 
                  | ?object_type ='create_schedule'
                  | ?object_type ='create_window'
                ) & object_type = call+2
->{
  //print(tuple["object_name"])
}  


objects: standalone_procs | packages_types | triggers
       | constraints | dimensions | synonyms | sequences | dblinks
       | tables | views | indexes
       | scheduler_programs
->
;


all_references: [type) identifier & ( [type) constrained_type | [type) unconstrained_type )
      |   [type) dotted_name   & [type^) adt_field
      |   [type) dotted_name   & [type^) array_ty_def
      |   [type) dotted_name   & [type^) constrained_type     ----test 91
      |   [type) name_wo_function_call   & [type^) function_call 
      |   [type) dotted_name   & [type^) function_call 
      |   [type) name_wo_function_call   & [type) procedure_call & ![type) bind_var 
           & ![type) term  -- hack to fix test#74 where local var is recognized as function call
      --not necessary for regression test: 
      --|   [type) dotted_name   & [type) procedure_call & ![type) bind_var 
      --     & ![type) term  -- hack to fix test#74 where local var is recognized as function call
      | [type) identifier & [type^) function_expression
      | [type) identifier & [type+1) '.' & [type^^) function_expression
      | [type) identifier & [type^) adt_type_spec
      | [type) identifier & [type-1) '.' & [type^) references_clause & [type^^) out_of_line_ref_constraint
      | [type) identifier & ![type+1) '.' & [type^) references_clause 
      | [type) identifier & [type+1) '.' & [type^^) adt_type_spec
      | [type) identifier & [type+1) '.' & [type^^) default_expr_opt
      | [type) table & [type^) create_materialized_vw_log
      | [type) identifier & [type) constrained_type & [type^) adt_field
      | [type) identifier & [type-3) 'BODY'
      | [type) identifier & [type-1) 'BODY' & ![type+1) '.'
      | [type) identifier & [type-3) 'ON' & [type^) dml_event_clause
      | [type) identifier & [type-1) 'ON' & ![type+1) '.' & [type^) dml_event_clause
      | [type) table & [type^) table_index_clause
      | [type) dml_table_expression_clause
      | [type) identifier & [type-1) 'FOR' & [type^) create_synonym
      | [type) datatype & [type-1) 'AS' & [type^) cast  
      | [type) name_wo_function_call & [type^) procedure_call                       ----test 105    
      | [type) table & [type^^) column --& [type + 2 < type)                        ----test 92    
;
local_references: ( [def) identifier & [def^) basic_d & [def+1) 'IS'
                  | [def) identifier & [def^) table_reference
                  | [def) identifier & [def^) iterator
                  | [def) identifier & [def^) create_table
      ) & ?all_references.type = ?def & ! def = all_references.type
;      
      
references: all_references - local_references     
->
;

returns_in_procs: [return) return_stmt
      & [procedure_node) subprg_body
      & procedure_node < return
;

all_returns:
      [return) return_stmt
;

"return":
  all_returns - returns_in_procs
;  

"matchRecognizeProblematicSymbols": ( [matchRecognizeProblematicSymbols^) row_pattern_quantifier
                                    | [matchRecognizeProblematicSymbols^) row_pattern_term 
                                    | [matchRecognizeProblematicSymbols^^) row_pattern_factor  ) 
 & (  [matchRecognizeProblematicSymbols) '?' 
   |  [matchRecognizeProblematicSymbols) '{' 
   |  [matchRecognizeProblematicSymbols) '}' )
;   

"withClause":
   [withClause) with_clause
;   


local_names1:  
     [object) query_table_expression & [obj2) subquery & obj2^=object

;  

local_names2:  (   
     [obj2) identifier & [obj2^) cursor_d 
|  
     [obj2) iterand_decl & [obj2^) iterator 
|     
     [obj2) decl_id & [obj2^) object_d 
     
) &  [object) name_wo_function_call & ?object = ?obj2
;    

local_names:  local_names1 | local_names2 -- to subtract
->
   

global_names: 
       [object) query_table_expression  
     | [object) table & [object^) sql_statement   -- alter table, truncate table, etc
     | [object) dml_table_expression_clause 
     | [object) name_wo_function_call & [object^) procedure_call & ![object^) name_wo_function_call
     | [object) name_wo_function_call & [object) procedure_call 
     | [object) dotted_name & [object^^) object_d_rhs
->

execute_immediate: [node) string_literal
                &  [node^) exec_immediate_statement
->

database_names:  [name) identifier 
           &  ( [name-1) 'DATABASE' 
              | [name^-1) 'DATABASE' 
              | [name^^-1) 'DATABASE' 
              | [name^^^-1) 'DATABASE'
              | [name^^^^-1) 'DATABASE'
              | [name^^^^^-1) 'DATABASE'
              ) 
| [name] --<<-- ordering by 1st column 
-> 
              

