Rem
Rem $Header: dbgendev/src/langdata/plsql/setup/setup_pkg.pks /main/15 2025/08/05 18:39:33 deveverm Exp $
Rem
Rem setup_pkg.pks
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      setup_pkg.pks - Package specification of setup_pkg
Rem
Rem    DESCRIPTION
Rem      Specifies the procedures/functions responsible for setting up the
Rem	 database of the user of Lang-Data.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/setup/setup_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    07/28/25 - refactored create_types to create_types.sql
Rem    arevathi    07/01/25 - Change onnx_model_dir to mount_dir
Rem    arevathi    05/19/25 - Add role grants procedure
Rem    jiangnhu    02/13/25 - DBAI-524: Remove create_user_table_indexes
Rem    jiangnhu    01/23/25 - Move create_global_temp_tables to
Rem                           create_tables.sql to fix installation issue
Rem    jiangnhu    12/05/24 - DBAI-421: Add create_resource_plan
Rem    jiangnhu    11/12/24 - JIRA_DBAI-425: Add create_global_temp_tables, 
Rem                           create_python_functions, create_types
Rem    jiangnhu    10/30/24 - DBAI-383: Add create_user_table_indexes
Rem    dadoshi     10/18/24 - JIRA_DBAI-399: Update template
Rem    pryarla     10/16/24 - Created
Rem

create or replace package lang_data_setup_pkg is
	PROCEDURE create_python_functions;
    -- Create a stoplist with the stop-words from ctxsys.ctx_stopwords as base.
    PROCEDURE create_stoplist;
    PROCEDURE load_onnx_model(
        model_path IN VARCHAR2,  -- Directory path or Bucket URL
        filename   IN VARCHAR2,  -- ONNX model file name
        modelname  IN VARCHAR2,  -- Target model name
        cred_name  IN VARCHAR2 DEFAULT NULL -- Credential name
    );
	procedure create_resource_plan;
	PROCEDURE execute_sql_script (
        work_dir IN VARCHAR2,
        file_name IN VARCHAR2,
        delimiter IN VARCHAR2
    );
	procedure init(
        mount_dir IN VARCHAR2,
        -- true to enable execution of SQL Scripts that setup tables, 
        -- triggers, and procedures.
        p_setup_db IN BOOLEAN DEFAULT false
    );
    -- Grant necessary package execution privileges to lang_data roles.
    procedure grant_langdata_execution_privileges_by_role;

end lang_data_setup_pkg;
/

