Rem
Rem $Header: dbgendev/src/langdata/plsql/reports/reports_pkg.pks /main/23 2025/08/17 19:34:27 deveverm Exp $
Rem
Rem reports_pkg.pks
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      reports_pkg.pks - Lang Data Reports package
Rem
Rem    DESCRIPTION
Rem      This package contains specifications of procedures 
Rem      for managing reports and their descriptions.
Rem
Rem    NOTES
Rem      None
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/reports/reports_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    08/14/25 - Added purge_reports procedure to remove outdated reports based on timestamp and domain.
Rem    deveverm    08/08/25 - Added purge_reports procedure
Rem    dadoshi     07/31/25 - JIRA_DBAI1149: Add optional parameter,
Rem                           p_description_vector to create_report
Rem    saloshah    07/30/25 - DBAI-1101: Added exceptions for non existent id
Rem                           for update_report_description 
Rem    dadoshi     07/24/25 - JIRA_DBAI1056: Add
Rem                           get_report_match_document_by_id
Rem    dadoshi     07/22/25 - JIRA_DBAI1079: Update report description status
Rem                           validation
Rem    dadoshi     07/22/25 - JIRA_DBAI1056: Added get_report_status_by_id
Rem    deveverm    07/18/25 - DBAI-1050: added p_is_new_report parameter to
Rem                           get_report_regression
Rem    ruohli      07/14/25 - DBAI-956: Implement New report creation validation
Rem    ruohli      06/30/25 - DBAI-945: Added an option to calculate the
Rem                           regression by report. Change create_report
Rem                           procedure to trigger regression calculation in
Rem                           the same session
Rem    jiangnhu    06/09/25 - Implement APIs to get ID by unique combination of 
Rem                           title, version, etc.
Rem    deveverm    05/16/25 - DBAI-761: changed
Rem                           get_report_description_regression to
Rem                           get_report_regression, changed
Rem                           calculate_report_description_regression to
Rem                           calculate_report_regression
Rem    deveverm    04/01/25 - DBAI-523: added get_report_description_regression
Rem                           and modified regression logic
Rem    jiangnhu    03/26/25 - DBAI-692: make report_id, description_id OUT
Rem                           parameter, make enumeration limit a config
Rem    jiangnhu    03/19/25 - DBAI-543: Better naming conventions for
Rem                           augmentation/amending
Rem    jiangnhu    03/15/25 - DBAI-661: Implement
Rem                           replace_report_filter_enumerable_set
Rem    arevathi    03/11/25 - Add Update status API's
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    dadoshi     01/29/25 - JIRA_DBAI-506: Update add_report_description and
Rem                           create_report APIs to have IDs as optional
Rem                           arguments
Rem    dadoshi     11/13/24 - Update get_report to get_report_paginated
Rem    dadoshi     11/04/24 - Update execute_report_sql to handle large number
Rem                           of rows
Rem    arevathi    10/29/24 - Added Validation APIs for report
Rem    dadoshi     10/25/24 - Add execute_report_sql
Rem    deveverm    10/25/24 - added get_report_description
Rem    deveverm    10/23/24 - added get_all_reports
Rem    deveverm    10/22/24 - added update_report_description
Rem    deveverm    10/22/24 - added delete_report_description
Rem    deveverm    10/22/24 - added add_report_description
Rem    deveverm    10/22/24 - added delete_report
Rem    deveverm    10/21/24 - fix text wrapping
Rem    deveverm    10/18/24 - DBAI-299: Modify Header
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_reports_pkg IS
/*
    ----------------------------------------------------------------------
    Package Name: lang_data_reports_pkg
    Description: This package contains procedures related to the report
	and report descriptions. These procedures are designed to handle CRUD
	and validation operations on reports/report descriptions.
    ----------------------------------------------------------------------
    Author: Deepanshu Verma
    Created: 09/27/2024
    ----------------------------------------------------------------------
    Public Procedures:
    ----------------------------------------------------------------------
    
    PROCEDURE get_report_paginated
    ---------------------------------
    Description:
		Retrieves a report entity based on the provided report ID, along 
        with its descriptions and sample queries, from the langdata$reports 
        table. This procedure supports pagination for both descriptions and 
        sample queries, allowing controlled data retrieval with cursors.
        
        Parameters:
        - p_report_id (IN VARCHAR2):
            The unique identifier for the report. The procedure retrieves the 
            report details based on this ID.

        - p_title (OUT VARCHAR2):
            The title of the report, fetched from the langdata$reports table.
        
        - p_match_document (OUT JSON):
            A JSON document containing details such as SQL queries and filters 
            associated with the report.

        - p_status (OUT VARCHAR2):
            The current status of the report. It can have one of the following 
            values: 'Pending Review', 'Approved', 'Rejected', 'Published', 
            'Inactive', or 'Archived'.
        
        - p_descriptions (OUT SYS_REFCURSOR):
            A cursor that returns the descriptions associated with the report 
            from the langdata$reportdescriptions table.    

            Each Description row has the following fields:
                - id            VARCHAR2
                - text          VARCHAR2
                - version       VARCHAR2
                - status        VARCHAR2
                - enhanced_text  VARCHAR2.

        - p_description_cur (IN OUT VARCHAR2):
            This is an optional serialized pagination cursor in the format 
            `created_at|id`. It represents the created_at timestamp and ID of 
            the first record on the current page. The cursor is NULL for the 
            first page and is set with the next cursor value for subsequent 
            pages.
        
        - p_sample_queries (OUT SYS_REFCURSOR):
            A cursor that returns sample queries associated with the report 
            from the langdata$samplequeries table. 

            Each sample query row has the following fields:
                - id            VARCHAR2
                - query_text    VARCHAR2
                - augmented_query_text  VARCHAR2

        
        - p_sample_query_cur (IN OUT VARCHAR2):
            This is an optional serialized pagination cursor for sample 
            queries, in the same format as p_description_cur. It allows for 
            pagination in the sample queries list.
        
        - p_sample_query_limit (IN NUMBER DEFAULT 10):
            An optional parameter that defines the number of rows to fetch for 
            sample queries in each page. If not specified, 
            the default limit is set to 10.  Set to NULL to fetch all 
            sample queries without pagination.
        
        - p_descriptions_limit (IN NUMBER DEFAULT 10):
            An optional parameter that defines the number of rows to fetch for 
            descriptions in each page. If not specified, 
            the default limit is set to 10. Set to NULL to fetch all 
            description without pagination.

    Exceptions:        
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20000 using the lang_data_errors_pkg 
            package.
        
        - c_resource_not_found (-20004):
            Raised when no report is found for the given report ID. A custom 
            error with code -20004 is raised, using the lang_data_errors_pkg 
            package, with the message "Resource not found".

    ----------------------------------------------------------------------
    Procedure get_report_descriptions_paginated
    ----------------------------------------------------------------------
    Description:
        Retrieves paginated report descriptions for a specific report from
        the langdata$reportdescriptions table. It enables controlled data 
        retrieval using pagination via a serialized cursor.
        
        The descriptions include fields such as ID, description text, 
        version, status, and enhanced text.

    Parameters:
    ----------------------------------------------------------------------
        - p_id (IN VARCHAR2):
            The unique identifier of the report for which the descriptions 
            are being retrieved.

        - p_limit (IN NUMBER DEFAULT 10):
            Specifies the maximum number of description rows to fetch in one 
            call. The default value is set to 10 if not provided.  Set to NULL
            for fetching all description rows without pagination.

        - p_cursor (IN OUT VARCHAR2):
            An optional serialized pagination cursor, represented in the 
            format `created_at|id`. On the first page, this value is NULL. 
            The procedure will return the next cursor value for subsequent 
            pages of data.

        - p_descriptions (OUT SYS_REFCURSOR):
            A cursor that returns the result set of report descriptions. 

            Each Description row has the following fields:
                - id            VARCHAR2
                - text          VARCHAR2
                - version       VARCHAR2
                - status        VARCHAR2
                - enhanced_text  VARCHAR2

    Exceptions:
    ----------------------------------------------------------------------
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20000 using the lang_data_errors_pkg 
            package.

    ----------------------------------------------------------------------    
    PROCEDURE create_report
    ----------------------------------------------------------------------
    Description:
        This procedure creates a new report and its corresponding 
        description . It also allows adding sample queries associated with the 
        report and generates value vectors for match document enumeration. 
        Moreover, it also optionally associates it with a domain. If the domain
        doesn't exist, it will be created (nomalized to lowercase) and linked.
    
    Parameters:
        - p_title (IN VARCHAR2):
            The title of the report. The length of the title is validated to 
            ensure it does not exceed 255 characters.
        
        - p_match_document (IN JSON):
            A JSON document that contains the SQL queries and filters 
            associated with the report. The structure of the match document 
            is validated to ensure correctness.
        
        - p_description_text (IN VARCHAR2):
            The text of the report description.

        - p_description_vector (IN VECTOR DEFAULT NULL):
            Vector of the report description text.        
        
        - p_description_status (IN VARCHAR2):
            The status of the report description. It can have one of the 
            following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'.
        
        - p_report_status (IN VARCHAR2):
            The status of the report to be created. It can have one of the 
            following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'
        
        - p_sample_queries (IN SYS.ODCIVARCHAR2LIST):
            A list of sample queries associated with the report.
        
        - p_domain (IN VARCHAR2):
            The domain name that needs to be linked with the report.

        - p_report_id (OUT VARCHAR2):
            The unique identifier for the report to be created.
        
        - p_description_id (OUT VARCHAR2):
            The unique identifier for the report description.
    
    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20000 using the lang_data_errors_pkg
            package.

        - c_invalid_parameters_code (-20002):
            Raised when the report or description parameters are invalid. 
            Logged as an error before raising.
        
        - c_invalid_match_document (-20005):
            Raised when the match document's structure is invalid. 
            This is validated using the `validate_match_document` function.
        
        - c_resource_already_exists (-20006):
            Raised when a description with the same MD5 hash already exists 
            in the `langdata$reportdescriptions` table. This prevents duplicate 
            entries for the same description.
    ----------------------------------------------------------------------
    Procedure get_all_reports
    ----------------------------------------------------------------------
    Description:
        Retrieves paginated reports from the langdata$reports table. It allows
        filtering using the status of the reports. It enables controlled data 
        retrieval using pagination via a serialized cursor.

    Parameters:
        - p_status (IN VARCHAR2):
            The status for filtering out reports based on status, set to NULL 
            for fetching all the reports. Default is NULL.
        
        - p_cursor (IN OUT VARCHAR2):
            An optional serialized pagination cursor, represented in the 
            format `created_at|id`. On the first page, this value is NULL. 
            The procedure will return the next cursor value for subsequent 
            pages of data.
        
        - p_limit (IN NUMBER):
            Specifies the maximum number of description rows to fetch in one 
            call. The default value is set to 10 if not provided. Set to NULL
            for fetching all reports without pagination.
        
        - p_reports (OUT SYS_REFCURSOR):
            A cursor that returns the result set of reports.
            
            The reports contains the following fields:
            - id                VARCHAR2 
            - title             VARCHAR2   
            - match_document    JSON        
            - status            VARCHAR2
            - description       VARCHAR2
        
            Note: description is the latest descriptions of the report with 
            Published status.
            
    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the lang_data_errors_pkg 
            package.
        
        - c_invalid_parameters_code (-20002):
            Raised when the report or description parameters are invalid. 
            Logged as an error before raising.

    ----------------------------------------------------------------------
    Procedure delete_report
    ----------------------------------------------------------------------
    Description:
        This procedure deletes the requested report using report id, 
        and throws exceptions if the report doesn't exist
    
    Parameters:
        - p_report_id (IN VARCHAR2):
            Report ID of the report to be deleted
    
    Exception: 
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure.

        - c_invalid_parameters_code (-20002):
            Raised when the report id to be deleted does not exist.

    ----------------------------------------------------------------------
    Procedure add_report_description
    ----------------------------------------------------------------------
    Description:
        This procedure adds a report description to the requested report,
        after ammending the description with the filters used in the match 
        document of the report.

    Parameters:
        - p_report_id (IN VARCHAR2):
            ID of the report to add the description to 

        - p_text (IN VARCHAR2):
            Description to be added to the report.
            Note: This description will be deduplicated and expanded with 
            filter descriptions of the filters mentioned in match_document.
    
        - p_status (IN VARCHAR2):
            The status of the report description. It can have one of the 
            following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'.

        - p_description_id (OUT VARCHAR2):
            ID for the description to be created.
        
    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure.

        - c_invalid_parameters_code (-20002):
            Raised when either report id does not exist or the status is 
            invalid. Exact reason is logged before the exception is raised.
        
        - c_max_text_length_exceeded (-20003):
            Raised when description length is more than 2000 characters.

        - c_resource_already_exists (-20006):
            Raised when a description with the same MD5 hash already exists 
            in the `langdata$reportdescriptions` table. This prevents duplicate
            entries for the same description.
    
    ----------------------------------------------------------------------
    Procedure delete_report_description
    ----------------------------------------------------------------------
    Description:
        This procedure deletes the requested report description using 
        description id, and throws exceptions if description does not exist or 
        when the user tries to delete the only description of a report.

    Parameters:
        - p_report_description_id (IN VARCHAR2):
            Description id of the report description.
    
    Exception: 
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure.

        - c_invalid_parameters_code (-20003):
            Raised when the report description id to be deleted does not exist.
        
        - c_description_invalid_deletion (-20011):
            Raised when user tries to delete the description of a report, but 
            the report has only one description. This is due to the fact that 
            all reports must have at least one description.
    
    ----------------------------------------------------------------------
    Procedure update_report_description
    ----------------------------------------------------------------------
    Description:
        This procedure updates report description to a new description.
        Description can be changed only for descriptions which are currently
        in Pending Review state.

    Parameters:
        - p_id (IN VARCHAR2):
            ID for description whose text is to be updated.
        
        - p_text (IN VARCHAR2):
            Updated report description text.
    
    Exceptions:
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure.

        - c_invalid_parameters_code (-20002):
            Raised when status of the description being updated is not Pending 
            Review.

        - c_max_text_length_exceeded (-20003):
            Raised when description length is more than 2000 characters.

        - c_resource_not_found (-20004):
            Raised when no report description is found for the given 
            report description ID. 
            A custom error with code -20004 is raised, using the 
            lang_data_errors_pkg package, with the message 
            "Resource not found".
        
        - c_resource_already_exists (-20006):
            Raised when a description with the same MD5 hash already exists 
            in the `langdata$reportdescriptions` table. This prevents duplicate
            entries for the same description.
    ----------------------------------------------------------------------
    Procedure get_report_description
    ----------------------------------------------------------------------
    Description:
        This procedure fetches report description using description id.

    Parameters:
        - p_id (IN VARCHAR2):
            ID for the report description to be fetched.

        - p_text (OUT VARCHAR2):
            Description text associated with the report description.

        - p_version (OUT NUMBER):
            Version no. of the report description, each description associated 
            with the report has a distinct version number.

        - p_status (OUT VARCHAR2):
            The current status of the report. It can have one of the following 
            values: 'Pending Review', 'Approved', 'Rejected', 'Published', 
            'Inactive', or 'Archived'.

        - p_report_id (OUT VARCHAR2):
            ID of the report associated with the report description.

        - p_enhanced_text (OUT VARCHAR2):
            Enhanced text is the original description text with appended filter
            descriptions and augmentation.
    
    Exceptions:
        - c_resource_not_found (-20004):
            This exception is raised when the requested report description id
            doesn't exist or has been deleted.
    ----------------------------------------------------------------------------
    Procedure: execute_report_sql
    ----------------------------------------------------------------------------
    Description:
        Executes a dynamic SQL query for a report, based on the provided report 
        ID and filter values. The procedure retrieves the SQL statement 
        associated with the report ID from the `langdata$reports` table and 
        binds filter values extracted from a JSON object. It describes the 
        result set to determine the column names and fetches the result rows, 
        storing the column names in the output parameter `p_columns` and row 
        data in the output parameter `p_data`. The procedure also handles 
        exceptions related to missing report IDs and logs relevant information 
        throughout its execution.
    ----------------------------------------------------------------------------
    Parameters:
    - p_report_id (IN VARCHAR2):
        The unique identifier for the report for which the SQL query is to be 
        executed.

    - p_filter_values (IN JSON):
        A JSON object containing key-value pairs used to filter 
        the results of the SQL query.

    - p_columns (OUT SYS.ODCIVARCHAR2LIST):
        An output parameter that returns a list of column names 
        from the executed SQL query.

    - p_data (OUT CLOB):
        An output parameter that returns a LOB of concatenated 
        row data from the executed SQL query, with each row represented 
        as a JSON object of the format: {"columnName": "value", ...}
    ----------------------------------------------------------------------------
    Exceptions:
    - NO_DATA_FOUND:
        Raised when no report is found for the specified report ID. This 
        triggers logging an error message and raises a custom error for 
        resource not found.

    ----------------------------------------------------------------------    
    Procedure calculate_report_regression
    ----------------------------------------------------------------------
    Description:
        This procedure helps identify regression introduced by any report 
        description or sample query, w.r.t. user search records. 

    Parameters:
    ----------------------------------------------------------------------
        - p_new_description_id (IN VARCHAR2):
            The unique identifier of the description for which regression 
            analysis is being performed.
        
        - p_new_sample_query_id (IN VARCHAR2):
            The Unique identifier of the sample query for which regression
            analysis is being performed.
    Exceptions:
    ----------------------------------------------------------------------
        - c_unauthorized_code (-20000):
            Raised when the user does not have the required role 
            (LANG_DATA_APP_EXPERT) to access the procedure. This triggers a 
            custom error with code -20002 using the lang_data_errors_pkg 
            package.
    
        - c_invalid_parameters_code(-20002):
            Raised when the description being checked for regression is not in 
            'Pending Regression' state.
            
    ----------------------------------------------------------------------
    Procedure replace_report_filter_enumerable_set
    ----------------------------------------------------------------------
    Description:
        This procedure replaces the enumerable set of a specific filter in 
        a report's match document with a new enumerable set. If the filter 
        does not exist or does not contain an enumerable set, an error is raised

    Parameters:
        - p_report_id (IN VARCHAR2):
            The unique identifier of the report whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be replaced.

        - p_new_enumerable_set (IN JSON_ARRAY_T):
            The new enumerable set to be assigned to the specified filter.

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.

    ----------------------------------------------------------------------
    Procedure add_into_report_filter_enumerable_set
    ----------------------------------------------------------------------
    Description:
        This procedure adds new values to the enumerable set of a specific 
        filter in a report's match document. The updated enumerable set 
        consists of the union of the existing values and the new values.

    Parameters:
        - p_report_id (IN VARCHAR2):
            The unique identifier of the report whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be modified.

        - p_enumerable_set_to_add (IN JSON_ARRAY_T):
            The enumerable set containing values to be added to the existing set

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - The function merges the old and new enumerable sets, keeping only 
          distinct values.
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.
    
    ----------------------------------------------------------------------
    Procedure remove_from_report_filter_enumerable_set
    ----------------------------------------------------------------------
    Description:
        This procedure removes specific values from the enumerable set of 
        a filter in a report's match document. The updated enumerable set 
        consists of the existing values minus the values provided in the 
        input enumerable set.

    Parameters:
        - p_report_id (IN VARCHAR2):
            The unique identifier of the report whose filter is to be updated.

        - p_filter_name (IN VARCHAR2):
            The name of the filter whose enumerable set should be modified.

        - p_enumerable_set_to_remove (IN JSON_ARRAY_T):
            The enumerable set containing values to be removed from the existing
            set.

    Exception: 
        - c_invalid_parameters_code (-20003):
            Raised if the specified filter does not exist or does not have 
            an enumerable set.

    Notes:
        - The function removes only the specified values from the existing 
          enumerable set while retaining all other values.
        - If the update is successful, a background job is scheduled to 
          update the value vectors for the modified enumerable set.
    
    ----------------------------------------------------------------------
    PROCEDURE update_report_status
    ----------------------------------------------------------------------
    Description:
        This procedure updates the status of a report to a new status.

    Parameters:
        - p_id (IN VARCHAR2):
            ID of the report whose status is to be updated.
        
        - p_status (IN VARCHAR2):
            The current status of the report. It can have one of the following 
            values: 'Pending Review', 'Approved', 'Rejected', 'Published', 
            'Inactive', or 'Archived'.
    
    Exceptions:
        - c_invalid_parameters_code (-20002):
            Raised when the status or report ID is invalid.

    ----------------------------------------------------------------------
    PROCEDURE update_report_description_status
    ----------------------------------------------------------------------
    Description:
        This procedure updates the status of a report description.

    Parameters:
        - p_id (IN VARCHAR2):
            ID of the report description whose status is to be updated.
        
        - p_status (IN VARCHAR2):
            The current status of the report description. It can have one of 
            the following values: 'Pending Review', 'Approved', 'Rejected', 
            'Published', 'Inactive', or 'Archived'.
    
    Exceptions:    
        - c_invalid_parameters_code (-20002):
            Raised when the status or report ID is invalid.

    ----------------------------------------------------------------------
    PROCEDURE get_report_description_regression
    ----------------------------------------------------------------------
    Description:
        This procedure fetches regression data for a report description. In case
        no regression data exists, it calls 
        calculate_report_regression and generates regression json

    Parameters:
        - p_description_id (IN VARCHAR2):
            ID of the report description.
        
        - p_new_sample_query_id (IN VARCHAR2):
            ID of the sample query
        
        - p_force (IN BOOLEAN):
            If set to true calls calculate_report_regression and 
            invalidates all previous data. If not set to true it returns 
            previous regression data if available, if previous regression is 
            still being calculated, returns null.

        - p_json (OUT JSON):


    Exceptions:    
        - c_invalid_parameters_code (-20002):
            Raised when report description ID is invalid.
    
    ----------------------------------------------------------------------
    FUNCTION get_report_id_by_title
    ----------------------------------------------------------------------
    Description:
        This function retrieves the unique report ID corresponding to the 
        given report title.

    Parameters:
        - p_title (IN VARCHAR2):
            The title of the report to look up.

    Returns:
        - VARCHAR2:
            The unique ID of the report matching the given title.

    Exceptions:
        - c_resource_not_found (-20004):
            Raised when no report is found for the given report title. A custom 
            error with code -20004 is raised, using the lang_data_errors_pkg 
            package, with the message "Resource not found".
    
    ----------------------------------------------------------------------
    FUNCTION get_desc_id_by_report_id_version
    ----------------------------------------------------------------------
    Description:
        This function retrieves the description ID for a specific version 
        of a given report.

    Parameters:
        - p_report_id (IN VARCHAR2):
            The unique ID of the report.

        - p_version (IN NUMBER):
            The version number of the report description to retrieve.

    Returns:
        - VARCHAR2:
            The description ID for the given report ID and version.

    Exceptions:
        - c_resource_not_found (-20004):
            Raised when no report description is found for the given report id 
            and version. A custom error with code -20004 is raised, using the 
            lang_data_errors_pkg package, with the message "Resource not found".
    ----------------------------------------------------------------------
    PROCEDURE cache_purge_reports
    ----------------------------------------------------------------------
    Description:
        This procedure purges reports based on a specified timestamp and
        domain. It deletes reports that are older than the provided timestamp
        and belong to the specified domain which have hits lower than a 
        threshold.

    Parameters: 
        - p_domain (IN VARCHAR2):
            The domain for which reports should be purged. If NULL, all domains 
            are considered.

        - p_timestamp (IN TIMESTAMP DEFAULT NULL):
            The timestamp before which reports should be purged. If NULL, 
            all reports are considered for purging.
        
        - p_hit_limit (IN NUMBER DEFAULT NULL):
            Reports with hits lower than this limit will be considered for 
            purging. If NULL, no limit is applied.  
        - p_action (IN VARCHAR2 DEFAULT 'COUNT'):
            The action to be performed. Allowed values are:
            - 'COUNT': Returns the number of reports that would be purged.
            - 'DELETE': Actually deletes the reports that would be purged.
            - 'ARCHIVE': Archives the reports instead of deleting them.
        - p_num_reports (OUT NUMBER):
            The number of reports that were purged.
    Note:
        If none of the parameters are provided, as default the procedure will 
        return the count of reports in that domain
    */
    

    -- Public procedure for retriving paginated report descriptions
    PROCEDURE get_report_descriptions_paginated (
        p_report_id     IN VARCHAR2,
        p_limit         IN NUMBER DEFAULT 10,
        p_cursor        IN OUT VARCHAR2,
        p_descriptions  OUT SYS_REFCURSOR
    );

	-- Public procedure declaration for retriving a report
	PROCEDURE get_report_paginated (
		p_id IN VARCHAR2,
		p_title OUT VARCHAR2,
		p_match_document OUT JSON,
		p_status OUT VARCHAR2,
		p_descriptions OUT SYS_REFCURSOR,
        p_description_cur IN OUT VARCHAR2,
        p_descriptions_limit IN NUMBER DEFAULT 10,
		p_sample_queries OUT SYS_REFCURSOR,
        p_sample_query_cur IN OUT VARCHAR2,
        p_sample_query_limit IN NUMBER DEFAULT 10
	);

    -- Public Procedure to create a report
    PROCEDURE create_report (
        p_title                 IN VARCHAR2,
        p_match_document        IN JSON,
        p_description_text      IN VARCHAR2,
        p_description_status    IN VARCHAR2,
        p_report_status         IN VARCHAR2,
        p_sample_queries        IN SYS.ODCIVARCHAR2LIST,
        p_description_vector    IN VECTOR DEFAULT NULL,
        p_domain                IN VARCHAR2 DEFAULT NULL,
        p_new_report_validation IN BOOLEAN DEFAULT FALSE,
        p_report_id             OUT VARCHAR2,
        p_description_id        OUT VARCHAR2
    );

    -- Public Procedure to validate new description in a report
    PROCEDURE calculate_report_regression(
        p_new_description_id    IN VARCHAR2 DEFAULT NULL,
        p_new_sample_query_id   IN VARCHAR2 DEFAULT NULL,
        p_is_new_report       IN BOOLEAN DEFAULT FALSE 
    );
    
    -- Public Procedure to fetch all reports
    PROCEDURE get_all_reports (
        p_status            IN VARCHAR2 DEFAULT NULL,
        p_cursor            IN OUT VARCHAR2,
        p_limit             IN NUMBER DEFAULT 10,
        p_reports           OUT SYS_REFCURSOR
    );

    -- Public Procedure to delete report
    PROCEDURE delete_report(
        p_report_id         IN VARCHAR2
    );

    -- Public Procedure to add report description
    PROCEDURE add_report_description(
        p_report_id         IN VARCHAR2,
        p_text              IN VARCHAR2,
        p_status            IN VARCHAR2,
        p_description_id    OUT VARCHAR2
    );

    -- Public Procedure to delete report description
    PROCEDURE delete_report_description(
        p_description_id    IN VARCHAR2
    );

    -- Public Procedure to update report description
    PROCEDURE update_report_description(
        p_id                IN VARCHAR2,
        p_text              IN VARCHAR2
    );

    -- Public Procedure to fetch report description
    PROCEDURE get_report_description(
        p_id                IN VARCHAR2,
        p_text              OUT VARCHAR2,
        p_version           OUT NUMBER,
        p_status            OUT VARCHAR2,
        p_report_id         OUT VARCHAR2,
        p_enhanced_text      OUT VARCHAR2
    );


    PROCEDURE execute_report_sql(
        p_report_id IN VARCHAR2,
        p_filter_values IN JSON,
        p_columns OUT SYS.ODCIVARCHAR2LIST,
        p_data OUT CLOB
    );

    PROCEDURE replace_report_filter_enumerable_set (
        p_report_id             IN  VARCHAR2,
        p_filter_name           IN  VARCHAR2,
        p_new_enumerable_set    IN  JSON_ARRAY_T
    );

    PROCEDURE add_into_report_filter_enumerable_set (
        p_report_id                IN  VARCHAR2,
        p_filter_name              IN  VARCHAR2,
        p_enumerable_set_to_add    IN  JSON_ARRAY_T
    );

    PROCEDURE remove_from_report_filter_enumerable_set (
        p_report_id                   IN  VARCHAR2,
        p_filter_name                 IN  VARCHAR2,
        p_enumerable_set_to_remove    IN  JSON_ARRAY_T
    );

    PROCEDURE update_report_status(
        p_id                IN VARCHAR2,
        p_status            IN VARCHAR2
    );

    PROCEDURE update_report_description_status(
        p_id                IN VARCHAR2,
        p_status            IN VARCHAR2
    );

    PROCEDURE get_report_regression(
        p_description_id  IN VARCHAR2 DEFAULT NULL,
        p_sample_query_id IN VARCHAR2 DEFAULT NULL,
        p_is_new_report       IN BOOLEAN DEFAULT FALSE,
        p_force               IN BOOLEAN,
        p_json                OUT JSON
    );

    FUNCTION get_report_id_by_title(
        p_title IN VARCHAR2
    ) RETURN VARCHAR2;

    FUNCTION get_desc_id_by_report_id_version(
        p_report_id    IN VARCHAR2,
        p_version      IN NUMBER
    ) RETURN VARCHAR2;

    FUNCTION get_report_status_by_id (
        p_report_id     IN VARCHAR2
    ) RETURN VARCHAR2;

    FUNCTION get_report_match_document_by_id(
        p_report_id         VARCHAR2
    ) RETURN CLOB;

    PROCEDURE purge_reports(
        p_domain        IN VARCHAR2,
        p_timestamp     IN TIMESTAMP DEFAULT NULL,
        p_hit_limit     IN NUMBER DEFAULT NULL,
        p_action        IN VARCHAR2 DEFAULT 'COUNT',
        p_num_reports   OUT NUMBER
    );
    
END lang_data_reports_pkg;
/
