Rem
Rem $Header: dbgendev/src/langdata/plsql/errors/errors_pkg.pkb /main/18 2025/08/13 01:29:21 jiangnhu Exp $
Rem
Rem errors_pkg.pkb
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      errors_pkg.pkb - Package Body of errors_pkg.
Rem
Rem    DESCRIPTION
Rem      Contains the definition of the package with prcoedures to manage the
Rem      errors and exceptions in the PL/SQL packages of Lang-Data.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/errors/errors_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jiangnhu    07/29/25 - Add c_invalid_llm_response
Rem    deveverm    07/15/25 - DBAI-1050: added get_message
Rem    deveverm    07/09/25 - DBAI-976: replaced c_embedding_model_not_found
Rem                           with c_resource_already_exists
Rem    dadoshi     07/09/25 - Remove c_index_still_exists_timeout exception
Rem    dadoshi     07/07/25 - JIRA_DBAI1022: Remove
Rem                           c_incompatible_database_version,
Rem                           c_migration_needed, and
Rem                           c_schema_version_not_setup exceptions
Rem    fgurrola    06/27/25 - DBAI-776: Added error code for unsupported
Rem                           name entity error.
Rem    deveverm    06/02/25 - DBAI-794: added error codes for OCI related
Rem                           errors
Rem    saloshah    05/26/25 - DBAI-746: Added the row lock timeout code
Rem    deveverm    05/16/25 - added error for failed job creation
Rem    pryarla     05/15/25 - DBAI-737: Add invalid profile error for llm
Rem    deveverm    04/17/25 - DBAI-735: added error codes for OCI embedding
Rem                           generation
Rem    jiangnhu    04/01/25 - Add c_enumeration_limit_exceeded
Rem    jiangnhu    02/24/25 - Add c_index_still_exists_timeout
Rem    jiangnhu    02/14/25 -  DBAI-575: Remove c_unknown_exception_code
Rem    dadoshi     10/25/24 - Add new errors
Rem    pryarla     10/16/24 - Created
Rem

create or replace package body lang_data_errors_pkg is
    -- Error Messages Mapping
    type error_map_type is
        table of varchar2(4000) index by binary_integer;
    g_error_map error_map_type;

    -- Initialize Error Messages
    procedure initialize_error_messages is
    begin
        g_error_map(c_unauthorized_code) := 
            'User does not have required privilege';
        g_error_map(c_invalid_parameters_code) := 
            'Invalid Parameters';
        g_error_map(c_max_text_length_exceeded) := 
            'Query too long';
        g_error_map(c_resource_not_found) := 
            'Resource not found';
        g_error_map(c_invalid_match_document) := 
            'Match Document Invalid';
        g_error_map(c_resource_already_exists) := 
            'Resource already exists';
        g_error_map(c_description_invalid_deletion) := 
            'Cannot delete the only description of the document';
        g_error_map(c_invalid_update) := 
            'Invalid Update to the database.';
        g_error_map(c_enumeration_limit_exceeded) := 
            'Exceeded enumeration limit for value vector generation';
        g_error_map(c_invalid_dbms_cloud_ai_profile) :=
            'Invalid DBMS_CLOUD_AI profile';
        g_error_map(c_row_lock_timeout) := 
            'Unable to acquire lock on row within time';
        g_error_map(c_ACL_not_configured) := 
            'Model Endpoint not configured to access via ACL.'||
            ' Please run following block as sysdba to add model endpoint to the ACL:'||
'BEGIN
    DBMS_NETWORK_ACL_ADMIN.APPEND_HOST_ACE(
        HOST => ''inference.generativeai.us-chicago-1.oci.oraclecloud.com'',
        ACE => XS$ACE_TYPE(PRIVILEGE_LIST => xs$name_list(''http''),
        PRINCIPAL_NAME => ''LANGDATA'',
        PRINCIPAL_TYPE => xs_acl.ptype_db
        )
    );
END;';
        g_error_map(c_OCI_credential_not_set) :=
            'Database credential for OCI not set';        
        g_error_map(c_OCI_GenAI_endpoint_not_set) :=
            'GenAI endpoint not set';
        g_error_map(c_OCI_compartment_not_set) :=
            'OCI compartment ID is not set';
        g_error_map(c_OCI_region_not_set) :=
            'OCI region code is not set';
        g_error_map(c_invalid_domain) :=
            'Domain not found';
        g_error_map(c_job_creation_failed) := 
            'Failed to create the requrired job';
        g_error_map(c_unsupported_entity_type) :=
            'Found an Unsupported Entity type.';
        g_error_map(c_invalid_llm_response) := 
            'Invalid or malformed LLM response.';
    end initialize_error_messages;


    -- Procedure to raise an error with an error code
    procedure raise_error (
        p_error_code in number
    ) is
        l_error_msg varchar2(4000);
    begin
        -- Get the error message from the map
        l_error_msg := g_error_map(p_error_code);

        -- Raise the error with the message
        raise_application_error(
                               p_error_code,
                               l_error_msg
        );
    end raise_error;

    function get_message(p_code in number) return varchar2 is
    begin
        return g_error_map(p_code);
    end;


begin
    -- Initialize error messages when the package is first loaded
    initialize_error_messages;
end lang_data_errors_pkg;
/

