Rem
Rem $Header: dbgendev/src/langdata/install/install_oml4py.sql /main/2 2025/05/13 18:51:55 dadoshi Exp $
Rem
Rem install_oml4py.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      install_oml4py.sql - This file installs OML4Py in cdb$root and a pdb.
Rem
Rem    DESCRIPTION
Rem         This file installs OML4Py in cdb$root and required pdb, logs are
Rem         created at script_dir path (install_root_log.txt and 
Rem         install_pdb_log.txt)
Rem         Usage: @install_oml4py.sql <pdb_name> <script_dir> <python_dir>
Rem             pdb_name: PDB where oml4py is intended to be used.
Rem             script_dir: DIR path for this file, this is needed to store log
Rem             python_dir: PYTHONHOME path, usually this is 
Rem                         $ORACLE_HOME/python
Rem
Rem    NOTES
Rem     NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/install_oml4py.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     04/29/25 - Add OML4PY_SERVER_DIR argument for absolute path
Rem    deveverm    02/05/25 - Created
Rem

DEFINE PDB_NAME = '&1'
DEFINE SCRIPT_DIR = '&2'
DEFINE PYTHON_DIR = '&3'
DEFINE OML4PY_SERVER_DIR='&4'

-- Enable script to exit on error
WHENEVER SQLERROR EXIT SQL.SQLCODE

-- Install OML4PY in the root container
ALTER SESSION SET CONTAINER=cdb$root;
spool &SCRIPT_DIR/install_root_log.txt
show con_name;
show parameter service_name;
select 'Installing OML4Py in cdb$root' from dual;
@&OML4PY_SERVER_DIR/pyqcfg.sql SYSAUX TEMP &PYTHON_DIR
spool off;

ALTER SESSION SET CONTAINER=&PDB_NAME;
spool &SCRIPT_DIR/install_pdb_log.txt
show con_name;
show parameter service_name;
select 'Installing OML4Py in pdb' from dual;
@&OML4PY_SERVER_DIR/pyqcfg.sql SYSAUX TEMP &PYTHON_DIR
spool off;

select * from sys.pyq_config;
