Rem
Rem $Header: dbgendev/src/langdata/install/create_user_grants.sql /main/8 2025/06/30 17:14:25 deveverm Exp $
Rem
Rem create_user_grants.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      create_user_grants.sql - SQL Script to grant LANG_DATA roles.
Rem
Rem    DESCRIPTION
Rem      This SQL script grants the LANGDATA user, the LANG_DATA_USER and
Rem      LANG_DATA_APP_EXPERT roles.
Rem
Rem    NOTES
Rem      Usage:
Rem         @create_user_grants <user_name> <lang_data_app_expert/lang_data_user> <pdb_name>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/create_user_grants.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pryarla     05/20/25 - Bug fix
Rem    arevathi    05/19/25 - Remove user level grants
Rem    dadoshi     05/14/25 - Add parameter for PDB (sqlcl)
Rem    arevathi    04/18/25 - Add parameter for roles
Rem    jiangnhu    03/06/25 - Created
Rem


-- Enable script to exit on error
WHENEVER SQLERROR EXIT SQL.SQLCODE

DEFINE USERNAME = '&1';
DEFINE ROLE = '&2';

-- For SQLcl Integration
DEFINE PDB_NAME = '&3';
alter session set container=&PDB_NAME;
ALTER SESSION SET CURRENT_SCHEMA = LANGDATA;

BEGIN
    IF LOWER('&ROLE') = 'lang_data_app_expert' THEN
        EXECUTE IMMEDIATE 'GRANT lang_data_app_expert to &USERNAME';
    ELSIF LOWER('&ROLE') = 'lang_data_user' THEN
        EXECUTE IMMEDIATE 'GRANT lang_data_user to &USERNAME';
    END IF;
END;
/
