/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands.config;

import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import oracle.dbtools.extension.langdata.commands.ConfigMessages;
import oracle.dbtools.extension.langdata.commands.InitMessages;
import oracle.dbtools.extension.langdata.commands.handler.CommandInterface;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.extension.langdata.core.exceptions.LangDataException;
import oracle.dbtools.extension.langdata.core.messages.GeneralMessages;
import oracle.dbtools.extension.langdata.core.utils.ConfigUtils;
import oracle.dbtools.extension.langdata.core.utils.LangUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block16: {
            try {
                LangDataConfig.setupDebugVerbose(parsedCommand);
                String version = LangUtils.getLangdataVersion(conn);
                if (version == null) {
                    GeneralMessages.errorMessage(InitMessages.getString("LANGDATA_NOT_INSTALLED"));
                    ctx.writeln(InitMessages.getString("LANGDATA_INSTALL_INSTRUCTIONS"));
                    break block16;
                }
                boolean list = parsedCommand.isFlagSet((Id)LangDataOptions.Symbols.LIST);
                boolean json = parsedCommand.isFlagSet((Id)LangDataOptions.Symbols.JSON);
                String name = (String)parsedCommand.getOptionValue((Id)LangDataOptions.Symbols.NAME);
                if (list) {
                    if (name != null) {
                        HashMap<Object, Object> configParameters = new HashMap();
                        HashMap<String, String> matchingParams = new HashMap<String, String>();
                        try {
                            configParameters = ConfigUtils.getLangdataConfig(conn);
                        }
                        catch (Exception e) {
                            if (LangDataConfig.isDebug()) {
                                LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
                            }
                            LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
                        }
                        for (String string : configParameters.keySet()) {
                            if (!string.contains(name)) continue;
                            matchingParams.put(string, (String)configParameters.get(string));
                        }
                        if (!json) {
                            ConfigUtils.printConfigTable(matchingParams);
                        } else {
                            ConfigUtils.printConfigListJson(matchingParams);
                        }
                        break block16;
                    }
                    try {
                        HashMap<String, String> matchingParams = ConfigUtils.getLangdataConfig(conn);
                        if (!json) {
                            ConfigUtils.printConfigTable(matchingParams);
                            break block16;
                        }
                        ConfigUtils.printConfigListJson(matchingParams);
                    }
                    catch (Exception e) {
                        if (LangDataConfig.isDebug()) {
                            LangDataConfig.getCurrentContext().writeln(Arrays.toString(e.getStackTrace()));
                            break block16;
                        }
                        LangDataConfig.getCurrentContext().writeln(e.getLocalizedMessage());
                    }
                    break block16;
                }
                throw new LangDataException(ConfigMessages.getString("LIST_OPTION_NOT_PROVIDED"));
            }
            catch (LangDataException e) {
                if (LangDataConfig.isDebug()) {
                    ctx.writeln(Arrays.toString(e.getStackTrace()));
                }
                ctx.writeln(e.getLocalizedMessage());
            }
        }
    }
}

