/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.langdata.commands;

import java.sql.Connection;
import oracle.dbtools.extension.langdata.Messages;
import oracle.dbtools.extension.langdata.commands.handler.CommandHandler;
import oracle.dbtools.extension.langdata.commands.handler.LangDataOptions;
import oracle.dbtools.extension.langdata.core.LangDataConfig;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class LangDataCommand
extends ParsedCommandListener {
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        Id command = parsedCommand.getType().getId();
        LangDataConfig.setupDebugVerbose(parsedCommand);
        if (conn == null) {
            ctx.write(Messages.getString("NOT_CONNECTED") + System.lineSeparator());
            return true;
        }
        if (LangDataOptions.Symbols.INIT == command) {
            CommandHandler.InitCommand(conn, ctx, cmd, parsedCommand);
        } else if (LangDataOptions.Symbols.VERSION == command) {
            CommandHandler.VersionCommand(conn, ctx, cmd, parsedCommand);
        } else if (LangDataOptions.Symbols.CONFIG == command) {
            CommandHandler.ConfigCommand(conn, ctx, cmd, parsedCommand);
        } else if (LangDataOptions.Symbols.SET == command) {
            CommandHandler.ConfigSetCommand(conn, ctx, cmd, parsedCommand);
        } else if (LangDataOptions.Symbols.EXPORT == command) {
            CommandHandler.ConfigExportCommand(conn, ctx, cmd, parsedCommand);
        } else if (LangDataOptions.Symbols.IMPORT == command) {
            CommandHandler.ConfigImportCommand(conn, ctx, cmd, parsedCommand);
        }
        return true;
    }

    protected Type createType() {
        return LangDataOptions.commandType;
    }
}

