/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.transfer.location;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.raptor.ssh.core.ConfigFile;
import oracle.dbtools.raptor.ssh.core.KnownHosts;
import oracle.dbtools.transfer.TransferManager;
import oracle.dbtools.transfer.TransferMessages;
import oracle.dbtools.transfer.file.FileInfo;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.SshSessionLocation;
import oracle.dbtools.transfer.task.TransferRestartRequest;
import oracle.dbtools.transfer.task.TransferTaskProgressMonitor;
import oracle.dbtools.transfer.utility.InputStreamProgressWrapper;
import oracle.dbtools.transfer.utility.MD5;
import oracle.dbtools.transfer.utility.ScriptOutput;
import oracle.dbtools.transfer.utility.SimpleByteProgressMonitor;
import oracle.dbtools.transfer.validation.DataFileScriptGenerator;
import oracle.dbtools.util.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.config.keys.ClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpFileSystemProvider;

public class SshLocation
extends Location {
    private static final Class<?> clazz = SshLocation.class;
    private SshClient sshClient = SshClient.setUpDefaultClient();
    private String host;
    private int port;
    private String user;
    private String keyFile;
    private String userData;
    private int timeout = 15000;
    protected ClientSession session;
    private SftpFileSystem sftpFileSystem;

    public SshLocation(String host, int port, String user, String keyFile) {
        this();
        this.host = host;
        this.port = port;
        this.user = user;
        this.keyFile = keyFile;
    }

    protected SshLocation() {
        this.sshClient.setServerKeyVerifier(KnownHosts.DEFAULT_LENIENT.getServerKeyVerifier());
        this.sshClient.setHostConfigEntryResolver(ConfigFile.DEFAULT.getHostConfigEntryResolver());
        this.sshClient.setIoServiceFactoryFactory(BuiltinIoServiceFactoryFactories.NIO2.create());
        this.sshClient.start();
    }

    protected void init(ClientSession session) {
        SocketAddress connectAddress = session.getConnectAddress();
        if (connectAddress instanceof InetSocketAddress) {
            InetSocketAddress inetAddr = (InetSocketAddress)connectAddress;
            this.host = inetAddr.getHostString();
            this.port = inetAddr.getPort();
        }
        this.user = session.getUsername();
    }

    @Override
    protected void connectImpl() throws IOException {
        if (null == this.session) {
            throw new UnsupportedOperationException("Password must be set before calling connect");
        }
        if (!this.session.isAuthenticated()) {
            this.session.auth().verify((long)this.timeout);
            Logger.info(clazz, (String)String.valueOf(this));
        }
        if (null == this.sftpFileSystem) {
            SftpFileSystemProvider fsProvider = new SftpFileSystemProvider(this.sshClient);
            String fsIdentifier = SftpFileSystemProvider.getFileSystemIdentifier((ClientSession)this.session);
            this.sftpFileSystem = fsProvider.getFileSystem(fsIdentifier);
            if (null == this.sftpFileSystem) {
                this.sftpFileSystem = fsProvider.newFileSystem(this.session);
            }
        }
    }

    public void setPassword(String password) throws IOException {
        try {
            if (null == this.session) {
                this.session = (ClientSession)((ConnectFuture)this.sshClient.connect(this.user, this.host, this.port).verify((long)this.timeout)).getSession();
                if (this.keyFile != null && !this.keyFile.isEmpty()) {
                    KeyIdentityProvider kip = this.sshClient.getKeyIdentityProvider();
                    Path p = Paths.get(new File(this.keyFile).getAbsolutePath(), new String[0]);
                    kip = new ClientIdentitiesWatcher(Collections.singletonList(p), () -> ((SshClient)this.sshClient).getClientIdentityLoader(), () -> FilePasswordProvider.of((String)password), true);
                    this.session.setKeyIdentityProvider(kip);
                } else {
                    this.session.addPasswordIdentity(password);
                    this.session.setKeyIdentityProvider(KeyIdentityProvider.EMPTY_KEYS_PROVIDER);
                    this.userData = password;
                }
                Logger.fine(clazz, (String)("Session created: " + String.valueOf(this.session)));
            }
        }
        catch (Exception e) {
            String msg = "Unable to create session";
            Logger.severe(clazz, (String)msg, (Throwable)e);
            throw new IOException(msg, e);
        }
    }

    @Override
    public SshLocation clone() {
        SshLocation clone = new SshLocation(this.host, this.port, this.user, this.keyFile);
        try {
            clone.setPassword(this.userData);
        }
        catch (IOException e) {
            Logger.severe(clazz, (String)"Unable to get new session");
            clone = null;
        }
        return clone;
    }

    @Override
    public void disconnect() {
        if (this.session != null) {
            this.session.close(false);
            try {
                this.sftpFileSystem.close();
            }
            catch (IOException e) {
                Logger.ignore(clazz, (Throwable)e);
            }
            this.sftpFileSystem = null;
            Logger.fine(clazz, (String)String.valueOf(this));
        }
    }

    @Override
    public InputStream asInputStream(Path path, long position, long size) throws IOException {
        return this.asInputStream(path, position, size, null);
    }

    private InputStream asInputStream(Path path, long position, long size, TransferTaskProgressMonitor progressMonitor) throws IOException {
        InputStream in = null;
        try {
            Path tgtPath = this.sftpFileSystem.getPath(path.toString(), new String[0]);
            in = Files.newInputStream(tgtPath, new OpenOption[0]);
            in = new InputStreamChunk(in, position, size);
            if (progressMonitor != null) {
                in = new InputStreamProgressWrapper(in, progressMonitor, size > 0L ? size : (long)in.available());
            }
        }
        catch (Exception e) {
            throw SshLocation.asIOException(e);
        }
        return in;
    }

    @Override
    public MD5 getMd5(Path path, long offset, long size) {
        throw new UnsupportedOperationException("Target usage only! TODO: Support as source?");
    }

    public long copy(InputStream in, String target, CopyOption ... options) throws IOException {
        return this.copy(in, target, (TransferTaskProgressMonitor)null, options);
    }

    @Override
    public long copy(InputStream in, String target, TransferTaskProgressMonitor aMonitor, CopyOption ... options) throws IOException {
        Logger.fine(clazz, (String)(String.valueOf(in) + ", " + target + ", " + Arrays.toString(options)));
        assert (this.session != null && this.session.isOpen());
        long written = 0L;
        long len = in.available();
        double size = (double)len / 1048576.0;
        Logger.info(clazz, (String)(String.valueOf(in) + ", " + target + ", " + Arrays.toString(options) + ", len=" + size + " MiB"));
        try {
            InputStreamProgressWrapper inw;
            boolean overwrite;
            Path tgtPath = this.sftpFileSystem.getPath(target, new String[0]);
            long alreadySent = 0L;
            boolean bl = overwrite = null == options || 0 == options.length;
            if (null != options && options.length > 0) {
                for (CopyOption option : options) {
                    if (StandardCopyOption.REPLACE_EXISTING != option) continue;
                    overwrite = true;
                    break;
                }
            }
            if (!overwrite) {
                try {
                    BasicFileAttributes attrs = Files.readAttributes(tgtPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                    alreadySent = attrs.size();
                }
                catch (Exception e) {
                    Logger.ignore(clazz, (Throwable)e);
                }
            }
            if (alreadySent > 0L) {
                Logger.info(clazz, (String)(target + " exists, skipping " + alreadySent + " bytes."));
                in.skip(alreadySent);
                inw = new InputStreamProgressWrapper(in, aMonitor, in.available());
                OutputStream os = Files.newOutputStream(tgtPath, StandardOpenOption.APPEND);
                written = IoUtils.copy((InputStream)inw, (OutputStream)os);
            } else {
                inw = new InputStreamProgressWrapper(in, aMonitor, in.available());
                written = Files.copy(inw, tgtPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            String msg = "Unable to copy to " + target;
            Logger.fine(clazz, (String)msg, (Throwable)e);
            throw SshLocation.asIOException(e);
        }
        Logger.fine(clazz, (String)(written + " bytes written"));
        return written;
    }

    public static void main(String[] args) {
        TransferManager.INSTANCE.setPackageLogStream(System.out, false);
        TransferManager.INSTANCE.setPackageLogLevel(Level.ALL);
        SshLocation sshLocation = null;
        try {
            sshLocation = new SshLocation("den01ehq.us.oracle.com", 22, "bjeffrie", null);
            sshLocation.setPassword("");
            sshLocation.connect();
            sshLocation.testRoundTripIO("sqldev");
            sshLocation.logExecuteScript("ls -als", "ls -als", SshLocation.getTestFileName(".sh"), "./");
            SshSessionLocation sshSessionLocation = new SshSessionLocation(sshLocation.session);
            sshSessionLocation.connect();
            sshSessionLocation.testRoundTripIO("sqldev");
            sshSessionLocation.logExecuteScript("ls -als", "ls -als", SshLocation.getTestFileName(".sh"), "./");
            sshSessionLocation.disconnect();
            sshLocation.testRoundTripIO("sqldev");
            sshLocation.logExecuteScript("ls -als", "ls -als", SshLocation.getTestFileName(".sh"), "./");
            sshLocation.disconnect();
            sshLocation = new SshLocation("den01ehq.us.oracle.com", 22, "bjeffrie", "/Users/bjeffrie/.ssh/id_rsa");
            sshLocation.setPassword("");
            sshLocation.connect();
            sshLocation.testRoundTripIO("sqldev");
            sshLocation.logExecuteScript("ls -als", "ls -als", SshLocation.getTestFileName(".sh"), "./");
            sshLocation.disconnect();
        }
        catch (Exception e) {
            Logger.severe(clazz, (String)"", (Throwable)e);
        }
    }

    protected void testRoundTripIO(String bucketName) throws IOException {
        Logger.info(this.getClass(), (String)"testRoundTripIO");
        try {
            String out = "The wizard quickly jinxed the gnomes before they vaporized";
            ByteArrayInputStream source = new ByteArrayInputStream(out.getBytes(StandardCharsets.UTF_8));
            String target = SshLocation.getTestFileName(".pangram");
            this.copy((InputStream)source, target, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
            InputStream in = this.asInputStream(Paths.get(target, new String[0]), 0L, 0L, new SimpleByteProgressMonitor());
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    sb.append((char)c);
                }
            }
            Path tgtPath = this.sftpFileSystem.getPath(target, new String[0]);
            Files.deleteIfExists(tgtPath);
            if (out.equals(sb.toString())) {
                Logger.info(this.getClass(), (String)"testRoundTripIO - PASSED");
            } else {
                Logger.warn(this.getClass(), (String)"testRoundTripIO - FAILED");
            }
        }
        catch (Throwable t) {
            throw SshLocation.asIOException(t);
        }
    }

    private static String getTestFileName(String ext) {
        String fname = "SshLocationTest";
        try {
            File file = File.createTempFile(fname, ext);
            fname = file.getName();
            file.delete();
        }
        catch (Exception e) {
            Logger.severe(clazz, (String)fname, (Throwable)e);
        }
        return fname;
    }

    private long copyExecutable(InputStream input, String fqScriptName) throws IOException {
        Logger.fine(clazz, (String)(String.valueOf(input) + ", " + fqScriptName));
        long written = this.copy(input, fqScriptName, new SimpleByteProgressMonitor(), StandardCopyOption.REPLACE_EXISTING);
        Path tgtPath = this.sftpFileSystem.getPath(fqScriptName, new String[0]);
        Files.setPosixFilePermissions(tgtPath, EnumSet.of(PosixFilePermission.OWNER_EXECUTE, new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_WRITE}));
        return written;
    }

    @Override
    public boolean verifySize(String path, long size) {
        Logger.fine(clazz, (String)(path + ", size=" + size));
        boolean verified = false;
        try {
            Path tgtPath = this.sftpFileSystem.getPath(path, new String[0]);
            BasicFileAttributes attrs = Files.readAttributes(tgtPath, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            verified = size == attrs.size();
        }
        catch (Exception e) {
            Logger.severe(clazz, (String)"Unable to stat size.", (Throwable)e);
        }
        Logger.fine(clazz, (String)String.valueOf(verified));
        return verified;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTargetScript(List<FileInfo> fileInfos) {
        return null;
    }

    @Override
    public ScriptOutput executeScript(String script, String scriptName, String targetDir) {
        assert (script != null);
        Logger.finer(clazz, (String)("script = \"" + script + "\""));
        String myScript = script + "\nexit $?\n";
        ScriptOutput scriptOutput = new ScriptOutput();
        try (ClientChannel shell = this.session.createChannel("shell");){
            ByteArrayInputStream input = new ByteArrayInputStream(myScript.getBytes());
            String fqScriptName = targetDir + scriptName;
            this.copyExecutable(input, fqScriptName);
            myScript = fqScriptName + "\nexit $?\n";
            input = new ByteArrayInputStream(myScript.getBytes());
            ByteArrayOutputStream stdout = new ByteArrayOutputStream(2048);
            ByteArrayOutputStream stderr = new ByteArrayOutputStream(2048);
            shell.setIn((InputStream)input);
            shell.setOut((OutputStream)stdout);
            shell.setErr((OutputStream)stderr);
            shell.open();
            do {
                Thread.sleep(125L);
            } while (!shell.isEofSignalled());
            scriptOutput.stdout = stdout.toString();
            scriptOutput.stderr = stderr.toString();
            scriptOutput.rc = shell.getExitStatus();
            shell.close();
        }
        catch (Exception e) {
            Logger.severe(clazz, (String)"Unable to execute script.", (Throwable)e);
        }
        return scriptOutput;
    }

    @Override
    public String toString() {
        return this.user + "@" + this.host + " " + super.toString();
    }

    @Override
    public boolean doPreProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException {
        String logFile = transferId + ".log";
        String scriptName = transferId + ".bash";
        ScriptOutput result = null;
        try {
            String executeScriptStr = DataFileScriptGenerator.generatePreTransferScript(fileInfos, targetDir, logFile);
            result = this.logExecuteScript("doPreprocessingOnTarget", executeScriptStr, scriptName, targetDir);
            DataFileScriptGenerator.evaluate(fileInfos, result);
            if (result.rc == 5) {
                executeScriptStr = DataFileScriptGenerator.generateChunkCheckScript(fileInfos, targetDir, logFile);
                result = this.logExecuteScript("doRequestedChunkChecks", executeScriptStr, scriptName, targetDir);
                DataFileScriptGenerator.evaluate(fileInfos, result);
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            String msg = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.fail");
            if (result != null && result.rc == 6) {
                msg = TransferMessages.getString("TransferControlTask.doPreprocessingOnTarget.noSpace");
                throw new IOException(msg, t);
            }
            if (result == null || result.rc != 7) {
                Logger.warn(clazz, (String)msg, (Throwable)t);
            }
            return false;
        }
    }

    @Override
    public void doPostProcessing(String transferId, List<FileInfo> fileInfos, String targetDir) throws IOException, TransferRestartRequest {
        String logFile = transferId + ".log";
        String scriptName = transferId + ".bash";
        String executeScriptStr = DataFileScriptGenerator.generatePostTransferScript(fileInfos, targetDir, logFile);
        ScriptOutput result = this.logExecuteScript("doPostprocessingOnTarget", executeScriptStr, scriptName, targetDir);
        DataFileScriptGenerator.evaluate(fileInfos, result);
    }

    static class InputStreamChunk
    extends FilterInputStream {
        private long size;
        private long count = 0L;
        private long mark = -1L;
        private static final int EOF = -1;

        public InputStreamChunk(InputStream in, long position, long size) throws IOException {
            super(in);
            in.skip(position);
            this.size = size;
        }

        @Override
        public int read() throws IOException {
            if (this.size > 0L && this.count >= this.size) {
                return -1;
            }
            int result = super.read();
            ++this.count;
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.size > 0L && this.count >= this.size) {
                return -1;
            }
            long max = this.size > 0L ? Math.min((long)len, this.size - this.count) : (long)len;
            int actual = super.read(b, off, (int)max);
            this.count += (long)actual;
            return actual;
        }

        @Override
        public long skip(long n) throws IOException {
            long max = this.size > 0L ? Math.min(n, this.size - this.count) : n;
            long actual = super.skip(max);
            this.count += actual;
            return actual;
        }

        @Override
        public int available() throws IOException {
            if (this.size > 0L && this.count >= this.size) {
                return 0;
            }
            return super.available();
        }

        @Override
        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
            this.count = this.mark;
        }
    }
}

