/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.objectstorage;

import java.nio.file.Path;
import java.nio.file.Paths;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageOptions;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ObjectStorageModel {
    private final ScriptRunnerContext ctx;
    private final ParsedCommand parsedCommand;
    private final OCIProfile profile;

    public ObjectStorageModel(ScriptRunnerContext ctx, ParsedCommand parsedCommand, OCIProfile profile) {
        this.ctx = ctx;
        this.parsedCommand = parsedCommand;
        this.profile = profile;
    }

    public String bucketName() {
        String bucketname = (String)this.parsedCommand.getOptionValue((Id)ObjectStorageOptions.Symbol.BUCKET_NAME);
        if (bucketname == null) {
            bucketname = (String)this.ctx.getProperty("oci.bucket.name");
        }
        return bucketname;
    }

    public ScriptRunnerContext context() {
        return this.ctx;
    }

    public Path filePath() {
        String file = (String)this.parsedCommand.getOptionValue((Id)ObjectStorageOptions.Symbol.FILE);
        if (file != null) {
            Path filePath = Paths.get(file, new String[0]);
            Path absolutePath = filePath.toAbsolutePath();
            return absolutePath;
        }
        return null;
    }

    public String namespace() {
        String namespace = (String)this.parsedCommand.getOptionValue((Id)ObjectStorageOptions.Symbol.NAMESPACE);
        if (namespace == null) {
            namespace = (String)this.ctx.getProperty("oci.namespace.name");
        }
        return namespace;
    }

    public String optionValue(ObjectStorageOptions.Symbol parameter) {
        return (String)this.parsedCommand.getOptionValue((Id)parameter);
    }

    public boolean optionBooleanValue(ObjectStorageOptions.Symbol parameter) {
        if (ObjectStorageOptions.Symbol.OVERWRITE == parameter) {
            if (this.parsedCommand.getOptionValue((Id)parameter) == null) {
                return true;
            }
        } else if (this.parsedCommand.getOptionValue((Id)parameter) == null) {
            return false;
        }
        boolean value = (Boolean)this.parsedCommand.getOptionValue((Id)parameter);
        return value;
    }

    public OCIProfile profile() {
        return this.profile;
    }
}

